// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.servicediscovery.auth.DefaultServiceDiscoveryAuthSchemeProvider
import aws.sdk.kotlin.services.servicediscovery.auth.ServiceDiscoveryAuthSchemeProvider
import aws.sdk.kotlin.services.servicediscovery.endpoints.DefaultServiceDiscoveryEndpointProvider
import aws.sdk.kotlin.services.servicediscovery.endpoints.ServiceDiscoveryEndpointParameters
import aws.sdk.kotlin.services.servicediscovery.endpoints.ServiceDiscoveryEndpointProvider
import aws.sdk.kotlin.services.servicediscovery.model.CreateHttpNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.CreateHttpNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.CreatePrivateDnsNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.CreatePublicDnsNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.CreatePublicDnsNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.CreateServiceRequest
import aws.sdk.kotlin.services.servicediscovery.model.CreateServiceResponse
import aws.sdk.kotlin.services.servicediscovery.model.DeleteNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.DeleteNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.DeleteServiceRequest
import aws.sdk.kotlin.services.servicediscovery.model.DeleteServiceResponse
import aws.sdk.kotlin.services.servicediscovery.model.DeregisterInstanceRequest
import aws.sdk.kotlin.services.servicediscovery.model.DeregisterInstanceResponse
import aws.sdk.kotlin.services.servicediscovery.model.DiscoverInstancesRequest
import aws.sdk.kotlin.services.servicediscovery.model.DiscoverInstancesResponse
import aws.sdk.kotlin.services.servicediscovery.model.DiscoverInstancesRevisionRequest
import aws.sdk.kotlin.services.servicediscovery.model.DiscoverInstancesRevisionResponse
import aws.sdk.kotlin.services.servicediscovery.model.GetInstanceRequest
import aws.sdk.kotlin.services.servicediscovery.model.GetInstanceResponse
import aws.sdk.kotlin.services.servicediscovery.model.GetInstancesHealthStatusRequest
import aws.sdk.kotlin.services.servicediscovery.model.GetInstancesHealthStatusResponse
import aws.sdk.kotlin.services.servicediscovery.model.GetNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.GetNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.GetOperationRequest
import aws.sdk.kotlin.services.servicediscovery.model.GetOperationResponse
import aws.sdk.kotlin.services.servicediscovery.model.GetServiceRequest
import aws.sdk.kotlin.services.servicediscovery.model.GetServiceResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListInstancesRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListInstancesResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListNamespacesRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListNamespacesResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListOperationsRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListOperationsResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListServicesRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListServicesResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.servicediscovery.model.RegisterInstanceRequest
import aws.sdk.kotlin.services.servicediscovery.model.RegisterInstanceResponse
import aws.sdk.kotlin.services.servicediscovery.model.TagResourceRequest
import aws.sdk.kotlin.services.servicediscovery.model.TagResourceResponse
import aws.sdk.kotlin.services.servicediscovery.model.UntagResourceRequest
import aws.sdk.kotlin.services.servicediscovery.model.UntagResourceResponse
import aws.sdk.kotlin.services.servicediscovery.model.UpdateHttpNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.UpdateHttpNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest
import aws.sdk.kotlin.services.servicediscovery.model.UpdateInstanceCustomHealthStatusResponse
import aws.sdk.kotlin.services.servicediscovery.model.UpdatePrivateDnsNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.UpdatePrivateDnsNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.UpdatePublicDnsNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.UpdatePublicDnsNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.UpdateServiceRequest
import aws.sdk.kotlin.services.servicediscovery.model.UpdateServiceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "ServiceDiscovery"
public const val SdkVersion: String = "1.0.56"
public const val ServiceApiVersion: String = "2017-03-14"

/**
 * # Cloud Map
 * With Cloud Map, you can configure public DNS, private DNS, or HTTP namespaces that your microservice applications run in. When an instance becomes available, you can call the Cloud Map API to register the instance with Cloud Map. For public or private DNS namespaces, Cloud Map automatically creates DNS records and an optional health check. Clients that submit public or private DNS queries, or HTTP requests, for the service receive an answer that contains up to eight healthy records.
 */
public interface ServiceDiscoveryClient : SdkClient {
    /**
     * ServiceDiscoveryClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ServiceDiscoveryClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ServiceDiscovery",
                "SERVICEDISCOVERY",
                "servicediscovery",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ServiceDiscoveryClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ServiceDiscoveryClient = DefaultServiceDiscoveryClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ServiceDiscoveryEndpointProvider = builder.endpointProvider ?: DefaultServiceDiscoveryEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ServiceDiscoveryAuthSchemeProvider = builder.authSchemeProvider ?: DefaultServiceDiscoveryAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ServiceDiscovery"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ServiceDiscoveryEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ServiceDiscoveryAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an HTTP namespace. Service instances registered using an HTTP namespace can be discovered using a `DiscoverInstances` request but can't be discovered using DNS.
     *
     * For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.CreateHttpNamespace.sample
     */
    public suspend fun createHttpNamespace(input: CreateHttpNamespaceRequest): CreateHttpNamespaceResponse

    /**
     * Creates a private namespace based on DNS, which is visible only inside a specified Amazon VPC. The namespace defines your service naming scheme. For example, if you name your namespace `example.com` and name your service `backend`, the resulting DNS name for the service is `backend.example.com`. Service instances that are registered using a private DNS namespace can be discovered using either a `DiscoverInstances` request or using DNS. For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.CreatePrivateDnsNamespace.sample
     */
    public suspend fun createPrivateDnsNamespace(input: CreatePrivateDnsNamespaceRequest): CreatePrivateDnsNamespaceResponse

    /**
     * Creates a public namespace based on DNS, which is visible on the internet. The namespace defines your service naming scheme. For example, if you name your namespace `example.com` and name your service `backend`, the resulting DNS name for the service is `backend.example.com`. You can discover instances that were registered with a public DNS namespace by using either a `DiscoverInstances` request or using DNS. For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     *
     * The `CreatePublicDnsNamespace` API operation is not supported in the Amazon Web Services GovCloud (US) Regions.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.CreatePublicDnsNamespace.sample
     */
    public suspend fun createPublicDnsNamespace(input: CreatePublicDnsNamespaceRequest): CreatePublicDnsNamespaceResponse

    /**
     * Creates a service. This action defines the configuration for the following entities:
     * + For public and private DNS namespaces, one of the following combinations of DNS records in Amazon Route 53:
     *    + `A`
     *    + `AAAA`
     *    + `A` and `AAAA`
     *    + `SRV`
     *    + `CNAME`
     * + Optionally, a health check
     *
     * After you create the service, you can submit a [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html) request, and Cloud Map uses the values in the configuration to create the specified entities.
     *
     * For the current quota on the number of instances that you can register using the same namespace and using the same service, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.CreateService.sample
     */
    public suspend fun createService(input: CreateServiceRequest): CreateServiceResponse

    /**
     * Deletes a namespace from the current account. If the namespace still contains one or more services, the request fails.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.DeleteNamespace.sample
     */
    public suspend fun deleteNamespace(input: DeleteNamespaceRequest): DeleteNamespaceResponse

    /**
     * Deletes a specified service. If the service still contains one or more registered instances, the request fails.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.DeleteService.sample
     */
    public suspend fun deleteService(input: DeleteServiceRequest): DeleteServiceResponse

    /**
     * Deletes the Amazon Route 53 DNS records and health check, if any, that Cloud Map created for the specified instance.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.DeregisterInstance.sample
     */
    public suspend fun deregisterInstance(input: DeregisterInstanceRequest): DeregisterInstanceResponse

    /**
     * Discovers registered instances for a specified namespace and service. You can use `DiscoverInstances` to discover instances for any type of namespace. `DiscoverInstances` returns a randomized list of instances allowing customers to distribute traffic evenly across instances. For public and private DNS namespaces, you can also use DNS queries to discover instances.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.DiscoverInstances.sample
     */
    public suspend fun discoverInstances(input: DiscoverInstancesRequest): DiscoverInstancesResponse

    /**
     * Discovers the increasing revision associated with an instance.
     */
    public suspend fun discoverInstancesRevision(input: DiscoverInstancesRevisionRequest): DiscoverInstancesRevisionResponse

    /**
     * Gets information about a specified instance.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.GetInstance.sample
     */
    public suspend fun getInstance(input: GetInstanceRequest): GetInstanceResponse

    /**
     * Gets the current health status (`Healthy`, `Unhealthy`, or `Unknown`) of one or more instances that are associated with a specified service.
     *
     * There's a brief delay between when you register an instance and when the health status for the instance is available.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.GetInstancesHealthStatus.sample
     */
    public suspend fun getInstancesHealthStatus(input: GetInstancesHealthStatusRequest): GetInstancesHealthStatusResponse

    /**
     * Gets information about a namespace.
     */
    public suspend fun getNamespace(input: GetNamespaceRequest): GetNamespaceResponse

    /**
     * Gets information about any operation that returns an operation ID in the response, such as a `CreateHttpNamespace` request.
     *
     * To get a list of operations that match specified criteria, see [ListOperations](https://docs.aws.amazon.com/cloud-map/latest/api/API_ListOperations.html).
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.GetOperation.sample
     */
    public suspend fun getOperation(input: GetOperationRequest): GetOperationResponse

    /**
     * Gets the settings for a specified service.
     */
    public suspend fun getService(input: GetServiceRequest): GetServiceResponse

    /**
     * Lists summary information about the instances that you registered by using a specified service.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.ListInstances.sample
     */
    public suspend fun listInstances(input: ListInstancesRequest): ListInstancesResponse

    /**
     * Lists summary information about the namespaces that were created by the current Amazon Web Services account.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.ListNamespaces.sample
     */
    public suspend fun listNamespaces(input: ListNamespacesRequest = ListNamespacesRequest { }): ListNamespacesResponse

    /**
     * Lists operations that match the criteria that you specify.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.ListOperations.sample
     */
    public suspend fun listOperations(input: ListOperationsRequest = ListOperationsRequest { }): ListOperationsResponse

    /**
     * Lists summary information for all the services that are associated with one or more specified namespaces.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.ListServices.sample
     */
    public suspend fun listServices(input: ListServicesRequest = ListServicesRequest { }): ListServicesResponse

    /**
     * Lists tags for the specified resource.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.ListTagsForResource.sample
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates or updates one or more records and, optionally, creates a health check based on the settings in a specified service. When you submit a `RegisterInstance` request, the following occurs:
     * + For each DNS record that you define in the service that's specified by `ServiceId`, a record is created or updated in the hosted zone that's associated with the corresponding namespace.
     * + If the service includes `HealthCheckConfig`, a health check is created based on the settings in the health check configuration.
     * + The health check, if any, is associated with each of the new or updated records.
     *
     * One `RegisterInstance` request must complete before you can submit another request and specify the same service ID and instance ID.
     *
     * For more information, see [CreateService](https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html).
     *
     * When Cloud Map receives a DNS query for the specified DNS name, it returns the applicable value:
     * + **If the health check is healthy**: returns all the records
     * + **If the health check is unhealthy**: returns the applicable value for the last healthy instance
     * + **If you didn't specify a health check configuration**: returns all the records
     *
     * For the current quota on the number of instances that you can register using the same namespace and using the same service, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.RegisterInstance.sample
     */
    public suspend fun registerInstance(input: RegisterInstanceRequest): RegisterInstanceResponse

    /**
     * Adds one or more tags to the specified resource.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.TagResource.sample
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.UntagResource.sample
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an HTTP namespace.
     */
    public suspend fun updateHttpNamespace(input: UpdateHttpNamespaceRequest): UpdateHttpNamespaceResponse

    /**
     * Submits a request to change the health status of a custom health check to healthy or unhealthy.
     *
     * You can use `UpdateInstanceCustomHealthStatus` to change the status only for custom health checks, which you define using `HealthCheckCustomConfig` when you create a service. You can't use it to change the status for Route 53 health checks, which you define using `HealthCheckConfig`.
     *
     * For more information, see [HealthCheckCustomConfig](https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html).
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.UpdateInstanceCustomHealthStatus.sample
     */
    public suspend fun updateInstanceCustomHealthStatus(input: UpdateInstanceCustomHealthStatusRequest): UpdateInstanceCustomHealthStatusResponse

    /**
     * Updates a private DNS namespace.
     */
    public suspend fun updatePrivateDnsNamespace(input: UpdatePrivateDnsNamespaceRequest): UpdatePrivateDnsNamespaceResponse

    /**
     * Updates a public DNS namespace.
     */
    public suspend fun updatePublicDnsNamespace(input: UpdatePublicDnsNamespaceRequest): UpdatePublicDnsNamespaceResponse

    /**
     * Submits a request to perform the following operations:
     * + Update the TTL setting for existing `DnsRecords` configurations
     * + Add, update, or delete `HealthCheckConfig` for a specified serviceYou can't add, update, or delete a `HealthCheckCustomConfig` configuration.
     *
     * For public and private DNS namespaces, note the following:
     * + If you omit any existing `DnsRecords` or `HealthCheckConfig` configurations from an `UpdateService` request, the configurations are deleted from the service.
     * + If you omit an existing `HealthCheckCustomConfig` configuration from an `UpdateService` request, the configuration isn't deleted from the service.
     *
     * When you update settings for a service, Cloud Map also updates the corresponding settings in all the records and health checks that were created by using the specified service.
     *
     * @sample aws.sdk.kotlin.services.servicediscovery.samples.UpdateService.sample
     */
    public suspend fun updateService(input: UpdateServiceRequest): UpdateServiceResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ServiceDiscoveryClient.withConfig(block: ServiceDiscoveryClient.Config.Builder.() -> Unit): ServiceDiscoveryClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultServiceDiscoveryClient(newConfig)
}

/**
 * Creates an HTTP namespace. Service instances registered using an HTTP namespace can be discovered using a `DiscoverInstances` request but can't be discovered using DNS.
 *
 * For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.CreateHttpNamespace.sample
 */
public suspend inline fun ServiceDiscoveryClient.createHttpNamespace(crossinline block: CreateHttpNamespaceRequest.Builder.() -> Unit): CreateHttpNamespaceResponse = createHttpNamespace(CreateHttpNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a private namespace based on DNS, which is visible only inside a specified Amazon VPC. The namespace defines your service naming scheme. For example, if you name your namespace `example.com` and name your service `backend`, the resulting DNS name for the service is `backend.example.com`. Service instances that are registered using a private DNS namespace can be discovered using either a `DiscoverInstances` request or using DNS. For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.CreatePrivateDnsNamespace.sample
 */
public suspend inline fun ServiceDiscoveryClient.createPrivateDnsNamespace(crossinline block: CreatePrivateDnsNamespaceRequest.Builder.() -> Unit): CreatePrivateDnsNamespaceResponse = createPrivateDnsNamespace(CreatePrivateDnsNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a public namespace based on DNS, which is visible on the internet. The namespace defines your service naming scheme. For example, if you name your namespace `example.com` and name your service `backend`, the resulting DNS name for the service is `backend.example.com`. You can discover instances that were registered with a public DNS namespace by using either a `DiscoverInstances` request or using DNS. For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
 *
 * The `CreatePublicDnsNamespace` API operation is not supported in the Amazon Web Services GovCloud (US) Regions.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.CreatePublicDnsNamespace.sample
 */
public suspend inline fun ServiceDiscoveryClient.createPublicDnsNamespace(crossinline block: CreatePublicDnsNamespaceRequest.Builder.() -> Unit): CreatePublicDnsNamespaceResponse = createPublicDnsNamespace(CreatePublicDnsNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a service. This action defines the configuration for the following entities:
 * + For public and private DNS namespaces, one of the following combinations of DNS records in Amazon Route 53:
 *    + `A`
 *    + `AAAA`
 *    + `A` and `AAAA`
 *    + `SRV`
 *    + `CNAME`
 * + Optionally, a health check
 *
 * After you create the service, you can submit a [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html) request, and Cloud Map uses the values in the configuration to create the specified entities.
 *
 * For the current quota on the number of instances that you can register using the same namespace and using the same service, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.CreateService.sample
 */
public suspend inline fun ServiceDiscoveryClient.createService(crossinline block: CreateServiceRequest.Builder.() -> Unit): CreateServiceResponse = createService(CreateServiceRequest.Builder().apply(block).build())

/**
 * Deletes a namespace from the current account. If the namespace still contains one or more services, the request fails.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.DeleteNamespace.sample
 */
public suspend inline fun ServiceDiscoveryClient.deleteNamespace(crossinline block: DeleteNamespaceRequest.Builder.() -> Unit): DeleteNamespaceResponse = deleteNamespace(DeleteNamespaceRequest.Builder().apply(block).build())

/**
 * Deletes a specified service. If the service still contains one or more registered instances, the request fails.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.DeleteService.sample
 */
public suspend inline fun ServiceDiscoveryClient.deleteService(crossinline block: DeleteServiceRequest.Builder.() -> Unit): DeleteServiceResponse = deleteService(DeleteServiceRequest.Builder().apply(block).build())

/**
 * Deletes the Amazon Route 53 DNS records and health check, if any, that Cloud Map created for the specified instance.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.DeregisterInstance.sample
 */
public suspend inline fun ServiceDiscoveryClient.deregisterInstance(crossinline block: DeregisterInstanceRequest.Builder.() -> Unit): DeregisterInstanceResponse = deregisterInstance(DeregisterInstanceRequest.Builder().apply(block).build())

/**
 * Discovers registered instances for a specified namespace and service. You can use `DiscoverInstances` to discover instances for any type of namespace. `DiscoverInstances` returns a randomized list of instances allowing customers to distribute traffic evenly across instances. For public and private DNS namespaces, you can also use DNS queries to discover instances.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.DiscoverInstances.sample
 */
public suspend inline fun ServiceDiscoveryClient.discoverInstances(crossinline block: DiscoverInstancesRequest.Builder.() -> Unit): DiscoverInstancesResponse = discoverInstances(DiscoverInstancesRequest.Builder().apply(block).build())

/**
 * Discovers the increasing revision associated with an instance.
 */
public suspend inline fun ServiceDiscoveryClient.discoverInstancesRevision(crossinline block: DiscoverInstancesRevisionRequest.Builder.() -> Unit): DiscoverInstancesRevisionResponse = discoverInstancesRevision(DiscoverInstancesRevisionRequest.Builder().apply(block).build())

/**
 * Gets information about a specified instance.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.GetInstance.sample
 */
public suspend inline fun ServiceDiscoveryClient.getInstance(crossinline block: GetInstanceRequest.Builder.() -> Unit): GetInstanceResponse = getInstance(GetInstanceRequest.Builder().apply(block).build())

/**
 * Gets the current health status (`Healthy`, `Unhealthy`, or `Unknown`) of one or more instances that are associated with a specified service.
 *
 * There's a brief delay between when you register an instance and when the health status for the instance is available.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.GetInstancesHealthStatus.sample
 */
public suspend inline fun ServiceDiscoveryClient.getInstancesHealthStatus(crossinline block: GetInstancesHealthStatusRequest.Builder.() -> Unit): GetInstancesHealthStatusResponse = getInstancesHealthStatus(GetInstancesHealthStatusRequest.Builder().apply(block).build())

/**
 * Gets information about a namespace.
 */
public suspend inline fun ServiceDiscoveryClient.getNamespace(crossinline block: GetNamespaceRequest.Builder.() -> Unit): GetNamespaceResponse = getNamespace(GetNamespaceRequest.Builder().apply(block).build())

/**
 * Gets information about any operation that returns an operation ID in the response, such as a `CreateHttpNamespace` request.
 *
 * To get a list of operations that match specified criteria, see [ListOperations](https://docs.aws.amazon.com/cloud-map/latest/api/API_ListOperations.html).
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.GetOperation.sample
 */
public suspend inline fun ServiceDiscoveryClient.getOperation(crossinline block: GetOperationRequest.Builder.() -> Unit): GetOperationResponse = getOperation(GetOperationRequest.Builder().apply(block).build())

/**
 * Gets the settings for a specified service.
 */
public suspend inline fun ServiceDiscoveryClient.getService(crossinline block: GetServiceRequest.Builder.() -> Unit): GetServiceResponse = getService(GetServiceRequest.Builder().apply(block).build())

/**
 * Lists summary information about the instances that you registered by using a specified service.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.ListInstances.sample
 */
public suspend inline fun ServiceDiscoveryClient.listInstances(crossinline block: ListInstancesRequest.Builder.() -> Unit): ListInstancesResponse = listInstances(ListInstancesRequest.Builder().apply(block).build())

/**
 * Lists summary information about the namespaces that were created by the current Amazon Web Services account.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.ListNamespaces.sample
 */
public suspend inline fun ServiceDiscoveryClient.listNamespaces(crossinline block: ListNamespacesRequest.Builder.() -> Unit): ListNamespacesResponse = listNamespaces(ListNamespacesRequest.Builder().apply(block).build())

/**
 * Lists operations that match the criteria that you specify.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.ListOperations.sample
 */
public suspend inline fun ServiceDiscoveryClient.listOperations(crossinline block: ListOperationsRequest.Builder.() -> Unit): ListOperationsResponse = listOperations(ListOperationsRequest.Builder().apply(block).build())

/**
 * Lists summary information for all the services that are associated with one or more specified namespaces.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.ListServices.sample
 */
public suspend inline fun ServiceDiscoveryClient.listServices(crossinline block: ListServicesRequest.Builder.() -> Unit): ListServicesResponse = listServices(ListServicesRequest.Builder().apply(block).build())

/**
 * Lists tags for the specified resource.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.ListTagsForResource.sample
 */
public suspend inline fun ServiceDiscoveryClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates or updates one or more records and, optionally, creates a health check based on the settings in a specified service. When you submit a `RegisterInstance` request, the following occurs:
 * + For each DNS record that you define in the service that's specified by `ServiceId`, a record is created or updated in the hosted zone that's associated with the corresponding namespace.
 * + If the service includes `HealthCheckConfig`, a health check is created based on the settings in the health check configuration.
 * + The health check, if any, is associated with each of the new or updated records.
 *
 * One `RegisterInstance` request must complete before you can submit another request and specify the same service ID and instance ID.
 *
 * For more information, see [CreateService](https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html).
 *
 * When Cloud Map receives a DNS query for the specified DNS name, it returns the applicable value:
 * + **If the health check is healthy**: returns all the records
 * + **If the health check is unhealthy**: returns the applicable value for the last healthy instance
 * + **If you didn't specify a health check configuration**: returns all the records
 *
 * For the current quota on the number of instances that you can register using the same namespace and using the same service, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.RegisterInstance.sample
 */
public suspend inline fun ServiceDiscoveryClient.registerInstance(crossinline block: RegisterInstanceRequest.Builder.() -> Unit): RegisterInstanceResponse = registerInstance(RegisterInstanceRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to the specified resource.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.TagResource.sample
 */
public suspend inline fun ServiceDiscoveryClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified resource.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.UntagResource.sample
 */
public suspend inline fun ServiceDiscoveryClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an HTTP namespace.
 */
public suspend inline fun ServiceDiscoveryClient.updateHttpNamespace(crossinline block: UpdateHttpNamespaceRequest.Builder.() -> Unit): UpdateHttpNamespaceResponse = updateHttpNamespace(UpdateHttpNamespaceRequest.Builder().apply(block).build())

/**
 * Submits a request to change the health status of a custom health check to healthy or unhealthy.
 *
 * You can use `UpdateInstanceCustomHealthStatus` to change the status only for custom health checks, which you define using `HealthCheckCustomConfig` when you create a service. You can't use it to change the status for Route 53 health checks, which you define using `HealthCheckConfig`.
 *
 * For more information, see [HealthCheckCustomConfig](https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html).
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.UpdateInstanceCustomHealthStatus.sample
 */
public suspend inline fun ServiceDiscoveryClient.updateInstanceCustomHealthStatus(crossinline block: UpdateInstanceCustomHealthStatusRequest.Builder.() -> Unit): UpdateInstanceCustomHealthStatusResponse = updateInstanceCustomHealthStatus(UpdateInstanceCustomHealthStatusRequest.Builder().apply(block).build())

/**
 * Updates a private DNS namespace.
 */
public suspend inline fun ServiceDiscoveryClient.updatePrivateDnsNamespace(crossinline block: UpdatePrivateDnsNamespaceRequest.Builder.() -> Unit): UpdatePrivateDnsNamespaceResponse = updatePrivateDnsNamespace(UpdatePrivateDnsNamespaceRequest.Builder().apply(block).build())

/**
 * Updates a public DNS namespace.
 */
public suspend inline fun ServiceDiscoveryClient.updatePublicDnsNamespace(crossinline block: UpdatePublicDnsNamespaceRequest.Builder.() -> Unit): UpdatePublicDnsNamespaceResponse = updatePublicDnsNamespace(UpdatePublicDnsNamespaceRequest.Builder().apply(block).build())

/**
 * Submits a request to perform the following operations:
 * + Update the TTL setting for existing `DnsRecords` configurations
 * + Add, update, or delete `HealthCheckConfig` for a specified serviceYou can't add, update, or delete a `HealthCheckCustomConfig` configuration.
 *
 * For public and private DNS namespaces, note the following:
 * + If you omit any existing `DnsRecords` or `HealthCheckConfig` configurations from an `UpdateService` request, the configurations are deleted from the service.
 * + If you omit an existing `HealthCheckCustomConfig` configuration from an `UpdateService` request, the configuration isn't deleted from the service.
 *
 * When you update settings for a service, Cloud Map also updates the corresponding settings in all the records and health checks that were created by using the specified service.
 *
 * @sample aws.sdk.kotlin.services.servicediscovery.samples.UpdateService.sample
 */
public suspend inline fun ServiceDiscoveryClient.updateService(crossinline block: UpdateServiceRequest.Builder.() -> Unit): UpdateServiceResponse = updateService(UpdateServiceRequest.Builder().apply(block).build())
