// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicediscovery.model.RegisterInstanceResponse
import aws.sdk.kotlin.services.servicediscovery.model.ServiceDiscoveryException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RegisterInstanceOperationDeserializer: HttpDeserialize<RegisterInstanceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RegisterInstanceResponse {
        if (!response.status.isSuccess()) {
            throwRegisterInstanceError(context, response)
        }
        val builder = RegisterInstanceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRegisterInstanceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRegisterInstanceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceDiscoveryException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DuplicateRequest" -> DuplicateRequestDeserializer().deserialize(context, wrappedResponse)
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "ResourceInUse" -> ResourceInUseDeserializer().deserialize(context, wrappedResponse)
        "ResourceLimitExceeded" -> ResourceLimitExceededDeserializer().deserialize(context, wrappedResponse)
        "ServiceNotFound" -> ServiceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceDiscoveryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRegisterInstanceOperationBody(builder: RegisterInstanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val OPERATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OperationId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(OPERATIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                OPERATIONID_DESCRIPTOR.index -> builder.operationId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
