// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.servicediscovery.model.GetInstanceResponse
import aws.sdk.kotlin.services.servicediscovery.model.Instance
import aws.sdk.kotlin.services.servicediscovery.model.ServiceDiscoveryException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetInstanceOperationDeserializer: HttpDeserialize<GetInstanceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetInstanceResponse {
        if (!response.status.isSuccess()) {
            throwGetInstanceError(context, response)
        }
        val builder = GetInstanceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetInstanceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetInstanceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceDiscoveryException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InstanceNotFound" -> InstanceNotFoundDeserializer().deserialize(context, wrappedResponse)
        "InvalidInput" -> InvalidInputDeserializer().deserialize(context, wrappedResponse)
        "ServiceNotFound" -> ServiceNotFoundDeserializer().deserialize(context, wrappedResponse)
        else -> ServiceDiscoveryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetInstanceOperationBody(builder: GetInstanceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INSTANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Instance"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INSTANCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSTANCE_DESCRIPTOR.index -> builder.instance = deserializeInstanceDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
