// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.paginators

import aws.sdk.kotlin.services.servicediscovery.ServiceDiscoveryClient
import aws.sdk.kotlin.services.servicediscovery.model.GetInstancesHealthStatusRequest
import aws.sdk.kotlin.services.servicediscovery.model.GetInstancesHealthStatusResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListInstancesRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListInstancesResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListNamespacesRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListNamespacesResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListOperationsRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListOperationsResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListServicesRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListServicesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [GetInstancesHealthStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetInstancesHealthStatusRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetInstancesHealthStatusResponse]
 */
public fun ServiceDiscoveryClient.getInstancesHealthStatusPaginated(initialRequest: GetInstancesHealthStatusRequest): Flow<GetInstancesHealthStatusResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getInstancesHealthStatusPaginated.getInstancesHealthStatus(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetInstancesHealthStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetInstancesHealthStatusResponse]
 */
public fun ServiceDiscoveryClient.getInstancesHealthStatusPaginated(block: GetInstancesHealthStatusRequest.Builder.() -> Unit): Flow<GetInstancesHealthStatusResponse> =
    getInstancesHealthStatusPaginated(GetInstancesHealthStatusRequest.Builder().apply(block).build())

/**
 * Paginate over [ListInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstancesResponse]
 */
public fun ServiceDiscoveryClient.listInstancesPaginated(initialRequest: ListInstancesRequest): Flow<ListInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInstancesPaginated.listInstances(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstancesResponse]
 */
public fun ServiceDiscoveryClient.listInstancesPaginated(block: ListInstancesRequest.Builder.() -> Unit): Flow<ListInstancesResponse> =
    listInstancesPaginated(ListInstancesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListNamespacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNamespacesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNamespacesResponse]
 */
public fun ServiceDiscoveryClient.listNamespacesPaginated(initialRequest: ListNamespacesRequest): Flow<ListNamespacesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNamespacesPaginated.listNamespaces(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListNamespacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNamespacesResponse]
 */
public fun ServiceDiscoveryClient.listNamespacesPaginated(block: ListNamespacesRequest.Builder.() -> Unit): Flow<ListNamespacesResponse> =
    listNamespacesPaginated(ListNamespacesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListOperationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOperationsResponse]
 */
public fun ServiceDiscoveryClient.listOperationsPaginated(initialRequest: ListOperationsRequest): Flow<ListOperationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listOperationsPaginated.listOperations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListOperationsResponse]
 */
public fun ServiceDiscoveryClient.listOperationsPaginated(block: ListOperationsRequest.Builder.() -> Unit): Flow<ListOperationsResponse> =
    listOperationsPaginated(ListOperationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesResponse]
 */
public fun ServiceDiscoveryClient.listServicesPaginated(initialRequest: ListServicesRequest): Flow<ListServicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServicesPaginated.listServices(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesResponse]
 */
public fun ServiceDiscoveryClient.listServicesPaginated(block: ListServicesRequest.Builder.() -> Unit): Flow<ListServicesResponse> =
    listServicesPaginated(ListServicesRequest.Builder().apply(block).build())
