// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A complex type that contains information about the specified service.
 */
public class Service private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreateDate` is accurate to milliseconds. For example, the value `1516925490.087` represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. `CreatorRequestId` can be any unique string (for example, a date/timestamp).
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The description of the service.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A complex type that contains information about the Route 53 DNS records that you want Cloud Map to create when you register an instance.
     *
     * The record types of a service can only be changed by deleting the service and recreating it with a new `Dnsconfig`.
     */
    public val dnsConfig: aws.sdk.kotlin.services.servicediscovery.model.DnsConfig? = builder.dnsConfig
    /**
     * *Public DNS and HTTP namespaces only.* A complex type that contains settings for an optional health check. If you specify settings for a health check, Cloud Map associates the health check with the records that you specify in `DnsConfig`.
     *
     * For information about the charges for health checks, see [Amazon Route 53 Pricing](http://aws.amazon.com/route53/pricing/).
     */
    public val healthCheckConfig: aws.sdk.kotlin.services.servicediscovery.model.HealthCheckConfig? = builder.healthCheckConfig
    /**
     * A complex type that contains information about an optional custom health check.
     *
     * If you specify a health check configuration, you can specify either `HealthCheckCustomConfig` or `HealthCheckConfig` but not both.
     */
    public val healthCheckCustomConfig: aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig? = builder.healthCheckCustomConfig
    /**
     * The ID that Cloud Map assigned to the service when you created it.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The number of instances that are currently associated with the service. Instances that were previously associated with the service but that are deleted aren't included in the count. The count might not reflect pending registrations and deregistrations.
     */
    public val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The name of the service.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ID of the namespace that was used to create the service.
     */
    public val namespaceId: kotlin.String? = builder.namespaceId
    /**
     * Describes the systems that can be used to discover the service instances.
     *
     * ## DNS_HTTP
     * The service instances can be discovered using either DNS queries or the `DiscoverInstances` API operation.
     *
     * ## HTTP
     * The service instances can only be discovered using the `DiscoverInstances` API operation.
     *
     * ## DNS
     * Reserved.
     */
    public val type: aws.sdk.kotlin.services.servicediscovery.model.ServiceType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.Service = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Service(")
        append("arn=$arn,")
        append("createDate=$createDate,")
        append("creatorRequestId=$creatorRequestId,")
        append("description=$description,")
        append("dnsConfig=$dnsConfig,")
        append("healthCheckConfig=$healthCheckConfig,")
        append("healthCheckCustomConfig=$healthCheckCustomConfig,")
        append("id=$id,")
        append("instanceCount=$instanceCount,")
        append("name=$name,")
        append("namespaceId=$namespaceId,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dnsConfig?.hashCode() ?: 0)
        result = 31 * result + (healthCheckConfig?.hashCode() ?: 0)
        result = 31 * result + (healthCheckCustomConfig?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (namespaceId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Service

        if (arn != other.arn) return false
        if (createDate != other.createDate) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (description != other.description) return false
        if (dnsConfig != other.dnsConfig) return false
        if (healthCheckConfig != other.healthCheckConfig) return false
        if (healthCheckCustomConfig != other.healthCheckCustomConfig) return false
        if (id != other.id) return false
        if (instanceCount != other.instanceCount) return false
        if (name != other.name) return false
        if (namespaceId != other.namespaceId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.Service = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you create it.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time that the service was created, in Unix format and Coordinated Universal Time (UTC). The value of `CreateDate` is accurate to milliseconds. For example, the value `1516925490.087` represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. `CreatorRequestId` can be any unique string (for example, a date/timestamp).
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * The description of the service.
         */
        public var description: kotlin.String? = null
        /**
         * A complex type that contains information about the Route 53 DNS records that you want Cloud Map to create when you register an instance.
         *
         * The record types of a service can only be changed by deleting the service and recreating it with a new `Dnsconfig`.
         */
        public var dnsConfig: aws.sdk.kotlin.services.servicediscovery.model.DnsConfig? = null
        /**
         * *Public DNS and HTTP namespaces only.* A complex type that contains settings for an optional health check. If you specify settings for a health check, Cloud Map associates the health check with the records that you specify in `DnsConfig`.
         *
         * For information about the charges for health checks, see [Amazon Route 53 Pricing](http://aws.amazon.com/route53/pricing/).
         */
        public var healthCheckConfig: aws.sdk.kotlin.services.servicediscovery.model.HealthCheckConfig? = null
        /**
         * A complex type that contains information about an optional custom health check.
         *
         * If you specify a health check configuration, you can specify either `HealthCheckCustomConfig` or `HealthCheckConfig` but not both.
         */
        public var healthCheckCustomConfig: aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig? = null
        /**
         * The ID that Cloud Map assigned to the service when you created it.
         */
        public var id: kotlin.String? = null
        /**
         * The number of instances that are currently associated with the service. Instances that were previously associated with the service but that are deleted aren't included in the count. The count might not reflect pending registrations and deregistrations.
         */
        public var instanceCount: kotlin.Int? = null
        /**
         * The name of the service.
         */
        public var name: kotlin.String? = null
        /**
         * The ID of the namespace that was used to create the service.
         */
        public var namespaceId: kotlin.String? = null
        /**
         * Describes the systems that can be used to discover the service instances.
         *
         * ## DNS_HTTP
         * The service instances can be discovered using either DNS queries or the `DiscoverInstances` API operation.
         *
         * ## HTTP
         * The service instances can only be discovered using the `DiscoverInstances` API operation.
         *
         * ## DNS
         * Reserved.
         */
        public var type: aws.sdk.kotlin.services.servicediscovery.model.ServiceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.Service) : this() {
            this.arn = x.arn
            this.createDate = x.createDate
            this.creatorRequestId = x.creatorRequestId
            this.description = x.description
            this.dnsConfig = x.dnsConfig
            this.healthCheckConfig = x.healthCheckConfig
            this.healthCheckCustomConfig = x.healthCheckCustomConfig
            this.id = x.id
            this.instanceCount = x.instanceCount
            this.name = x.name
            this.namespaceId = x.namespaceId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.Service = Service(this)

        /**
         * construct an [aws.sdk.kotlin.services.servicediscovery.model.DnsConfig] inside the given [block]
         */
        public fun dnsConfig(block: aws.sdk.kotlin.services.servicediscovery.model.DnsConfig.Builder.() -> kotlin.Unit) {
            this.dnsConfig = aws.sdk.kotlin.services.servicediscovery.model.DnsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.servicediscovery.model.HealthCheckConfig] inside the given [block]
         */
        public fun healthCheckConfig(block: aws.sdk.kotlin.services.servicediscovery.model.HealthCheckConfig.Builder.() -> kotlin.Unit) {
            this.healthCheckConfig = aws.sdk.kotlin.services.servicediscovery.model.HealthCheckConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig] inside the given [block]
         */
        public fun healthCheckCustomConfig(block: aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig.Builder.() -> kotlin.Unit) {
            this.healthCheckCustomConfig = aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig.invoke(block)
        }
    }
}
