// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model



/**
 * A complex type that lets you select the operations that you want to list.
 */
public class OperationFilter private constructor(builder: Builder) {
    /**
     * The operator that you want to use to determine whether an operation matches the specified value. Valid values for condition include:
     * + `EQ`: When you specify `EQ` for the condition, you can specify only one value. `EQ` is supported for `NAMESPACE_ID`, `SERVICE_ID`, `STATUS`, and `TYPE`. `EQ` is the default condition and can be omitted.
     * + `IN`: When you specify `IN` for the condition, you can specify a list of one or more values. `IN` is supported for `STATUS` and `TYPE`. An operation must match one of the specified values to be returned in the response.
     * + `BETWEEN`: Specify a start date and an end date in Unix date/time format and Coordinated Universal Time (UTC). The start date must be the first value. `BETWEEN` is supported for `UPDATE_DATE`.
     */
    public val condition: aws.sdk.kotlin.services.servicediscovery.model.FilterCondition? = builder.condition
    /**
     * Specify the operations that you want to get:
     * + **NAMESPACE_ID**: Gets operations related to specified namespaces.
     * + **SERVICE_ID**: Gets operations related to specified services.
     * + **STATUS**: Gets operations based on the status of the operations: `SUBMITTED`, `PENDING`, `SUCCEED`, or `FAIL`.
     * + **TYPE**: Gets specified types of operation.
     * + **UPDATE_DATE**: Gets operations that changed status during a specified date/time range.
     */
    public val name: aws.sdk.kotlin.services.servicediscovery.model.OperationFilterName? = builder.name
    /**
     * Specify values that are applicable to the value that you specify for `Name`:
     * + **NAMESPACE_ID**: Specify one namespace ID.
     * + **SERVICE_ID**: Specify one service ID.
     * + **STATUS**: Specify one or more statuses: `SUBMITTED`, `PENDING`, `SUCCEED`, or `FAIL`.
     * + **TYPE**: Specify one or more of the following types: `CREATE_NAMESPACE`, `DELETE_NAMESPACE`, `UPDATE_SERVICE`, `REGISTER_INSTANCE`, or `DEREGISTER_INSTANCE`.
     * + **UPDATE_DATE**: Specify a start date and an end date in Unix date/time format and Coordinated Universal Time (UTC). The start date must be the first value.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.OperationFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OperationFilter(")
        append("condition=$condition,")
        append("name=$name,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = condition?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OperationFilter

        if (condition != other.condition) return false
        if (name != other.name) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.OperationFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The operator that you want to use to determine whether an operation matches the specified value. Valid values for condition include:
         * + `EQ`: When you specify `EQ` for the condition, you can specify only one value. `EQ` is supported for `NAMESPACE_ID`, `SERVICE_ID`, `STATUS`, and `TYPE`. `EQ` is the default condition and can be omitted.
         * + `IN`: When you specify `IN` for the condition, you can specify a list of one or more values. `IN` is supported for `STATUS` and `TYPE`. An operation must match one of the specified values to be returned in the response.
         * + `BETWEEN`: Specify a start date and an end date in Unix date/time format and Coordinated Universal Time (UTC). The start date must be the first value. `BETWEEN` is supported for `UPDATE_DATE`.
         */
        public var condition: aws.sdk.kotlin.services.servicediscovery.model.FilterCondition? = null
        /**
         * Specify the operations that you want to get:
         * + **NAMESPACE_ID**: Gets operations related to specified namespaces.
         * + **SERVICE_ID**: Gets operations related to specified services.
         * + **STATUS**: Gets operations based on the status of the operations: `SUBMITTED`, `PENDING`, `SUCCEED`, or `FAIL`.
         * + **TYPE**: Gets specified types of operation.
         * + **UPDATE_DATE**: Gets operations that changed status during a specified date/time range.
         */
        public var name: aws.sdk.kotlin.services.servicediscovery.model.OperationFilterName? = null
        /**
         * Specify values that are applicable to the value that you specify for `Name`:
         * + **NAMESPACE_ID**: Specify one namespace ID.
         * + **SERVICE_ID**: Specify one service ID.
         * + **STATUS**: Specify one or more statuses: `SUBMITTED`, `PENDING`, `SUCCEED`, or `FAIL`.
         * + **TYPE**: Specify one or more of the following types: `CREATE_NAMESPACE`, `DELETE_NAMESPACE`, `UPDATE_SERVICE`, `REGISTER_INSTANCE`, or `DEREGISTER_INSTANCE`.
         * + **UPDATE_DATE**: Specify a start date and an end date in Unix date/time format and Coordinated Universal Time (UTC). The start date must be the first value.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.OperationFilter) : this() {
            this.condition = x.condition
            this.name = x.name
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.OperationFilter = OperationFilter(this)
    }
}
