// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A complex type that contains information about a specified namespace.
 */
public class Namespace private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date that the namespace was created, in Unix date/time format and Coordinated Universal Time (UTC). The value of `CreateDate` is accurate to milliseconds. For example, the value `1516925490.087` represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * A unique string that identifies the request and that allows failed requests to be retried without the risk of running an operation twice.
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * The description that you specify for the namespace when you create it.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of a namespace.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the namespace, such as `example.com`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A complex type that contains information that's specific to the type of the namespace.
     */
    public val properties: aws.sdk.kotlin.services.servicediscovery.model.NamespaceProperties? = builder.properties
    /**
     * The number of services that are associated with the namespace.
     */
    public val serviceCount: kotlin.Int? = builder.serviceCount
    /**
     * The type of the namespace. The methods for discovering instances depends on the value that you specify:
     *
     * ## HTTP
     * Instances can be discovered only programmatically, using the Cloud Map `DiscoverInstances` API.
     *
     * ## DNS_PUBLIC
     * Instances can be discovered using public DNS queries and using the `DiscoverInstances` API.
     *
     * ## DNS_PRIVATE
     * Instances can be discovered using DNS queries in VPCs and using the `DiscoverInstances` API.
     */
    public val type: aws.sdk.kotlin.services.servicediscovery.model.NamespaceType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.Namespace = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Namespace(")
        append("arn=$arn,")
        append("createDate=$createDate,")
        append("creatorRequestId=$creatorRequestId,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("properties=$properties,")
        append("serviceCount=$serviceCount,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (properties?.hashCode() ?: 0)
        result = 31 * result + (serviceCount ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Namespace

        if (arn != other.arn) return false
        if (createDate != other.createDate) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (properties != other.properties) return false
        if (serviceCount != other.serviceCount) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.Namespace = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you create it.
         */
        public var arn: kotlin.String? = null
        /**
         * The date that the namespace was created, in Unix date/time format and Coordinated Universal Time (UTC). The value of `CreateDate` is accurate to milliseconds. For example, the value `1516925490.087` represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique string that identifies the request and that allows failed requests to be retried without the risk of running an operation twice.
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * The description that you specify for the namespace when you create it.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of a namespace.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the namespace, such as `example.com`.
         */
        public var name: kotlin.String? = null
        /**
         * A complex type that contains information that's specific to the type of the namespace.
         */
        public var properties: aws.sdk.kotlin.services.servicediscovery.model.NamespaceProperties? = null
        /**
         * The number of services that are associated with the namespace.
         */
        public var serviceCount: kotlin.Int? = null
        /**
         * The type of the namespace. The methods for discovering instances depends on the value that you specify:
         *
         * ## HTTP
         * Instances can be discovered only programmatically, using the Cloud Map `DiscoverInstances` API.
         *
         * ## DNS_PUBLIC
         * Instances can be discovered using public DNS queries and using the `DiscoverInstances` API.
         *
         * ## DNS_PRIVATE
         * Instances can be discovered using DNS queries in VPCs and using the `DiscoverInstances` API.
         */
        public var type: aws.sdk.kotlin.services.servicediscovery.model.NamespaceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.Namespace) : this() {
            this.arn = x.arn
            this.createDate = x.createDate
            this.creatorRequestId = x.creatorRequestId
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.properties = x.properties
            this.serviceCount = x.serviceCount
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.Namespace = Namespace(this)

        /**
         * construct an [aws.sdk.kotlin.services.servicediscovery.model.NamespaceProperties] inside the given [block]
         */
        public fun properties(block: aws.sdk.kotlin.services.servicediscovery.model.NamespaceProperties.Builder.() -> kotlin.Unit) {
            this.properties = aws.sdk.kotlin.services.servicediscovery.model.NamespaceProperties.invoke(block)
        }
    }
}
