// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model



public class ListOperationsRequest private constructor(builder: Builder) {
    /**
     * A complex type that contains specifications for the operations that you want to list, for example, operations that you started between a specified start date and end date.
     *
     * If you specify more than one filter, an operation must match all filters to be returned by `ListOperations`.
     */
    public val filters: List<OperationFilter>? = builder.filters
    /**
     * The maximum number of items that you want Cloud Map to return in the response to a `ListOperations` request. If you don't specify a value for `MaxResults`, Cloud Map returns up to 100 operations.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * For the first `ListOperations` request, omit this value.
     *
     * If the response contains `NextToken`, submit another `ListOperations` request to get the next group of results. Specify the value of `NextToken` from the previous response in the next request.
     *
     * Cloud Map gets `MaxResults` operations and then filters them based on the specified criteria. It's possible that no operations in the first `MaxResults` operations matched the specified criteria but that subsequent groups of `MaxResults` operations do contain operations that match the criteria.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.ListOperationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListOperationsRequest(")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListOperationsRequest

        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.ListOperationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A complex type that contains specifications for the operations that you want to list, for example, operations that you started between a specified start date and end date.
         *
         * If you specify more than one filter, an operation must match all filters to be returned by `ListOperations`.
         */
        public var filters: List<OperationFilter>? = null
        /**
         * The maximum number of items that you want Cloud Map to return in the response to a `ListOperations` request. If you don't specify a value for `MaxResults`, Cloud Map returns up to 100 operations.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * For the first `ListOperations` request, omit this value.
         *
         * If the response contains `NextToken`, submit another `ListOperations` request to get the next group of results. Specify the value of `NextToken` from the previous response in the next request.
         *
         * Cloud Map gets `MaxResults` operations and then filters them based on the specified criteria. It's possible that no operations in the first `MaxResults` operations matched the specified criteria but that subsequent groups of `MaxResults` operations do contain operations that match the criteria.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.ListOperationsRequest) : this() {
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.ListOperationsRequest = ListOperationsRequest(this)
    }
}
