// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model



/**
 * A complex type that contains information about an instance that Cloud Map creates when you submit a `RegisterInstance` request.
 */
public class Instance private constructor(builder: Builder) {
    /**
     * A string map that contains the following information for the service that you specify in `ServiceId`:
     * + The attributes that apply to the records that are defined in the service.
     * + For each attribute, the applicable value.
     *
     * Do not include sensitive information in the attributes if the namespace is discoverable by public DNS queries.
     *
     * Supported attribute keys include the following:
     *
     * ## AWS_ALIAS_DNS_NAME
     * If you want Cloud Map to create a Route 53 alias record that routes traffic to an Elastic Load Balancing load balancer, specify the DNS name that's associated with the load balancer. For information about how to get the DNS name, see [AliasTarget->DNSName](https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-DNSName) in the *Route 53 API Reference*.
     *
     * Note the following:
     * + The configuration for the service that's specified by `ServiceId` must include settings for an `A` record, an `AAAA` record, or both.
     * + In the service that's specified by `ServiceId`, the value of `RoutingPolicy` must be `WEIGHTED`.
     * + If the service that's specified by `ServiceId` includes `HealthCheckConfig` settings, Cloud Map creates the health check, but it won't associate the health check with the alias record.
     * + Auto naming currently doesn't support creating alias records that route traffic to Amazon Web Services resources other than ELB load balancers.
     * + If you specify a value for `AWS_ALIAS_DNS_NAME`, don't specify values for any of the `AWS_INSTANCE` attributes.
     *
     * ## AWS_EC2_INSTANCE_ID
     * *HTTP namespaces only.* The Amazon EC2 instance ID for the instance. The `AWS_INSTANCE_IPV4` attribute contains the primary private IPv4 address.
     *
     * ## AWS_INIT_HEALTH_STATUS
     * If the service configuration includes `HealthCheckCustomConfig`, you can optionally use `AWS_INIT_HEALTH_STATUS` to specify the initial status of the custom health check, `HEALTHY` or `UNHEALTHY`. If you don't specify a value for `AWS_INIT_HEALTH_STATUS`, the initial status is `HEALTHY`.
     *
     * ## AWS_INSTANCE_CNAME
     * If the service configuration includes a `CNAME` record, the domain name that you want Route 53 to return in response to DNS queries (for example, `example.com`).
     *
     * This value is required if the service specified by `ServiceId` includes settings for an `CNAME` record.
     *
     * ## AWS_INSTANCE_IPV4
     * If the service configuration includes an `A` record, the IPv4 address that you want Route 53 to return in response to DNS queries (for example, `192.0.2.44`).
     *
     * This value is required if the service specified by `ServiceId` includes settings for an `A` record. If the service includes settings for an `SRV` record, you must specify a value for `AWS_INSTANCE_IPV4`, `AWS_INSTANCE_IPV6`, or both.
     *
     * ## AWS_INSTANCE_IPV6
     * If the service configuration includes an `AAAA` record, the IPv6 address that you want Route 53 to return in response to DNS queries (for example, `2001:0db8:85a3:0000:0000:abcd:0001:2345`).
     *
     * This value is required if the service specified by `ServiceId` includes settings for an `AAAA` record. If the service includes settings for an `SRV` record, you must specify a value for `AWS_INSTANCE_IPV4`, `AWS_INSTANCE_IPV6`, or both.
     *
     * ## AWS_INSTANCE_PORT
     * If the service includes an `SRV` record, the value that you want Route 53 to return for the port.
     *
     * If the service includes `HealthCheckConfig`, the port on the endpoint that you want Route 53 to send requests to.
     *
     * This value is required if you specified settings for an `SRV` record or a Route 53 health check when you created the service.
     */
    public val attributes: Map<String, String>? = builder.attributes
    /**
     * A unique string that identifies the request and that allows failed `RegisterInstance` requests to be retried without the risk of executing the operation twice. You must use a unique `CreatorRequestId` string every time you submit a `RegisterInstance` request if you're registering additional instances for the same namespace and service. `CreatorRequestId` can be any unique string (for example, a date/time stamp).
     */
    public val creatorRequestId: kotlin.String? = builder.creatorRequestId
    /**
     * An identifier that you want to associate with the instance. Note the following:
     * + If the service that's specified by `ServiceId` includes settings for an `SRV` record, the value of `InstanceId` is automatically included as part of the value for the `SRV` record. For more information, see [DnsRecord > Type](https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type).
     * + You can use this value to update an existing instance.
     * + To register a new instance, you must specify a value that's unique among instances that you register by using the same service.
     * + If you specify an existing `InstanceId` and `ServiceId`, Cloud Map updates the existing DNS records. If there's also an existing health check, Cloud Map deletes the old health check and creates a new one. The health check isn't deleted immediately, so it will still appear for a while if you submit a `ListHealthChecks` request, for example.
     */
    public val id: kotlin.String? = builder.id

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.Instance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Instance(")
        append("attributes=$attributes,")
        append("creatorRequestId=$creatorRequestId,")
        append("id=$id)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (creatorRequestId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Instance

        if (attributes != other.attributes) return false
        if (creatorRequestId != other.creatorRequestId) return false
        if (id != other.id) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.Instance = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A string map that contains the following information for the service that you specify in `ServiceId`:
         * + The attributes that apply to the records that are defined in the service.
         * + For each attribute, the applicable value.
         *
         * Do not include sensitive information in the attributes if the namespace is discoverable by public DNS queries.
         *
         * Supported attribute keys include the following:
         *
         * ## AWS_ALIAS_DNS_NAME
         * If you want Cloud Map to create a Route 53 alias record that routes traffic to an Elastic Load Balancing load balancer, specify the DNS name that's associated with the load balancer. For information about how to get the DNS name, see [AliasTarget->DNSName](https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-DNSName) in the *Route 53 API Reference*.
         *
         * Note the following:
         * + The configuration for the service that's specified by `ServiceId` must include settings for an `A` record, an `AAAA` record, or both.
         * + In the service that's specified by `ServiceId`, the value of `RoutingPolicy` must be `WEIGHTED`.
         * + If the service that's specified by `ServiceId` includes `HealthCheckConfig` settings, Cloud Map creates the health check, but it won't associate the health check with the alias record.
         * + Auto naming currently doesn't support creating alias records that route traffic to Amazon Web Services resources other than ELB load balancers.
         * + If you specify a value for `AWS_ALIAS_DNS_NAME`, don't specify values for any of the `AWS_INSTANCE` attributes.
         *
         * ## AWS_EC2_INSTANCE_ID
         * *HTTP namespaces only.* The Amazon EC2 instance ID for the instance. The `AWS_INSTANCE_IPV4` attribute contains the primary private IPv4 address.
         *
         * ## AWS_INIT_HEALTH_STATUS
         * If the service configuration includes `HealthCheckCustomConfig`, you can optionally use `AWS_INIT_HEALTH_STATUS` to specify the initial status of the custom health check, `HEALTHY` or `UNHEALTHY`. If you don't specify a value for `AWS_INIT_HEALTH_STATUS`, the initial status is `HEALTHY`.
         *
         * ## AWS_INSTANCE_CNAME
         * If the service configuration includes a `CNAME` record, the domain name that you want Route 53 to return in response to DNS queries (for example, `example.com`).
         *
         * This value is required if the service specified by `ServiceId` includes settings for an `CNAME` record.
         *
         * ## AWS_INSTANCE_IPV4
         * If the service configuration includes an `A` record, the IPv4 address that you want Route 53 to return in response to DNS queries (for example, `192.0.2.44`).
         *
         * This value is required if the service specified by `ServiceId` includes settings for an `A` record. If the service includes settings for an `SRV` record, you must specify a value for `AWS_INSTANCE_IPV4`, `AWS_INSTANCE_IPV6`, or both.
         *
         * ## AWS_INSTANCE_IPV6
         * If the service configuration includes an `AAAA` record, the IPv6 address that you want Route 53 to return in response to DNS queries (for example, `2001:0db8:85a3:0000:0000:abcd:0001:2345`).
         *
         * This value is required if the service specified by `ServiceId` includes settings for an `AAAA` record. If the service includes settings for an `SRV` record, you must specify a value for `AWS_INSTANCE_IPV4`, `AWS_INSTANCE_IPV6`, or both.
         *
         * ## AWS_INSTANCE_PORT
         * If the service includes an `SRV` record, the value that you want Route 53 to return for the port.
         *
         * If the service includes `HealthCheckConfig`, the port on the endpoint that you want Route 53 to send requests to.
         *
         * This value is required if you specified settings for an `SRV` record or a Route 53 health check when you created the service.
         */
        public var attributes: Map<String, String>? = null
        /**
         * A unique string that identifies the request and that allows failed `RegisterInstance` requests to be retried without the risk of executing the operation twice. You must use a unique `CreatorRequestId` string every time you submit a `RegisterInstance` request if you're registering additional instances for the same namespace and service. `CreatorRequestId` can be any unique string (for example, a date/time stamp).
         */
        public var creatorRequestId: kotlin.String? = null
        /**
         * An identifier that you want to associate with the instance. Note the following:
         * + If the service that's specified by `ServiceId` includes settings for an `SRV` record, the value of `InstanceId` is automatically included as part of the value for the `SRV` record. For more information, see [DnsRecord > Type](https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type).
         * + You can use this value to update an existing instance.
         * + To register a new instance, you must specify a value that's unique among instances that you register by using the same service.
         * + If you specify an existing `InstanceId` and `ServiceId`, Cloud Map updates the existing DNS records. If there's also an existing health check, Cloud Map deletes the old health check and creates a new one. The health check isn't deleted immediately, so it will still appear for a while if you submit a `ListHealthChecks` request, for example.
         */
        public var id: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.Instance) : this() {
            this.attributes = x.attributes
            this.creatorRequestId = x.creatorRequestId
            this.id = x.id
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.Instance = Instance(this)
    }
}
