// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model



/**
 * A complex type that contains information about an optional custom health check. A custom health check, which requires that you use a third-party health checker to evaluate the health of your resources, is useful in the following circumstances:
 * + You can't use a health check that's defined by `HealthCheckConfig` because the resource isn't available over the internet. For example, you can use a custom health check when the instance is in an Amazon VPC. (To check the health of resources in a VPC, the health checker must also be in the VPC.)
 * + You want to use a third-party health checker regardless of where your resources are located.
 *
 * If you specify a health check configuration, you can specify either `HealthCheckCustomConfig` or `HealthCheckConfig` but not both.
 *
 * To change the status of a custom health check, submit an `UpdateInstanceCustomHealthStatus` request. Cloud Map doesn't monitor the status of the resource, it just keeps a record of the status specified in the most recent `UpdateInstanceCustomHealthStatus` request.
 *
 * Here's how custom health checks work:
 * + You create a service.
 * + You register an instance.
 * + You configure a third-party health checker to monitor the resource that's associated with the new instance. Cloud Map doesn't check the health of the resource directly.
 * + The third-party health-checker determines that the resource is unhealthy and notifies your application.
 * + Your application submits an `UpdateInstanceCustomHealthStatus` request.
 * + Cloud Map waits for 30 seconds.
 * + If another `UpdateInstanceCustomHealthStatus` request doesn't arrive during that time to change the status back to healthy, Cloud Map stops routing traffic to the resource.
 */
public class HealthCheckCustomConfig private constructor(builder: Builder) {
    /**
     * This parameter is no longer supported and is always set to 1. Cloud Map waits for approximately 30 seconds after receiving an `UpdateInstanceCustomHealthStatus` request before changing the status of the service instance.
     *
     * The number of 30-second intervals that you want Cloud Map to wait after receiving an `UpdateInstanceCustomHealthStatus` request before it changes the health status of a service instance.
     *
     * Sending a second or subsequent `UpdateInstanceCustomHealthStatus` request with the same value before 30 seconds has passed doesn't accelerate the change. Cloud Map still waits `30` seconds after the first request to make the change.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val failureThreshold: kotlin.Int? = builder.failureThreshold

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HealthCheckCustomConfig(")
        append("failureThreshold=$failureThreshold)")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureThreshold ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HealthCheckCustomConfig

        if (failureThreshold != other.failureThreshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This parameter is no longer supported and is always set to 1. Cloud Map waits for approximately 30 seconds after receiving an `UpdateInstanceCustomHealthStatus` request before changing the status of the service instance.
         *
         * The number of 30-second intervals that you want Cloud Map to wait after receiving an `UpdateInstanceCustomHealthStatus` request before it changes the health status of a service instance.
         *
         * Sending a second or subsequent `UpdateInstanceCustomHealthStatus` request with the same value before 30 seconds has passed doesn't accelerate the change. Cloud Map still waits `30` seconds after the first request to make the change.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var failureThreshold: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig) : this() {
            this.failureThreshold = x.failureThreshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.HealthCheckCustomConfig = HealthCheckCustomConfig(this)
    }
}
