// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model



public class GetInstancesHealthStatusRequest private constructor(builder: Builder) {
    /**
     * An array that contains the IDs of all the instances that you want to get the health status for.
     *
     * If you omit `Instances`, Cloud Map returns the health status for all the instances that are associated with the specified service.
     *
     * To get the IDs for the instances that you've registered by using a specified service, submit a [ListInstances](https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html) request.
     */
    public val instances: List<String>? = builder.instances
    /**
     * The maximum number of instances that you want Cloud Map to return in the response to a `GetInstancesHealthStatus` request. If you don't specify a value for `MaxResults`, Cloud Map returns up to 100 instances.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * For the first `GetInstancesHealthStatus` request, omit this value.
     *
     * If more than `MaxResults` instances match the specified criteria, you can submit another `GetInstancesHealthStatus` request to get the next group of results. Specify the value of `NextToken` from the previous response in the next request.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ID of the service that the instance is associated with.
     */
    public val serviceId: kotlin.String? = builder.serviceId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.GetInstancesHealthStatusRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetInstancesHealthStatusRequest(")
        append("instances=$instances,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("serviceId=$serviceId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instances?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (serviceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetInstancesHealthStatusRequest

        if (instances != other.instances) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (serviceId != other.serviceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.GetInstancesHealthStatusRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array that contains the IDs of all the instances that you want to get the health status for.
         *
         * If you omit `Instances`, Cloud Map returns the health status for all the instances that are associated with the specified service.
         *
         * To get the IDs for the instances that you've registered by using a specified service, submit a [ListInstances](https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html) request.
         */
        public var instances: List<String>? = null
        /**
         * The maximum number of instances that you want Cloud Map to return in the response to a `GetInstancesHealthStatus` request. If you don't specify a value for `MaxResults`, Cloud Map returns up to 100 instances.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * For the first `GetInstancesHealthStatus` request, omit this value.
         *
         * If more than `MaxResults` instances match the specified criteria, you can submit another `GetInstancesHealthStatus` request to get the next group of results. Specify the value of `NextToken` from the previous response in the next request.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ID of the service that the instance is associated with.
         */
        public var serviceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.GetInstancesHealthStatusRequest) : this() {
            this.instances = x.instances
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.serviceId = x.serviceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.GetInstancesHealthStatusRequest = GetInstancesHealthStatusRequest(this)
    }
}
