// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model



/**
 * A complex type that contains information about the Amazon Route 53 DNS records that you want Cloud Map to create when you register an instance.
 *
 * The record types of a service can only be changed by deleting the service and recreating it with a new `Dnsconfig`.
 */
public class DnsConfig private constructor(builder: Builder) {
    /**
     * An array that contains one `DnsRecord` object for each Route 53 DNS record that you want Cloud Map to create when you register an instance.
     */
    public val dnsRecords: List<DnsRecord>? = builder.dnsRecords
    /**
     * *Use NamespaceId in [Service](https://docs.aws.amazon.com/cloud-map/latest/api/API_Service.html) instead.*
     *
     * The ID of the namespace to use for DNS configuration.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val namespaceId: kotlin.String? = builder.namespaceId
    /**
     * The routing policy that you want to apply to all Route 53 DNS records that Cloud Map creates when you register an instance and specify this service.
     *
     * If you want to use this service to register instances that create alias records, specify `WEIGHTED` for the routing policy.
     *
     * You can specify the following values:
     *
     * ## MULTIVALUE
     * If you define a health check for the service and the health check is healthy, Route 53 returns the applicable value for up to eight instances.
     *
     * For example, suppose that the service includes configurations for one `A` record and a health check. You use the service to register 10 instances. Route 53 responds to DNS queries with IP addresses for up to eight healthy instances. If fewer than eight instances are healthy, Route 53 responds to every DNS query with the IP addresses for all of the healthy instances.
     *
     * If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns the values for up to eight instances.
     *
     * For more information about the multivalue routing policy, see [Multivalue Answer Routing](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-multivalue) in the *Route 53 Developer Guide*.
     *
     * ## WEIGHTED
     * Route 53 returns the applicable value from one randomly selected instance from among the instances that you registered using the same service. Currently, all records have the same weight, so you can't route more or less traffic to any instances.
     *
     * For example, suppose that the service includes configurations for one `A` record and a health check. You use the service to register 10 instances. Route 53 responds to DNS queries with the IP address for one randomly selected instance from among the healthy instances. If no instances are healthy, Route 53 responds to DNS queries as if all of the instances were healthy.
     *
     * If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns the applicable value for one randomly selected instance.
     *
     * For more information about the weighted routing policy, see [Weighted Routing](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted) in the *Route 53 Developer Guide*.
     */
    public val routingPolicy: aws.sdk.kotlin.services.servicediscovery.model.RoutingPolicy? = builder.routingPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.DnsConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DnsConfig(")
        append("dnsRecords=$dnsRecords,")
        append("namespaceId=$namespaceId,")
        append("routingPolicy=$routingPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dnsRecords?.hashCode() ?: 0
        result = 31 * result + (namespaceId?.hashCode() ?: 0)
        result = 31 * result + (routingPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DnsConfig

        if (dnsRecords != other.dnsRecords) return false
        if (namespaceId != other.namespaceId) return false
        if (routingPolicy != other.routingPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.DnsConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array that contains one `DnsRecord` object for each Route 53 DNS record that you want Cloud Map to create when you register an instance.
         */
        public var dnsRecords: List<DnsRecord>? = null
        /**
         * *Use NamespaceId in [Service](https://docs.aws.amazon.com/cloud-map/latest/api/API_Service.html) instead.*
         *
         * The ID of the namespace to use for DNS configuration.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var namespaceId: kotlin.String? = null
        /**
         * The routing policy that you want to apply to all Route 53 DNS records that Cloud Map creates when you register an instance and specify this service.
         *
         * If you want to use this service to register instances that create alias records, specify `WEIGHTED` for the routing policy.
         *
         * You can specify the following values:
         *
         * ## MULTIVALUE
         * If you define a health check for the service and the health check is healthy, Route 53 returns the applicable value for up to eight instances.
         *
         * For example, suppose that the service includes configurations for one `A` record and a health check. You use the service to register 10 instances. Route 53 responds to DNS queries with IP addresses for up to eight healthy instances. If fewer than eight instances are healthy, Route 53 responds to every DNS query with the IP addresses for all of the healthy instances.
         *
         * If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns the values for up to eight instances.
         *
         * For more information about the multivalue routing policy, see [Multivalue Answer Routing](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-multivalue) in the *Route 53 Developer Guide*.
         *
         * ## WEIGHTED
         * Route 53 returns the applicable value from one randomly selected instance from among the instances that you registered using the same service. Currently, all records have the same weight, so you can't route more or less traffic to any instances.
         *
         * For example, suppose that the service includes configurations for one `A` record and a health check. You use the service to register 10 instances. Route 53 responds to DNS queries with the IP address for one randomly selected instance from among the healthy instances. If no instances are healthy, Route 53 responds to DNS queries as if all of the instances were healthy.
         *
         * If you don't define a health check for the service, Route 53 assumes that all instances are healthy and returns the applicable value for one randomly selected instance.
         *
         * For more information about the weighted routing policy, see [Weighted Routing](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted) in the *Route 53 Developer Guide*.
         */
        public var routingPolicy: aws.sdk.kotlin.services.servicediscovery.model.RoutingPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.DnsConfig) : this() {
            this.dnsRecords = x.dnsRecords
            this.namespaceId = x.namespaceId
            this.routingPolicy = x.routingPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.DnsConfig = DnsConfig(this)
    }
}
