// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery.model



public class DiscoverInstancesRequest private constructor(builder: Builder) {
    /**
     * The health status of the instances that you want to discover. This parameter is ignored for services that don't have a health check configured, and all instances are returned.
     *
     * ## HEALTHY
     * Returns healthy instances.
     *
     * ## UNHEALTHY
     * Returns unhealthy instances.
     *
     * ## ALL
     * Returns all instances.
     *
     * ## HEALTHY_OR_ELSE_ALL
     * Returns healthy instances, unless none are reporting a healthy state. In that case, return all instances. This is also called failing open.
     */
    public val healthStatus: aws.sdk.kotlin.services.servicediscovery.model.HealthStatusFilter? = builder.healthStatus
    /**
     * The maximum number of instances that you want Cloud Map to return in the response to a `DiscoverInstances` request. If you don't specify a value for `MaxResults`, Cloud Map returns up to 100 instances.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `HttpName` name of the namespace. It's found in the `HttpProperties` member of the `Properties` member of the namespace.
     */
    public val namespaceName: kotlin.String? = builder.namespaceName
    /**
     * Opportunistic filters to scope the results based on custom attributes. If there are instances that match both the filters specified in both the `QueryParameters` parameter and this parameter, all of these instances are returned. Otherwise, the filters are ignored, and only instances that match the filters that are specified in the `QueryParameters` parameter are returned.
     */
    public val optionalParameters: Map<String, String>? = builder.optionalParameters
    /**
     * Filters to scope the results based on custom attributes for the instance (for example, `{version=v1, az=1a}`). Only instances that match all the specified key-value pairs are returned.
     */
    public val queryParameters: Map<String, String>? = builder.queryParameters
    /**
     * The name of the service that you specified when you registered the instance.
     */
    public val serviceName: kotlin.String? = builder.serviceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicediscovery.model.DiscoverInstancesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DiscoverInstancesRequest(")
        append("healthStatus=$healthStatus,")
        append("maxResults=$maxResults,")
        append("namespaceName=$namespaceName,")
        append("optionalParameters=$optionalParameters,")
        append("queryParameters=$queryParameters,")
        append("serviceName=$serviceName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthStatus?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (namespaceName?.hashCode() ?: 0)
        result = 31 * result + (optionalParameters?.hashCode() ?: 0)
        result = 31 * result + (queryParameters?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DiscoverInstancesRequest

        if (healthStatus != other.healthStatus) return false
        if (maxResults != other.maxResults) return false
        if (namespaceName != other.namespaceName) return false
        if (optionalParameters != other.optionalParameters) return false
        if (queryParameters != other.queryParameters) return false
        if (serviceName != other.serviceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicediscovery.model.DiscoverInstancesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The health status of the instances that you want to discover. This parameter is ignored for services that don't have a health check configured, and all instances are returned.
         *
         * ## HEALTHY
         * Returns healthy instances.
         *
         * ## UNHEALTHY
         * Returns unhealthy instances.
         *
         * ## ALL
         * Returns all instances.
         *
         * ## HEALTHY_OR_ELSE_ALL
         * Returns healthy instances, unless none are reporting a healthy state. In that case, return all instances. This is also called failing open.
         */
        public var healthStatus: aws.sdk.kotlin.services.servicediscovery.model.HealthStatusFilter? = null
        /**
         * The maximum number of instances that you want Cloud Map to return in the response to a `DiscoverInstances` request. If you don't specify a value for `MaxResults`, Cloud Map returns up to 100 instances.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `HttpName` name of the namespace. It's found in the `HttpProperties` member of the `Properties` member of the namespace.
         */
        public var namespaceName: kotlin.String? = null
        /**
         * Opportunistic filters to scope the results based on custom attributes. If there are instances that match both the filters specified in both the `QueryParameters` parameter and this parameter, all of these instances are returned. Otherwise, the filters are ignored, and only instances that match the filters that are specified in the `QueryParameters` parameter are returned.
         */
        public var optionalParameters: Map<String, String>? = null
        /**
         * Filters to scope the results based on custom attributes for the instance (for example, `{version=v1, az=1a}`). Only instances that match all the specified key-value pairs are returned.
         */
        public var queryParameters: Map<String, String>? = null
        /**
         * The name of the service that you specified when you registered the instance.
         */
        public var serviceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicediscovery.model.DiscoverInstancesRequest) : this() {
            this.healthStatus = x.healthStatus
            this.maxResults = x.maxResults
            this.namespaceName = x.namespaceName
            this.optionalParameters = x.optionalParameters
            this.queryParameters = x.queryParameters
            this.serviceName = x.serviceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicediscovery.model.DiscoverInstancesRequest = DiscoverInstancesRequest(this)
    }
}
