// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.servicediscovery.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.servicediscovery.model.*
import aws.sdk.kotlin.services.servicediscovery.model.CreateHttpNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.CreateHttpNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.CreatePrivateDnsNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.CreatePublicDnsNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.CreatePublicDnsNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.CreateServiceRequest
import aws.sdk.kotlin.services.servicediscovery.model.CreateServiceResponse
import aws.sdk.kotlin.services.servicediscovery.model.DeleteNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.DeleteNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.DeleteServiceRequest
import aws.sdk.kotlin.services.servicediscovery.model.DeleteServiceResponse
import aws.sdk.kotlin.services.servicediscovery.model.DeregisterInstanceRequest
import aws.sdk.kotlin.services.servicediscovery.model.DeregisterInstanceResponse
import aws.sdk.kotlin.services.servicediscovery.model.DiscoverInstancesRequest
import aws.sdk.kotlin.services.servicediscovery.model.DiscoverInstancesResponse
import aws.sdk.kotlin.services.servicediscovery.model.GetInstanceRequest
import aws.sdk.kotlin.services.servicediscovery.model.GetInstanceResponse
import aws.sdk.kotlin.services.servicediscovery.model.GetInstancesHealthStatusRequest
import aws.sdk.kotlin.services.servicediscovery.model.GetInstancesHealthStatusResponse
import aws.sdk.kotlin.services.servicediscovery.model.GetNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.GetNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.GetOperationRequest
import aws.sdk.kotlin.services.servicediscovery.model.GetOperationResponse
import aws.sdk.kotlin.services.servicediscovery.model.GetServiceRequest
import aws.sdk.kotlin.services.servicediscovery.model.GetServiceResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListInstancesRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListInstancesResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListNamespacesRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListNamespacesResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListOperationsRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListOperationsResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListServicesRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListServicesResponse
import aws.sdk.kotlin.services.servicediscovery.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.servicediscovery.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.servicediscovery.model.RegisterInstanceRequest
import aws.sdk.kotlin.services.servicediscovery.model.RegisterInstanceResponse
import aws.sdk.kotlin.services.servicediscovery.model.TagResourceRequest
import aws.sdk.kotlin.services.servicediscovery.model.TagResourceResponse
import aws.sdk.kotlin.services.servicediscovery.model.UntagResourceRequest
import aws.sdk.kotlin.services.servicediscovery.model.UntagResourceResponse
import aws.sdk.kotlin.services.servicediscovery.model.UpdateHttpNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.UpdateHttpNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.UpdateInstanceCustomHealthStatusRequest
import aws.sdk.kotlin.services.servicediscovery.model.UpdateInstanceCustomHealthStatusResponse
import aws.sdk.kotlin.services.servicediscovery.model.UpdatePrivateDnsNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.UpdatePrivateDnsNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.UpdatePublicDnsNamespaceRequest
import aws.sdk.kotlin.services.servicediscovery.model.UpdatePublicDnsNamespaceResponse
import aws.sdk.kotlin.services.servicediscovery.model.UpdateServiceRequest
import aws.sdk.kotlin.services.servicediscovery.model.UpdateServiceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Cloud Map
 * With Cloud Map, you can configure public DNS, private DNS, or HTTP namespaces that your microservice applications run in. When an instance becomes available, you can call the Cloud Map API to register the instance with Cloud Map. For public or private DNS namespaces, Cloud Map automatically creates DNS records and an optional health check. Clients that submit public or private DNS queries, or HTTP requests, for the service receive an answer that contains up to eight healthy records.
 */
public interface ServiceDiscoveryClient : SdkClient {

    override val serviceName: String
        get() = "ServiceDiscovery"
    /**
     * ServiceDiscoveryClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ServiceDiscoveryClient {
            val config = Config.Builder().apply(block).build()
            return DefaultServiceDiscoveryClient(config)
        }

        public operator fun invoke(config: Config): ServiceDiscoveryClient = DefaultServiceDiscoveryClient(config)

        /**
         * Construct a [ServiceDiscoveryClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ServiceDiscoveryClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultServiceDiscoveryClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an HTTP namespace. Service instances registered using an HTTP namespace can be discovered using a `DiscoverInstances` request but can't be discovered using DNS.
     *
     * For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     */
    public suspend fun createHttpNamespace(input: CreateHttpNamespaceRequest): CreateHttpNamespaceResponse

    /**
     * Creates a private namespace based on DNS, which is visible only inside a specified Amazon VPC. The namespace defines your service naming scheme. For example, if you name your namespace `example.com` and name your service `backend`, the resulting DNS name for the service is `backend.example.com`. Service instances that are registered using a private DNS namespace can be discovered using either a `DiscoverInstances` request or using DNS. For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     */
    public suspend fun createPrivateDnsNamespace(input: CreatePrivateDnsNamespaceRequest): CreatePrivateDnsNamespaceResponse

    /**
     * Creates a public namespace based on DNS, which is visible on the internet. The namespace defines your service naming scheme. For example, if you name your namespace `example.com` and name your service `backend`, the resulting DNS name for the service is `backend.example.com`. You can discover instances that were registered with a public DNS namespace by using either a `DiscoverInstances` request or using DNS. For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     *
     * The `CreatePublicDnsNamespace` API operation is not supported in the Amazon Web Services GovCloud (US) Regions.
     */
    public suspend fun createPublicDnsNamespace(input: CreatePublicDnsNamespaceRequest): CreatePublicDnsNamespaceResponse

    /**
     * Creates a service. This action defines the configuration for the following entities:
     * + For public and private DNS namespaces, one of the following combinations of DNS records in Amazon Route 53:
     *    + `A`
     *    + `AAAA`
     *    + `A` and `AAAA`
     *    + `SRV`
     *    + `CNAME`
     * + Optionally, a health check
     *
     * After you create the service, you can submit a [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html) request, and Cloud Map uses the values in the configuration to create the specified entities.
     *
     * For the current quota on the number of instances that you can register using the same namespace and using the same service, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     */
    public suspend fun createService(input: CreateServiceRequest): CreateServiceResponse

    /**
     * Deletes a namespace from the current account. If the namespace still contains one or more services, the request fails.
     */
    public suspend fun deleteNamespace(input: DeleteNamespaceRequest): DeleteNamespaceResponse

    /**
     * Deletes a specified service. If the service still contains one or more registered instances, the request fails.
     */
    public suspend fun deleteService(input: DeleteServiceRequest): DeleteServiceResponse

    /**
     * Deletes the Amazon Route 53 DNS records and health check, if any, that Cloud Map created for the specified instance.
     */
    public suspend fun deregisterInstance(input: DeregisterInstanceRequest): DeregisterInstanceResponse

    /**
     * Discovers registered instances for a specified namespace and service. You can use `DiscoverInstances` to discover instances for any type of namespace. For public and private DNS namespaces, you can also use DNS queries to discover instances.
     */
    public suspend fun discoverInstances(input: DiscoverInstancesRequest): DiscoverInstancesResponse

    /**
     * Gets information about a specified instance.
     */
    public suspend fun getInstance(input: GetInstanceRequest): GetInstanceResponse

    /**
     * Gets the current health status (`Healthy`, `Unhealthy`, or `Unknown`) of one or more instances that are associated with a specified service.
     *
     * There's a brief delay between when you register an instance and when the health status for the instance is available.
     */
    public suspend fun getInstancesHealthStatus(input: GetInstancesHealthStatusRequest): GetInstancesHealthStatusResponse

    /**
     * Gets information about a namespace.
     */
    public suspend fun getNamespace(input: GetNamespaceRequest): GetNamespaceResponse

    /**
     * Gets information about any operation that returns an operation ID in the response, such as a `CreateService` request.
     *
     * To get a list of operations that match specified criteria, see [ListOperations](https://docs.aws.amazon.com/cloud-map/latest/api/API_ListOperations.html).
     */
    public suspend fun getOperation(input: GetOperationRequest): GetOperationResponse

    /**
     * Gets the settings for a specified service.
     */
    public suspend fun getService(input: GetServiceRequest): GetServiceResponse

    /**
     * Lists summary information about the instances that you registered by using a specified service.
     */
    public suspend fun listInstances(input: ListInstancesRequest): ListInstancesResponse

    /**
     * Lists summary information about the namespaces that were created by the current Amazon Web Services account.
     */
    public suspend fun listNamespaces(input: ListNamespacesRequest = ListNamespacesRequest {}): ListNamespacesResponse

    /**
     * Lists operations that match the criteria that you specify.
     */
    public suspend fun listOperations(input: ListOperationsRequest = ListOperationsRequest {}): ListOperationsResponse

    /**
     * Lists summary information for all the services that are associated with one or more specified namespaces.
     */
    public suspend fun listServices(input: ListServicesRequest = ListServicesRequest {}): ListServicesResponse

    /**
     * Lists tags for the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates or updates one or more records and, optionally, creates a health check based on the settings in a specified service. When you submit a `RegisterInstance` request, the following occurs:
     * + For each DNS record that you define in the service that's specified by `ServiceId`, a record is created or updated in the hosted zone that's associated with the corresponding namespace.
     * + If the service includes `HealthCheckConfig`, a health check is created based on the settings in the health check configuration.
     * + The health check, if any, is associated with each of the new or updated records.
     *
     * One `RegisterInstance` request must complete before you can submit another request and specify the same service ID and instance ID.
     *
     * For more information, see [CreateService](https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html).
     *
     * When Cloud Map receives a DNS query for the specified DNS name, it returns the applicable value:
     * + **If the health check is healthy**: returns all the records
     * + **If the health check is unhealthy**: returns the applicable value for the last healthy instance
     * + **If you didn't specify a health check configuration**: returns all the records
     *
     * For the current quota on the number of instances that you can register using the same namespace and using the same service, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     */
    public suspend fun registerInstance(input: RegisterInstanceRequest): RegisterInstanceResponse

    /**
     * Adds one or more tags to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an HTTP namespace.
     */
    public suspend fun updateHttpNamespace(input: UpdateHttpNamespaceRequest): UpdateHttpNamespaceResponse

    /**
     * Submits a request to change the health status of a custom health check to healthy or unhealthy.
     *
     * You can use `UpdateInstanceCustomHealthStatus` to change the status only for custom health checks, which you define using `HealthCheckCustomConfig` when you create a service. You can't use it to change the status for Route 53 health checks, which you define using `HealthCheckConfig`.
     *
     * For more information, see [HealthCheckCustomConfig](https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html).
     */
    public suspend fun updateInstanceCustomHealthStatus(input: UpdateInstanceCustomHealthStatusRequest): UpdateInstanceCustomHealthStatusResponse

    /**
     * Updates a private DNS namespace.
     */
    public suspend fun updatePrivateDnsNamespace(input: UpdatePrivateDnsNamespaceRequest): UpdatePrivateDnsNamespaceResponse

    /**
     * Updates a public DNS namespace.
     */
    public suspend fun updatePublicDnsNamespace(input: UpdatePublicDnsNamespaceRequest): UpdatePublicDnsNamespaceResponse

    /**
     * Submits a request to perform the following operations:
     * + Update the TTL setting for existing `DnsRecords` configurations
     * + Add, update, or delete `HealthCheckConfig` for a specified serviceYou can't add, update, or delete a `HealthCheckCustomConfig` configuration.
     *
     * For public and private DNS namespaces, note the following:
     * + If you omit any existing `DnsRecords` or `HealthCheckConfig` configurations from an `UpdateService` request, the configurations are deleted from the service.
     * + If you omit an existing `HealthCheckCustomConfig` configuration from an `UpdateService` request, the configuration isn't deleted from the service.
     *
     * When you update settings for a service, Cloud Map also updates the corresponding settings in all the records and health checks that were created by using the specified service.
     */
    public suspend fun updateService(input: UpdateServiceRequest): UpdateServiceResponse
}

/**
 * Creates an HTTP namespace. Service instances registered using an HTTP namespace can be discovered using a `DiscoverInstances` request but can't be discovered using DNS.
 *
 * For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
 */
public suspend inline fun ServiceDiscoveryClient.createHttpNamespace(crossinline block: CreateHttpNamespaceRequest.Builder.() -> Unit): CreateHttpNamespaceResponse = createHttpNamespace(CreateHttpNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a private namespace based on DNS, which is visible only inside a specified Amazon VPC. The namespace defines your service naming scheme. For example, if you name your namespace `example.com` and name your service `backend`, the resulting DNS name for the service is `backend.example.com`. Service instances that are registered using a private DNS namespace can be discovered using either a `DiscoverInstances` request or using DNS. For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
 */
public suspend inline fun ServiceDiscoveryClient.createPrivateDnsNamespace(crossinline block: CreatePrivateDnsNamespaceRequest.Builder.() -> Unit): CreatePrivateDnsNamespaceResponse = createPrivateDnsNamespace(CreatePrivateDnsNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a public namespace based on DNS, which is visible on the internet. The namespace defines your service naming scheme. For example, if you name your namespace `example.com` and name your service `backend`, the resulting DNS name for the service is `backend.example.com`. You can discover instances that were registered with a public DNS namespace by using either a `DiscoverInstances` request or using DNS. For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
 *
 * The `CreatePublicDnsNamespace` API operation is not supported in the Amazon Web Services GovCloud (US) Regions.
 */
public suspend inline fun ServiceDiscoveryClient.createPublicDnsNamespace(crossinline block: CreatePublicDnsNamespaceRequest.Builder.() -> Unit): CreatePublicDnsNamespaceResponse = createPublicDnsNamespace(CreatePublicDnsNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a service. This action defines the configuration for the following entities:
 * + For public and private DNS namespaces, one of the following combinations of DNS records in Amazon Route 53:
 *    + `A`
 *    + `AAAA`
 *    + `A` and `AAAA`
 *    + `SRV`
 *    + `CNAME`
 * + Optionally, a health check
 *
 * After you create the service, you can submit a [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html) request, and Cloud Map uses the values in the configuration to create the specified entities.
 *
 * For the current quota on the number of instances that you can register using the same namespace and using the same service, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
 */
public suspend inline fun ServiceDiscoveryClient.createService(crossinline block: CreateServiceRequest.Builder.() -> Unit): CreateServiceResponse = createService(CreateServiceRequest.Builder().apply(block).build())

/**
 * Deletes a namespace from the current account. If the namespace still contains one or more services, the request fails.
 */
public suspend inline fun ServiceDiscoveryClient.deleteNamespace(crossinline block: DeleteNamespaceRequest.Builder.() -> Unit): DeleteNamespaceResponse = deleteNamespace(DeleteNamespaceRequest.Builder().apply(block).build())

/**
 * Deletes a specified service. If the service still contains one or more registered instances, the request fails.
 */
public suspend inline fun ServiceDiscoveryClient.deleteService(crossinline block: DeleteServiceRequest.Builder.() -> Unit): DeleteServiceResponse = deleteService(DeleteServiceRequest.Builder().apply(block).build())

/**
 * Deletes the Amazon Route 53 DNS records and health check, if any, that Cloud Map created for the specified instance.
 */
public suspend inline fun ServiceDiscoveryClient.deregisterInstance(crossinline block: DeregisterInstanceRequest.Builder.() -> Unit): DeregisterInstanceResponse = deregisterInstance(DeregisterInstanceRequest.Builder().apply(block).build())

/**
 * Discovers registered instances for a specified namespace and service. You can use `DiscoverInstances` to discover instances for any type of namespace. For public and private DNS namespaces, you can also use DNS queries to discover instances.
 */
public suspend inline fun ServiceDiscoveryClient.discoverInstances(crossinline block: DiscoverInstancesRequest.Builder.() -> Unit): DiscoverInstancesResponse = discoverInstances(DiscoverInstancesRequest.Builder().apply(block).build())

/**
 * Gets information about a specified instance.
 */
public suspend inline fun ServiceDiscoveryClient.getInstance(crossinline block: GetInstanceRequest.Builder.() -> Unit): GetInstanceResponse = getInstance(GetInstanceRequest.Builder().apply(block).build())

/**
 * Gets the current health status (`Healthy`, `Unhealthy`, or `Unknown`) of one or more instances that are associated with a specified service.
 *
 * There's a brief delay between when you register an instance and when the health status for the instance is available.
 */
public suspend inline fun ServiceDiscoveryClient.getInstancesHealthStatus(crossinline block: GetInstancesHealthStatusRequest.Builder.() -> Unit): GetInstancesHealthStatusResponse = getInstancesHealthStatus(GetInstancesHealthStatusRequest.Builder().apply(block).build())

/**
 * Gets information about a namespace.
 */
public suspend inline fun ServiceDiscoveryClient.getNamespace(crossinline block: GetNamespaceRequest.Builder.() -> Unit): GetNamespaceResponse = getNamespace(GetNamespaceRequest.Builder().apply(block).build())

/**
 * Gets information about any operation that returns an operation ID in the response, such as a `CreateService` request.
 *
 * To get a list of operations that match specified criteria, see [ListOperations](https://docs.aws.amazon.com/cloud-map/latest/api/API_ListOperations.html).
 */
public suspend inline fun ServiceDiscoveryClient.getOperation(crossinline block: GetOperationRequest.Builder.() -> Unit): GetOperationResponse = getOperation(GetOperationRequest.Builder().apply(block).build())

/**
 * Gets the settings for a specified service.
 */
public suspend inline fun ServiceDiscoveryClient.getService(crossinline block: GetServiceRequest.Builder.() -> Unit): GetServiceResponse = getService(GetServiceRequest.Builder().apply(block).build())

/**
 * Lists summary information about the instances that you registered by using a specified service.
 */
public suspend inline fun ServiceDiscoveryClient.listInstances(crossinline block: ListInstancesRequest.Builder.() -> Unit): ListInstancesResponse = listInstances(ListInstancesRequest.Builder().apply(block).build())

/**
 * Lists summary information about the namespaces that were created by the current Amazon Web Services account.
 */
public suspend inline fun ServiceDiscoveryClient.listNamespaces(crossinline block: ListNamespacesRequest.Builder.() -> Unit): ListNamespacesResponse = listNamespaces(ListNamespacesRequest.Builder().apply(block).build())

/**
 * Lists operations that match the criteria that you specify.
 */
public suspend inline fun ServiceDiscoveryClient.listOperations(crossinline block: ListOperationsRequest.Builder.() -> Unit): ListOperationsResponse = listOperations(ListOperationsRequest.Builder().apply(block).build())

/**
 * Lists summary information for all the services that are associated with one or more specified namespaces.
 */
public suspend inline fun ServiceDiscoveryClient.listServices(crossinline block: ListServicesRequest.Builder.() -> Unit): ListServicesResponse = listServices(ListServicesRequest.Builder().apply(block).build())

/**
 * Lists tags for the specified resource.
 */
public suspend inline fun ServiceDiscoveryClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates or updates one or more records and, optionally, creates a health check based on the settings in a specified service. When you submit a `RegisterInstance` request, the following occurs:
 * + For each DNS record that you define in the service that's specified by `ServiceId`, a record is created or updated in the hosted zone that's associated with the corresponding namespace.
 * + If the service includes `HealthCheckConfig`, a health check is created based on the settings in the health check configuration.
 * + The health check, if any, is associated with each of the new or updated records.
 *
 * One `RegisterInstance` request must complete before you can submit another request and specify the same service ID and instance ID.
 *
 * For more information, see [CreateService](https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html).
 *
 * When Cloud Map receives a DNS query for the specified DNS name, it returns the applicable value:
 * + **If the health check is healthy**: returns all the records
 * + **If the health check is unhealthy**: returns the applicable value for the last healthy instance
 * + **If you didn't specify a health check configuration**: returns all the records
 *
 * For the current quota on the number of instances that you can register using the same namespace and using the same service, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
 */
public suspend inline fun ServiceDiscoveryClient.registerInstance(crossinline block: RegisterInstanceRequest.Builder.() -> Unit): RegisterInstanceResponse = registerInstance(RegisterInstanceRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to the specified resource.
 */
public suspend inline fun ServiceDiscoveryClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified resource.
 */
public suspend inline fun ServiceDiscoveryClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an HTTP namespace.
 */
public suspend inline fun ServiceDiscoveryClient.updateHttpNamespace(crossinline block: UpdateHttpNamespaceRequest.Builder.() -> Unit): UpdateHttpNamespaceResponse = updateHttpNamespace(UpdateHttpNamespaceRequest.Builder().apply(block).build())

/**
 * Submits a request to change the health status of a custom health check to healthy or unhealthy.
 *
 * You can use `UpdateInstanceCustomHealthStatus` to change the status only for custom health checks, which you define using `HealthCheckCustomConfig` when you create a service. You can't use it to change the status for Route 53 health checks, which you define using `HealthCheckConfig`.
 *
 * For more information, see [HealthCheckCustomConfig](https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html).
 */
public suspend inline fun ServiceDiscoveryClient.updateInstanceCustomHealthStatus(crossinline block: UpdateInstanceCustomHealthStatusRequest.Builder.() -> Unit): UpdateInstanceCustomHealthStatusResponse = updateInstanceCustomHealthStatus(UpdateInstanceCustomHealthStatusRequest.Builder().apply(block).build())

/**
 * Updates a private DNS namespace.
 */
public suspend inline fun ServiceDiscoveryClient.updatePrivateDnsNamespace(crossinline block: UpdatePrivateDnsNamespaceRequest.Builder.() -> Unit): UpdatePrivateDnsNamespaceResponse = updatePrivateDnsNamespace(UpdatePrivateDnsNamespaceRequest.Builder().apply(block).build())

/**
 * Updates a public DNS namespace.
 */
public suspend inline fun ServiceDiscoveryClient.updatePublicDnsNamespace(crossinline block: UpdatePublicDnsNamespaceRequest.Builder.() -> Unit): UpdatePublicDnsNamespaceResponse = updatePublicDnsNamespace(UpdatePublicDnsNamespaceRequest.Builder().apply(block).build())

/**
 * Submits a request to perform the following operations:
 * + Update the TTL setting for existing `DnsRecords` configurations
 * + Add, update, or delete `HealthCheckConfig` for a specified serviceYou can't add, update, or delete a `HealthCheckCustomConfig` configuration.
 *
 * For public and private DNS namespaces, note the following:
 * + If you omit any existing `DnsRecords` or `HealthCheckConfig` configurations from an `UpdateService` request, the configurations are deleted from the service.
 * + If you omit an existing `HealthCheckCustomConfig` configuration from an `UpdateService` request, the configuration isn't deleted from the service.
 *
 * When you update settings for a service, Cloud Map also updates the corresponding settings in all the records and health checks that were created by using the specified service.
 */
public suspend inline fun ServiceDiscoveryClient.updateService(crossinline block: UpdateServiceRequest.Builder.() -> Unit): UpdateServiceResponse = updateService(UpdateServiceRequest.Builder().apply(block).build())
