// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicediscovery

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.servicediscovery.model.*
import aws.sdk.kotlin.services.servicediscovery.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "ServiceDiscovery"
public const val ServiceApiVersion: String = "2017-03-14"
public const val SdkVersion: String = "0.17.10-beta"

internal class DefaultServiceDiscoveryClient(override val config: ServiceDiscoveryClient.Config) : ServiceDiscoveryClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates an HTTP namespace. Service instances registered using an HTTP namespace can be discovered using a `DiscoverInstances` request but can't be discovered using DNS.
     *
     * For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     */
    override suspend fun createHttpNamespace(input: CreateHttpNamespaceRequest): CreateHttpNamespaceResponse {
        val op = SdkHttpOperation.build<CreateHttpNamespaceRequest, CreateHttpNamespaceResponse> {
            serializer = CreateHttpNamespaceOperationSerializer()
            deserializer = CreateHttpNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateHttpNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a private namespace based on DNS, which is visible only inside a specified Amazon VPC. The namespace defines your service naming scheme. For example, if you name your namespace `example.com` and name your service `backend`, the resulting DNS name for the service is `backend.example.com`. Service instances that are registered using a private DNS namespace can be discovered using either a `DiscoverInstances` request or using DNS. For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     */
    override suspend fun createPrivateDnsNamespace(input: CreatePrivateDnsNamespaceRequest): CreatePrivateDnsNamespaceResponse {
        val op = SdkHttpOperation.build<CreatePrivateDnsNamespaceRequest, CreatePrivateDnsNamespaceResponse> {
            serializer = CreatePrivateDnsNamespaceOperationSerializer()
            deserializer = CreatePrivateDnsNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePrivateDnsNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a public namespace based on DNS, which is visible on the internet. The namespace defines your service naming scheme. For example, if you name your namespace `example.com` and name your service `backend`, the resulting DNS name for the service is `backend.example.com`. You can discover instances that were registered with a public DNS namespace by using either a `DiscoverInstances` request or using DNS. For the current quota on the number of namespaces that you can create using the same Amazon Web Services account, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     *
     * The `CreatePublicDnsNamespace` API operation is not supported in the Amazon Web Services GovCloud (US) Regions.
     */
    override suspend fun createPublicDnsNamespace(input: CreatePublicDnsNamespaceRequest): CreatePublicDnsNamespaceResponse {
        val op = SdkHttpOperation.build<CreatePublicDnsNamespaceRequest, CreatePublicDnsNamespaceResponse> {
            serializer = CreatePublicDnsNamespaceOperationSerializer()
            deserializer = CreatePublicDnsNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePublicDnsNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a service. This action defines the configuration for the following entities:
     * + For public and private DNS namespaces, one of the following combinations of DNS records in Amazon Route 53:
     *    + `A`
     *    + `AAAA`
     *    + `A` and `AAAA`
     *    + `SRV`
     *    + `CNAME`
     * + Optionally, a health check
     *
     * After you create the service, you can submit a [RegisterInstance](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html) request, and Cloud Map uses the values in the configuration to create the specified entities.
     *
     * For the current quota on the number of instances that you can register using the same namespace and using the same service, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     */
    override suspend fun createService(input: CreateServiceRequest): CreateServiceResponse {
        val op = SdkHttpOperation.build<CreateServiceRequest, CreateServiceResponse> {
            serializer = CreateServiceOperationSerializer()
            deserializer = CreateServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a namespace from the current account. If the namespace still contains one or more services, the request fails.
     */
    override suspend fun deleteNamespace(input: DeleteNamespaceRequest): DeleteNamespaceResponse {
        val op = SdkHttpOperation.build<DeleteNamespaceRequest, DeleteNamespaceResponse> {
            serializer = DeleteNamespaceOperationSerializer()
            deserializer = DeleteNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified service. If the service still contains one or more registered instances, the request fails.
     */
    override suspend fun deleteService(input: DeleteServiceRequest): DeleteServiceResponse {
        val op = SdkHttpOperation.build<DeleteServiceRequest, DeleteServiceResponse> {
            serializer = DeleteServiceOperationSerializer()
            deserializer = DeleteServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the Amazon Route 53 DNS records and health check, if any, that Cloud Map created for the specified instance.
     */
    override suspend fun deregisterInstance(input: DeregisterInstanceRequest): DeregisterInstanceResponse {
        val op = SdkHttpOperation.build<DeregisterInstanceRequest, DeregisterInstanceResponse> {
            serializer = DeregisterInstanceOperationSerializer()
            deserializer = DeregisterInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Discovers registered instances for a specified namespace and service. You can use `DiscoverInstances` to discover instances for any type of namespace. For public and private DNS namespaces, you can also use DNS queries to discover instances.
     */
    override suspend fun discoverInstances(input: DiscoverInstancesRequest): DiscoverInstancesResponse {
        val op = SdkHttpOperation.build<DiscoverInstancesRequest, DiscoverInstancesResponse> {
            serializer = DiscoverInstancesOperationSerializer()
            deserializer = DiscoverInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DiscoverInstances"
                hostPrefix = "data-"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a specified instance.
     */
    override suspend fun getInstance(input: GetInstanceRequest): GetInstanceResponse {
        val op = SdkHttpOperation.build<GetInstanceRequest, GetInstanceResponse> {
            serializer = GetInstanceOperationSerializer()
            deserializer = GetInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the current health status (`Healthy`, `Unhealthy`, or `Unknown`) of one or more instances that are associated with a specified service.
     *
     * There's a brief delay between when you register an instance and when the health status for the instance is available.
     */
    override suspend fun getInstancesHealthStatus(input: GetInstancesHealthStatusRequest): GetInstancesHealthStatusResponse {
        val op = SdkHttpOperation.build<GetInstancesHealthStatusRequest, GetInstancesHealthStatusResponse> {
            serializer = GetInstancesHealthStatusOperationSerializer()
            deserializer = GetInstancesHealthStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInstancesHealthStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about a namespace.
     */
    override suspend fun getNamespace(input: GetNamespaceRequest): GetNamespaceResponse {
        val op = SdkHttpOperation.build<GetNamespaceRequest, GetNamespaceResponse> {
            serializer = GetNamespaceOperationSerializer()
            deserializer = GetNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about any operation that returns an operation ID in the response, such as a `CreateService` request.
     *
     * To get a list of operations that match specified criteria, see [ListOperations](https://docs.aws.amazon.com/cloud-map/latest/api/API_ListOperations.html).
     */
    override suspend fun getOperation(input: GetOperationRequest): GetOperationResponse {
        val op = SdkHttpOperation.build<GetOperationRequest, GetOperationResponse> {
            serializer = GetOperationOperationSerializer()
            deserializer = GetOperationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetOperation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the settings for a specified service.
     */
    override suspend fun getService(input: GetServiceRequest): GetServiceResponse {
        val op = SdkHttpOperation.build<GetServiceRequest, GetServiceResponse> {
            serializer = GetServiceOperationSerializer()
            deserializer = GetServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists summary information about the instances that you registered by using a specified service.
     */
    override suspend fun listInstances(input: ListInstancesRequest): ListInstancesResponse {
        val op = SdkHttpOperation.build<ListInstancesRequest, ListInstancesResponse> {
            serializer = ListInstancesOperationSerializer()
            deserializer = ListInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists summary information about the namespaces that were created by the current Amazon Web Services account.
     */
    override suspend fun listNamespaces(input: ListNamespacesRequest): ListNamespacesResponse {
        val op = SdkHttpOperation.build<ListNamespacesRequest, ListNamespacesResponse> {
            serializer = ListNamespacesOperationSerializer()
            deserializer = ListNamespacesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNamespaces"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists operations that match the criteria that you specify.
     */
    override suspend fun listOperations(input: ListOperationsRequest): ListOperationsResponse {
        val op = SdkHttpOperation.build<ListOperationsRequest, ListOperationsResponse> {
            serializer = ListOperationsOperationSerializer()
            deserializer = ListOperationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOperations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists summary information for all the services that are associated with one or more specified namespaces.
     */
    override suspend fun listServices(input: ListServicesRequest): ListServicesResponse {
        val op = SdkHttpOperation.build<ListServicesRequest, ListServicesResponse> {
            serializer = ListServicesOperationSerializer()
            deserializer = ListServicesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListServices"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists tags for the specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates or updates one or more records and, optionally, creates a health check based on the settings in a specified service. When you submit a `RegisterInstance` request, the following occurs:
     * + For each DNS record that you define in the service that's specified by `ServiceId`, a record is created or updated in the hosted zone that's associated with the corresponding namespace.
     * + If the service includes `HealthCheckConfig`, a health check is created based on the settings in the health check configuration.
     * + The health check, if any, is associated with each of the new or updated records.
     *
     * One `RegisterInstance` request must complete before you can submit another request and specify the same service ID and instance ID.
     *
     * For more information, see [CreateService](https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html).
     *
     * When Cloud Map receives a DNS query for the specified DNS name, it returns the applicable value:
     * + **If the health check is healthy**: returns all the records
     * + **If the health check is unhealthy**: returns the applicable value for the last healthy instance
     * + **If you didn't specify a health check configuration**: returns all the records
     *
     * For the current quota on the number of instances that you can register using the same namespace and using the same service, see [Cloud Map quotas](https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html) in the *Cloud Map Developer Guide*.
     */
    override suspend fun registerInstance(input: RegisterInstanceRequest): RegisterInstanceResponse {
        val op = SdkHttpOperation.build<RegisterInstanceRequest, RegisterInstanceResponse> {
            serializer = RegisterInstanceOperationSerializer()
            deserializer = RegisterInstanceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterInstance"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more tags to the specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from the specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an HTTP namespace.
     */
    override suspend fun updateHttpNamespace(input: UpdateHttpNamespaceRequest): UpdateHttpNamespaceResponse {
        val op = SdkHttpOperation.build<UpdateHttpNamespaceRequest, UpdateHttpNamespaceResponse> {
            serializer = UpdateHttpNamespaceOperationSerializer()
            deserializer = UpdateHttpNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateHttpNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Submits a request to change the health status of a custom health check to healthy or unhealthy.
     *
     * You can use `UpdateInstanceCustomHealthStatus` to change the status only for custom health checks, which you define using `HealthCheckCustomConfig` when you create a service. You can't use it to change the status for Route 53 health checks, which you define using `HealthCheckConfig`.
     *
     * For more information, see [HealthCheckCustomConfig](https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html).
     */
    override suspend fun updateInstanceCustomHealthStatus(input: UpdateInstanceCustomHealthStatusRequest): UpdateInstanceCustomHealthStatusResponse {
        val op = SdkHttpOperation.build<UpdateInstanceCustomHealthStatusRequest, UpdateInstanceCustomHealthStatusResponse> {
            serializer = UpdateInstanceCustomHealthStatusOperationSerializer()
            deserializer = UpdateInstanceCustomHealthStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateInstanceCustomHealthStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a private DNS namespace.
     */
    override suspend fun updatePrivateDnsNamespace(input: UpdatePrivateDnsNamespaceRequest): UpdatePrivateDnsNamespaceResponse {
        val op = SdkHttpOperation.build<UpdatePrivateDnsNamespaceRequest, UpdatePrivateDnsNamespaceResponse> {
            serializer = UpdatePrivateDnsNamespaceOperationSerializer()
            deserializer = UpdatePrivateDnsNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePrivateDnsNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a public DNS namespace.
     */
    override suspend fun updatePublicDnsNamespace(input: UpdatePublicDnsNamespaceRequest): UpdatePublicDnsNamespaceResponse {
        val op = SdkHttpOperation.build<UpdatePublicDnsNamespaceRequest, UpdatePublicDnsNamespaceResponse> {
            serializer = UpdatePublicDnsNamespaceOperationSerializer()
            deserializer = UpdatePublicDnsNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePublicDnsNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Submits a request to perform the following operations:
     * + Update the TTL setting for existing `DnsRecords` configurations
     * + Add, update, or delete `HealthCheckConfig` for a specified serviceYou can't add, update, or delete a `HealthCheckCustomConfig` configuration.
     *
     * For public and private DNS namespaces, note the following:
     * + If you omit any existing `DnsRecords` or `HealthCheckConfig` configurations from an `UpdateService` request, the configurations are deleted from the service.
     * + If you omit an existing `HealthCheckCustomConfig` configuration from an `UpdateService` request, the configuration isn't deleted from the service.
     *
     * When you update settings for a service, Cloud Map also updates the corresponding settings in all the records and health checks that were created by using the specified service.
     */
    override suspend fun updateService(input: UpdateServiceRequest): UpdateServiceResponse {
        val op = SdkHttpOperation.build<UpdateServiceRequest, UpdateServiceResponse> {
            serializer = UpdateServiceOperationSerializer()
            deserializer = UpdateServiceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateService"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Route53AutoNaming_v20170314", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "servicediscovery"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "servicediscovery")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
