// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalogappregistry.paginators

import aws.sdk.kotlin.services.servicecatalogappregistry.ServiceCatalogAppRegistryClient
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ApplicationSummary
import aws.sdk.kotlin.services.servicecatalogappregistry.model.AttributeGroupDetails
import aws.sdk.kotlin.services.servicecatalogappregistry.model.AttributeGroupSummary
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListApplicationsRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListApplicationsResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAssociatedResourcesResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAttributeGroupsRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAttributeGroupsResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ResourceInfo
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun ServiceCatalogAppRegistryClient.listApplicationsPaginated(initialRequest: ListApplicationsRequest = ListApplicationsRequest { }): Flow<ListApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationsPaginated.listApplications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun ServiceCatalogAppRegistryClient.listApplicationsPaginated(block: ListApplicationsRequest.Builder.() -> Unit): Flow<ListApplicationsResponse> =
    listApplicationsPaginated(ListApplicationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationsPaginated]
 * to access the nested member [ApplicationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApplicationSummary]
 */
@JvmName("listApplicationsResponseApplicationSummary")
public fun Flow<ListApplicationsResponse>.applications(): Flow<ApplicationSummary> =
    transform() { response ->
        response.applications?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAssociatedAttributeGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssociatedAttributeGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedAttributeGroupsResponse]
 */
public fun ServiceCatalogAppRegistryClient.listAssociatedAttributeGroupsPaginated(initialRequest: ListAssociatedAttributeGroupsRequest): Flow<ListAssociatedAttributeGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssociatedAttributeGroupsPaginated.listAssociatedAttributeGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAssociatedAttributeGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedAttributeGroupsResponse]
 */
public fun ServiceCatalogAppRegistryClient.listAssociatedAttributeGroupsPaginated(block: ListAssociatedAttributeGroupsRequest.Builder.() -> Unit): Flow<ListAssociatedAttributeGroupsResponse> =
    listAssociatedAttributeGroupsPaginated(ListAssociatedAttributeGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAssociatedAttributeGroupsPaginated]
 * to access the nested member [AttributeGroupId]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AttributeGroupId]
 */
@JvmName("listAssociatedAttributeGroupsResponseAttributeGroupId")
public fun Flow<ListAssociatedAttributeGroupsResponse>.attributeGroups(): Flow<String> =
    transform() { response ->
        response.attributeGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAssociatedResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAssociatedResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedResourcesResponse]
 */
public fun ServiceCatalogAppRegistryClient.listAssociatedResourcesPaginated(initialRequest: ListAssociatedResourcesRequest): Flow<ListAssociatedResourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAssociatedResourcesPaginated.listAssociatedResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAssociatedResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAssociatedResourcesResponse]
 */
public fun ServiceCatalogAppRegistryClient.listAssociatedResourcesPaginated(block: ListAssociatedResourcesRequest.Builder.() -> Unit): Flow<ListAssociatedResourcesResponse> =
    listAssociatedResourcesPaginated(ListAssociatedResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAssociatedResourcesPaginated]
 * to access the nested member [ResourceInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceInfo]
 */
@JvmName("listAssociatedResourcesResponseResourceInfo")
public fun Flow<ListAssociatedResourcesResponse>.resources(): Flow<ResourceInfo> =
    transform() { response ->
        response.resources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAttributeGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAttributeGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttributeGroupsResponse]
 */
public fun ServiceCatalogAppRegistryClient.listAttributeGroupsPaginated(initialRequest: ListAttributeGroupsRequest = ListAttributeGroupsRequest { }): Flow<ListAttributeGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAttributeGroupsPaginated.listAttributeGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAttributeGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttributeGroupsResponse]
 */
public fun ServiceCatalogAppRegistryClient.listAttributeGroupsPaginated(block: ListAttributeGroupsRequest.Builder.() -> Unit): Flow<ListAttributeGroupsResponse> =
    listAttributeGroupsPaginated(ListAttributeGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAttributeGroupsPaginated]
 * to access the nested member [AttributeGroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AttributeGroupSummary]
 */
@JvmName("listAttributeGroupsResponseAttributeGroupSummary")
public fun Flow<ListAttributeGroupsResponse>.attributeGroups(): Flow<AttributeGroupSummary> =
    transform() { response ->
        response.attributeGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAttributeGroupsForApplicationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAttributeGroupsForApplicationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttributeGroupsForApplicationResponse]
 */
public fun ServiceCatalogAppRegistryClient.listAttributeGroupsForApplicationPaginated(initialRequest: ListAttributeGroupsForApplicationRequest): Flow<ListAttributeGroupsForApplicationResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAttributeGroupsForApplicationPaginated.listAttributeGroupsForApplication(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAttributeGroupsForApplicationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttributeGroupsForApplicationResponse]
 */
public fun ServiceCatalogAppRegistryClient.listAttributeGroupsForApplicationPaginated(block: ListAttributeGroupsForApplicationRequest.Builder.() -> Unit): Flow<ListAttributeGroupsForApplicationResponse> =
    listAttributeGroupsForApplicationPaginated(ListAttributeGroupsForApplicationRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAttributeGroupsForApplicationPaginated]
 * to access the nested member [AttributeGroupDetails]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AttributeGroupDetails]
 */
@JvmName("listAttributeGroupsForApplicationResponseAttributeGroupDetails")
public fun Flow<ListAttributeGroupsForApplicationResponse>.attributeGroupsDetails(): Flow<AttributeGroupDetails> =
    transform() { response ->
        response.attributeGroupsDetails?.forEach {
            emit(it)
        }
    }
