// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalogappregistry.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a Amazon Web Services Service Catalog AppRegistry attribute group that is rich metadata which describes an application and its components.
 */
public class AttributeGroup private constructor(builder: Builder) {
    /**
     * The Amazon resource name (ARN) that specifies the attribute group across services.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The ISO-8601 formatted timestamp of the moment the attribute group was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The description of the attribute group that the user provides.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The globally unique attribute group identifier of the attribute group.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * The name of the attribute group.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Key-value pairs you can use to associate with the attribute group.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalogappregistry.model.AttributeGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttributeGroup(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("name=$name,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttributeGroup

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (name != other.name) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalogappregistry.model.AttributeGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon resource name (ARN) that specifies the attribute group across services.
         */
        public var arn: kotlin.String? = null
        /**
         * The ISO-8601 formatted timestamp of the moment the attribute group was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the attribute group that the user provides.
         */
        public var description: kotlin.String? = null
        /**
         * The globally unique attribute group identifier of the attribute group.
         */
        public var id: kotlin.String? = null
        /**
         * The ISO-8601 formatted timestamp of the moment the attribute group was last updated. This time is the same as the creationTime for a newly created attribute group.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the attribute group.
         */
        public var name: kotlin.String? = null
        /**
         * Key-value pairs you can use to associate with the attribute group.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalogappregistry.model.AttributeGroup) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.description = x.description
            this.id = x.id
            this.lastUpdateTime = x.lastUpdateTime
            this.name = x.name
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalogappregistry.model.AttributeGroup = AttributeGroup(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
