// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalogappregistry

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.servicecatalogappregistry.auth.DefaultServiceCatalogAppRegistryAuthSchemeProvider
import aws.sdk.kotlin.services.servicecatalogappregistry.auth.ServiceCatalogAppRegistryAuthSchemeProvider
import aws.sdk.kotlin.services.servicecatalogappregistry.endpoints.DefaultServiceCatalogAppRegistryEndpointProvider
import aws.sdk.kotlin.services.servicecatalogappregistry.endpoints.ServiceCatalogAppRegistryEndpointParameters
import aws.sdk.kotlin.services.servicecatalogappregistry.endpoints.ServiceCatalogAppRegistryEndpointProvider
import aws.sdk.kotlin.services.servicecatalogappregistry.model.AssociateAttributeGroupRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.AssociateAttributeGroupResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.AssociateResourceRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.AssociateResourceResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.CreateApplicationRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.CreateApplicationResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.CreateAttributeGroupRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.CreateAttributeGroupResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.DeleteAttributeGroupRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.DeleteAttributeGroupResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.DisassociateAttributeGroupRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.DisassociateAttributeGroupResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.DisassociateResourceRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.DisassociateResourceResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.GetApplicationRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.GetApplicationResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.GetAssociatedResourceRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.GetAssociatedResourceResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.GetAttributeGroupRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.GetAttributeGroupResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.GetConfigurationRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.GetConfigurationResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListApplicationsRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListApplicationsResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAssociatedResourcesResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAttributeGroupsRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListAttributeGroupsResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.PutConfigurationRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.PutConfigurationResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.SyncResourceRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.SyncResourceResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.TagResourceRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.TagResourceResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.UntagResourceRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.UntagResourceResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.UpdateApplicationResponse
import aws.sdk.kotlin.services.servicecatalogappregistry.model.UpdateAttributeGroupRequest
import aws.sdk.kotlin.services.servicecatalogappregistry.model.UpdateAttributeGroupResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "Service Catalog AppRegistry"
public const val SdkVersion: String = "1.5.16"
public const val ServiceApiVersion: String = "2020-06-24"

/**
 * Amazon Web Services Service Catalog AppRegistry enables organizations to understand the application context of their Amazon Web Services resources. AppRegistry provides a repository of your applications, their resources, and the application metadata that you use within your enterprise.
 */
public interface ServiceCatalogAppRegistryClient : SdkClient {
    /**
     * ServiceCatalogAppRegistryClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ServiceCatalogAppRegistryClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ServiceCatalogAppRegistry",
                "SERVICE_CATALOG_APPREGISTRY",
                "service_catalog_appregistry",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ServiceCatalogAppRegistryClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ServiceCatalogAppRegistryClient = DefaultServiceCatalogAppRegistryClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ServiceCatalogAppRegistryEndpointProvider = builder.endpointProvider ?: DefaultServiceCatalogAppRegistryEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ServiceCatalogAppRegistryAuthSchemeProvider = builder.authSchemeProvider ?: DefaultServiceCatalogAppRegistryAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Service Catalog AppRegistry"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ServiceCatalogAppRegistryEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ServiceCatalogAppRegistryAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates an attribute group with an application to augment the application's metadata with the group's attributes. This feature enables applications to be described with user-defined details that are machine-readable, such as third-party integrations.
     */
    public suspend fun associateAttributeGroup(input: AssociateAttributeGroupRequest): AssociateAttributeGroupResponse

    /**
     * Associates a resource with an application. The resource can be specified by its ARN or name. The application can be specified by ARN, ID, or name.
     *
     * **Minimum permissions**
     *
     *  You must have the following permissions to associate a resource using the `OPTIONS` parameter set to `APPLY_APPLICATION_TAG`.
     * + `tag:GetResources`
     * + `tag:TagResources`
     *
     *  You must also have these additional permissions if you don't use the `AWSServiceCatalogAppRegistryFullAccess` policy. For more information, see [AWSServiceCatalogAppRegistryFullAccess](https://docs.aws.amazon.com/servicecatalog/latest/arguide/full.html) in the AppRegistry Administrator Guide.
     * + `resource-groups:AssociateResource`
     * + `cloudformation:UpdateStack`
     * + `cloudformation:DescribeStacks`
     *
     *  In addition, you must have the tagging permission defined by the Amazon Web Services service that creates the resource. For more information, see [TagResources](https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_TagResources.html) in the *Resource Groups Tagging API Reference*.
     */
    public suspend fun associateResource(input: AssociateResourceRequest): AssociateResourceResponse

    /**
     * Creates a new application that is the top-level node in a hierarchy of related cloud resource abstractions.
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates a new attribute group as a container for user-defined attributes. This feature enables users to have full control over their cloud application's metadata in a rich machine-readable format to facilitate integration with automated workflows and third-party tools.
     */
    public suspend fun createAttributeGroup(input: CreateAttributeGroupRequest): CreateAttributeGroupResponse

    /**
     * Deletes an application that is specified either by its application ID, name, or ARN. All associated attribute groups and resources must be disassociated from it before deleting an application.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes an attribute group, specified either by its attribute group ID, name, or ARN.
     */
    public suspend fun deleteAttributeGroup(input: DeleteAttributeGroupRequest): DeleteAttributeGroupResponse

    /**
     * Disassociates an attribute group from an application to remove the extra attributes contained in the attribute group from the application's metadata. This operation reverts `AssociateAttributeGroup`.
     */
    public suspend fun disassociateAttributeGroup(input: DisassociateAttributeGroupRequest): DisassociateAttributeGroupResponse

    /**
     * Disassociates a resource from application. Both the resource and the application can be specified either by ID or name.
     *
     * **Minimum permissions**
     *
     *  You must have the following permissions to remove a resource that's been associated with an application using the `APPLY_APPLICATION_TAG` option for [AssociateResource](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_AssociateResource.html).
     * + `tag:GetResources`
     * + `tag:UntagResources`
     *
     *  You must also have the following permissions if you don't use the `AWSServiceCatalogAppRegistryFullAccess` policy. For more information, see [AWSServiceCatalogAppRegistryFullAccess](https://docs.aws.amazon.com/servicecatalog/latest/arguide/full.html) in the AppRegistry Administrator Guide.
     * + `resource-groups:DisassociateResource`
     * + `cloudformation:UpdateStack`
     * + `cloudformation:DescribeStacks`
     *
     *  In addition, you must have the tagging permission defined by the Amazon Web Services service that creates the resource. For more information, see [UntagResources](https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_UntTagResources.html) in the *Resource Groups Tagging API Reference*.
     */
    public suspend fun disassociateResource(input: DisassociateResourceRequest): DisassociateResourceResponse

    /**
     * Retrieves metadata information about one of your applications. The application can be specified by its ARN, ID, or name (which is unique within one account in one region at a given point in time). Specify by ARN or ID in automated workflows if you want to make sure that the exact same application is returned or a `ResourceNotFoundException` is thrown, avoiding the ABA addressing problem.
     */
    public suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse

    /**
     * Gets the resource associated with the application.
     */
    public suspend fun getAssociatedResource(input: GetAssociatedResourceRequest): GetAssociatedResourceResponse

    /**
     * Retrieves an attribute group by its ARN, ID, or name. The attribute group can be specified by its ARN, ID, or name.
     */
    public suspend fun getAttributeGroup(input: GetAttributeGroupRequest): GetAttributeGroupResponse

    /**
     * Retrieves a `TagKey` configuration from an account.
     */
    public suspend fun getConfiguration(input: GetConfigurationRequest = GetConfigurationRequest { }): GetConfigurationResponse

    /**
     * Retrieves a list of all of your applications. Results are paginated.
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest { }): ListApplicationsResponse

    /**
     * Lists all attribute groups that are associated with specified application. Results are paginated.
     */
    public suspend fun listAssociatedAttributeGroups(input: ListAssociatedAttributeGroupsRequest): ListAssociatedAttributeGroupsResponse

    /**
     * Lists all of the resources that are associated with the specified application. Results are paginated.
     *
     *  If you share an application, and a consumer account associates a tag query to the application, all of the users who can access the application can also view the tag values in all accounts that are associated with it using this API.
     */
    public suspend fun listAssociatedResources(input: ListAssociatedResourcesRequest): ListAssociatedResourcesResponse

    /**
     * Lists all attribute groups which you have access to. Results are paginated.
     */
    public suspend fun listAttributeGroups(input: ListAttributeGroupsRequest = ListAttributeGroupsRequest { }): ListAttributeGroupsResponse

    /**
     * Lists the details of all attribute groups associated with a specific application. The results display in pages.
     */
    public suspend fun listAttributeGroupsForApplication(input: ListAttributeGroupsForApplicationRequest): ListAttributeGroupsForApplicationResponse

    /**
     * Lists all of the tags on the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Associates a `TagKey` configuration to an account.
     */
    public suspend fun putConfiguration(input: PutConfigurationRequest): PutConfigurationResponse

    /**
     * Syncs the resource with current AppRegistry records.
     *
     * Specifically, the resource’s AppRegistry system tags sync with its associated application. We remove the resource's AppRegistry system tags if it does not associate with the application. The caller must have permissions to read and update the resource.
     */
    public suspend fun syncResource(input: SyncResourceRequest): SyncResourceResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified resource.
     *
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the resource, this action updates its value.
     *
     * This operation returns an empty response if the call was successful.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from a resource.
     *
     * This operation returns an empty response if the call was successful.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing application with new attributes.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates an existing attribute group with new details.
     */
    public suspend fun updateAttributeGroup(input: UpdateAttributeGroupRequest): UpdateAttributeGroupResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ServiceCatalogAppRegistryClient.withConfig(block: ServiceCatalogAppRegistryClient.Config.Builder.() -> Unit): ServiceCatalogAppRegistryClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultServiceCatalogAppRegistryClient(newConfig)
}

/**
 * Associates an attribute group with an application to augment the application's metadata with the group's attributes. This feature enables applications to be described with user-defined details that are machine-readable, such as third-party integrations.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.associateAttributeGroup(crossinline block: AssociateAttributeGroupRequest.Builder.() -> Unit): AssociateAttributeGroupResponse = associateAttributeGroup(AssociateAttributeGroupRequest.Builder().apply(block).build())

/**
 * Associates a resource with an application. The resource can be specified by its ARN or name. The application can be specified by ARN, ID, or name.
 *
 * **Minimum permissions**
 *
 *  You must have the following permissions to associate a resource using the `OPTIONS` parameter set to `APPLY_APPLICATION_TAG`.
 * + `tag:GetResources`
 * + `tag:TagResources`
 *
 *  You must also have these additional permissions if you don't use the `AWSServiceCatalogAppRegistryFullAccess` policy. For more information, see [AWSServiceCatalogAppRegistryFullAccess](https://docs.aws.amazon.com/servicecatalog/latest/arguide/full.html) in the AppRegistry Administrator Guide.
 * + `resource-groups:AssociateResource`
 * + `cloudformation:UpdateStack`
 * + `cloudformation:DescribeStacks`
 *
 *  In addition, you must have the tagging permission defined by the Amazon Web Services service that creates the resource. For more information, see [TagResources](https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_TagResources.html) in the *Resource Groups Tagging API Reference*.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.associateResource(crossinline block: AssociateResourceRequest.Builder.() -> Unit): AssociateResourceResponse = associateResource(AssociateResourceRequest.Builder().apply(block).build())

/**
 * Creates a new application that is the top-level node in a hierarchy of related cloud resource abstractions.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates a new attribute group as a container for user-defined attributes. This feature enables users to have full control over their cloud application's metadata in a rich machine-readable format to facilitate integration with automated workflows and third-party tools.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.createAttributeGroup(crossinline block: CreateAttributeGroupRequest.Builder.() -> Unit): CreateAttributeGroupResponse = createAttributeGroup(CreateAttributeGroupRequest.Builder().apply(block).build())

/**
 * Deletes an application that is specified either by its application ID, name, or ARN. All associated attribute groups and resources must be disassociated from it before deleting an application.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Deletes an attribute group, specified either by its attribute group ID, name, or ARN.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.deleteAttributeGroup(crossinline block: DeleteAttributeGroupRequest.Builder.() -> Unit): DeleteAttributeGroupResponse = deleteAttributeGroup(DeleteAttributeGroupRequest.Builder().apply(block).build())

/**
 * Disassociates an attribute group from an application to remove the extra attributes contained in the attribute group from the application's metadata. This operation reverts `AssociateAttributeGroup`.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.disassociateAttributeGroup(crossinline block: DisassociateAttributeGroupRequest.Builder.() -> Unit): DisassociateAttributeGroupResponse = disassociateAttributeGroup(DisassociateAttributeGroupRequest.Builder().apply(block).build())

/**
 * Disassociates a resource from application. Both the resource and the application can be specified either by ID or name.
 *
 * **Minimum permissions**
 *
 *  You must have the following permissions to remove a resource that's been associated with an application using the `APPLY_APPLICATION_TAG` option for [AssociateResource](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_app-registry_AssociateResource.html).
 * + `tag:GetResources`
 * + `tag:UntagResources`
 *
 *  You must also have the following permissions if you don't use the `AWSServiceCatalogAppRegistryFullAccess` policy. For more information, see [AWSServiceCatalogAppRegistryFullAccess](https://docs.aws.amazon.com/servicecatalog/latest/arguide/full.html) in the AppRegistry Administrator Guide.
 * + `resource-groups:DisassociateResource`
 * + `cloudformation:UpdateStack`
 * + `cloudformation:DescribeStacks`
 *
 *  In addition, you must have the tagging permission defined by the Amazon Web Services service that creates the resource. For more information, see [UntagResources](https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_UntTagResources.html) in the *Resource Groups Tagging API Reference*.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.disassociateResource(crossinline block: DisassociateResourceRequest.Builder.() -> Unit): DisassociateResourceResponse = disassociateResource(DisassociateResourceRequest.Builder().apply(block).build())

/**
 * Retrieves metadata information about one of your applications. The application can be specified by its ARN, ID, or name (which is unique within one account in one region at a given point in time). Specify by ARN or ID in automated workflows if you want to make sure that the exact same application is returned or a `ResourceNotFoundException` is thrown, avoiding the ABA addressing problem.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.getApplication(crossinline block: GetApplicationRequest.Builder.() -> Unit): GetApplicationResponse = getApplication(GetApplicationRequest.Builder().apply(block).build())

/**
 * Gets the resource associated with the application.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.getAssociatedResource(crossinline block: GetAssociatedResourceRequest.Builder.() -> Unit): GetAssociatedResourceResponse = getAssociatedResource(GetAssociatedResourceRequest.Builder().apply(block).build())

/**
 * Retrieves an attribute group by its ARN, ID, or name. The attribute group can be specified by its ARN, ID, or name.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.getAttributeGroup(crossinline block: GetAttributeGroupRequest.Builder.() -> Unit): GetAttributeGroupResponse = getAttributeGroup(GetAttributeGroupRequest.Builder().apply(block).build())

/**
 * Retrieves a `TagKey` configuration from an account.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.getConfiguration(crossinline block: GetConfigurationRequest.Builder.() -> Unit): GetConfigurationResponse = getConfiguration(GetConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves a list of all of your applications. Results are paginated.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Lists all attribute groups that are associated with specified application. Results are paginated.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.listAssociatedAttributeGroups(crossinline block: ListAssociatedAttributeGroupsRequest.Builder.() -> Unit): ListAssociatedAttributeGroupsResponse = listAssociatedAttributeGroups(ListAssociatedAttributeGroupsRequest.Builder().apply(block).build())

/**
 * Lists all of the resources that are associated with the specified application. Results are paginated.
 *
 *  If you share an application, and a consumer account associates a tag query to the application, all of the users who can access the application can also view the tag values in all accounts that are associated with it using this API.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.listAssociatedResources(crossinline block: ListAssociatedResourcesRequest.Builder.() -> Unit): ListAssociatedResourcesResponse = listAssociatedResources(ListAssociatedResourcesRequest.Builder().apply(block).build())

/**
 * Lists all attribute groups which you have access to. Results are paginated.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.listAttributeGroups(crossinline block: ListAttributeGroupsRequest.Builder.() -> Unit): ListAttributeGroupsResponse = listAttributeGroups(ListAttributeGroupsRequest.Builder().apply(block).build())

/**
 * Lists the details of all attribute groups associated with a specific application. The results display in pages.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.listAttributeGroupsForApplication(crossinline block: ListAttributeGroupsForApplicationRequest.Builder.() -> Unit): ListAttributeGroupsForApplicationResponse = listAttributeGroupsForApplication(ListAttributeGroupsForApplicationRequest.Builder().apply(block).build())

/**
 * Lists all of the tags on the resource.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Associates a `TagKey` configuration to an account.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.putConfiguration(crossinline block: PutConfigurationRequest.Builder.() -> Unit): PutConfigurationResponse = putConfiguration(PutConfigurationRequest.Builder().apply(block).build())

/**
 * Syncs the resource with current AppRegistry records.
 *
 * Specifically, the resource’s AppRegistry system tags sync with its associated application. We remove the resource's AppRegistry system tags if it does not associate with the application. The caller must have permissions to read and update the resource.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.syncResource(crossinline block: SyncResourceRequest.Builder.() -> Unit): SyncResourceResponse = syncResource(SyncResourceRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified resource.
 *
 * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the resource, this action updates its value.
 *
 * This operation returns an empty response if the call was successful.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from a resource.
 *
 * This operation returns an empty response if the call was successful.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing application with new attributes.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

/**
 * Updates an existing attribute group with new details.
 */
public suspend inline fun ServiceCatalogAppRegistryClient.updateAttributeGroup(crossinline block: UpdateAttributeGroupRequest.Builder.() -> Unit): UpdateAttributeGroupResponse = updateAttributeGroup(UpdateAttributeGroupRequest.Builder().apply(block).build())
