// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.model



/**
 * Parameters supported by the application.
 */
public class ParameterDefinition private constructor(builder: Builder) {
    /**
     * A regular expression that represents the patterns to allow for String types.
     */
    public val allowedPattern: kotlin.String? = builder.allowedPattern
    /**
     * An array containing the list of values allowed for the parameter.
     */
    public val allowedValues: List<String>? = builder.allowedValues
    /**
     * A string that explains a constraint when the constraint is violated. For example, without a constraint description, a parameter that has an allowed pattern of &#91;A-Za-z0-9&#93;+ displays the following error message when the user specifies an invalid value:
     *
     *  Malformed input-Parameter MyParameter must match pattern &#91;A-Za-z0-9&#93;+
     *
     * By adding a constraint description, such as "must contain only uppercase and lowercase letters and numbers," you can display the following customized error message:
     *
     *  Malformed input-Parameter MyParameter must contain only uppercase and lowercase letters and numbers.
     */
    public val constraintDescription: kotlin.String? = builder.constraintDescription
    /**
     * A value of the appropriate type for the template to use if no value is specified when a stack is created. If you define constraints for the parameter, you must specify a value that adheres to those constraints.
     */
    public val defaultValue: kotlin.String? = builder.defaultValue
    /**
     * A string of up to 4,000 characters that describes the parameter.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An integer value that determines the largest number of characters that you want to allow for String types.
     */
    public val maxLength: kotlin.Int? = builder.maxLength
    /**
     * A numeric value that determines the largest numeric value that you want to allow for Number types.
     */
    public val maxValue: kotlin.Int? = builder.maxValue
    /**
     * An integer value that determines the smallest number of characters that you want to allow for String types.
     */
    public val minLength: kotlin.Int? = builder.minLength
    /**
     * A numeric value that determines the smallest numeric value that you want to allow for Number types.
     */
    public val minValue: kotlin.Int? = builder.minValue
    /**
     * The name of the parameter.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Whether to mask the parameter value whenever anyone makes a call that describes the stack. If you set the value to true, the parameter value is masked with asterisks (*****).
     */
    public val noEcho: kotlin.Boolean? = builder.noEcho
    /**
     * A list of AWS SAM resources that use this parameter.
     */
    public val referencedByResources: List<String>? = builder.referencedByResources
    /**
     * The type of the parameter.
     *
     * Valid values: String | Number | List<Number> | CommaDelimitedList
     *
     *  String: A literal string.
     *
     * For example, users can specify "MyUserName".
     *
     *  Number: An integer or float. AWS CloudFormation validates the parameter value as a number. However, when you use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the parameter value becomes a string.
     *
     * For example, users might specify "8888".
     *
     *  List<Number>: An array of integers or floats that are separated by commas. AWS CloudFormation validates the parameter value as numbers. However, when you use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the parameter value becomes a list of strings.
     *
     * For example, users might specify "80,20", and then Ref results in &#91;"80","20"&#93;.
     *
     *  CommaDelimitedList: An array of literal strings that are separated by commas. The total number of strings should be one more than the total number of commas. Also, each member string is space-trimmed.
     *
     * For example, users might specify "test,dev,prod", and then Ref results in &#91;"test","dev","prod"&#93;.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.serverlessapplicationrepository.model.ParameterDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParameterDefinition(")
        append("allowedPattern=$allowedPattern,")
        append("allowedValues=$allowedValues,")
        append("constraintDescription=$constraintDescription,")
        append("defaultValue=$defaultValue,")
        append("description=$description,")
        append("maxLength=$maxLength,")
        append("maxValue=$maxValue,")
        append("minLength=$minLength,")
        append("minValue=$minValue,")
        append("name=$name,")
        append("noEcho=$noEcho,")
        append("referencedByResources=$referencedByResources,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedPattern?.hashCode() ?: 0
        result = 31 * result + (allowedValues?.hashCode() ?: 0)
        result = 31 * result + (constraintDescription?.hashCode() ?: 0)
        result = 31 * result + (defaultValue?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (maxLength ?: 0)
        result = 31 * result + (maxValue ?: 0)
        result = 31 * result + (minLength ?: 0)
        result = 31 * result + (minValue ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (noEcho?.hashCode() ?: 0)
        result = 31 * result + (referencedByResources?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParameterDefinition

        if (allowedPattern != other.allowedPattern) return false
        if (allowedValues != other.allowedValues) return false
        if (constraintDescription != other.constraintDescription) return false
        if (defaultValue != other.defaultValue) return false
        if (description != other.description) return false
        if (maxLength != other.maxLength) return false
        if (maxValue != other.maxValue) return false
        if (minLength != other.minLength) return false
        if (minValue != other.minValue) return false
        if (name != other.name) return false
        if (noEcho != other.noEcho) return false
        if (referencedByResources != other.referencedByResources) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.serverlessapplicationrepository.model.ParameterDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A regular expression that represents the patterns to allow for String types.
         */
        public var allowedPattern: kotlin.String? = null
        /**
         * An array containing the list of values allowed for the parameter.
         */
        public var allowedValues: List<String>? = null
        /**
         * A string that explains a constraint when the constraint is violated. For example, without a constraint description, a parameter that has an allowed pattern of &#91;A-Za-z0-9&#93;+ displays the following error message when the user specifies an invalid value:
         *
         *  Malformed input-Parameter MyParameter must match pattern &#91;A-Za-z0-9&#93;+
         *
         * By adding a constraint description, such as "must contain only uppercase and lowercase letters and numbers," you can display the following customized error message:
         *
         *  Malformed input-Parameter MyParameter must contain only uppercase and lowercase letters and numbers.
         */
        public var constraintDescription: kotlin.String? = null
        /**
         * A value of the appropriate type for the template to use if no value is specified when a stack is created. If you define constraints for the parameter, you must specify a value that adheres to those constraints.
         */
        public var defaultValue: kotlin.String? = null
        /**
         * A string of up to 4,000 characters that describes the parameter.
         */
        public var description: kotlin.String? = null
        /**
         * An integer value that determines the largest number of characters that you want to allow for String types.
         */
        public var maxLength: kotlin.Int? = null
        /**
         * A numeric value that determines the largest numeric value that you want to allow for Number types.
         */
        public var maxValue: kotlin.Int? = null
        /**
         * An integer value that determines the smallest number of characters that you want to allow for String types.
         */
        public var minLength: kotlin.Int? = null
        /**
         * A numeric value that determines the smallest numeric value that you want to allow for Number types.
         */
        public var minValue: kotlin.Int? = null
        /**
         * The name of the parameter.
         */
        public var name: kotlin.String? = null
        /**
         * Whether to mask the parameter value whenever anyone makes a call that describes the stack. If you set the value to true, the parameter value is masked with asterisks (*****).
         */
        public var noEcho: kotlin.Boolean? = null
        /**
         * A list of AWS SAM resources that use this parameter.
         */
        public var referencedByResources: List<String>? = null
        /**
         * The type of the parameter.
         *
         * Valid values: String | Number | List<Number> | CommaDelimitedList
         *
         *  String: A literal string.
         *
         * For example, users can specify "MyUserName".
         *
         *  Number: An integer or float. AWS CloudFormation validates the parameter value as a number. However, when you use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the parameter value becomes a string.
         *
         * For example, users might specify "8888".
         *
         *  List<Number>: An array of integers or floats that are separated by commas. AWS CloudFormation validates the parameter value as numbers. However, when you use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the parameter value becomes a list of strings.
         *
         * For example, users might specify "80,20", and then Ref results in &#91;"80","20"&#93;.
         *
         *  CommaDelimitedList: An array of literal strings that are separated by commas. The total number of strings should be one more than the total number of commas. Also, each member string is space-trimmed.
         *
         * For example, users might specify "test,dev,prod", and then Ref results in &#91;"test","dev","prod"&#93;.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.serverlessapplicationrepository.model.ParameterDefinition) : this() {
            this.allowedPattern = x.allowedPattern
            this.allowedValues = x.allowedValues
            this.constraintDescription = x.constraintDescription
            this.defaultValue = x.defaultValue
            this.description = x.description
            this.maxLength = x.maxLength
            this.maxValue = x.maxValue
            this.minLength = x.minLength
            this.minValue = x.minValue
            this.name = x.name
            this.noEcho = x.noEcho
            this.referencedByResources = x.referencedByResources
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.serverlessapplicationrepository.model.ParameterDefinition = ParameterDefinition(this)
    }
}
