// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.transform

import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryException
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.UpdateApplicationResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.Version
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UpdateApplicationOperationDeserializer: HttpDeserialize<UpdateApplicationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateApplicationResponse {
        if (!response.status.isSuccess()) {
            throwUpdateApplicationError(context, response)
        }
        val builder = UpdateApplicationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateApplicationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateApplicationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServerlessApplicationRepositoryException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServerlessApplicationRepositoryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateApplicationOperationBody(builder: UpdateApplicationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationId"))
    val AUTHOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("author"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("creationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val HOMEPAGEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("homePageUrl"))
    val ISVERIFIEDAUTHOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isVerifiedAuthor"))
    val LABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("labels"))
    val LICENSEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("licenseUrl"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val READMEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("readmeUrl"))
    val SPDXLICENSEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("spdxLicenseId"))
    val VERIFIEDAUTHORURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("verifiedAuthorUrl"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONID_DESCRIPTOR)
        field(AUTHOR_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(HOMEPAGEURL_DESCRIPTOR)
        field(ISVERIFIEDAUTHOR_DESCRIPTOR)
        field(LABELS_DESCRIPTOR)
        field(LICENSEURL_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(READMEURL_DESCRIPTOR)
        field(SPDXLICENSEID_DESCRIPTOR)
        field(VERIFIEDAUTHORURL_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                AUTHOR_DESCRIPTOR.index -> builder.author = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                HOMEPAGEURL_DESCRIPTOR.index -> builder.homePageUrl = deserializeString()
                ISVERIFIEDAUTHOR_DESCRIPTOR.index -> builder.isVerifiedAuthor = deserializeBoolean()
                LABELS_DESCRIPTOR.index -> builder.labels =
                    deserializer.deserializeList(LABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LICENSEURL_DESCRIPTOR.index -> builder.licenseUrl = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                READMEURL_DESCRIPTOR.index -> builder.readmeUrl = deserializeString()
                SPDXLICENSEID_DESCRIPTOR.index -> builder.spdxLicenseId = deserializeString()
                VERIFIEDAUTHORURL_DESCRIPTOR.index -> builder.verifiedAuthorUrl = deserializeString()
                VERSION_DESCRIPTOR.index -> builder.version = deserializeVersionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
