// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.transform

import aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryException
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.Status
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCloudFormationTemplateOperationDeserializer: HttpDeserialize<CreateCloudFormationTemplateResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateCloudFormationTemplateResponse {
        if (!response.status.isSuccess()) {
            throwCreateCloudFormationTemplateError(context, response)
        }
        val builder = CreateCloudFormationTemplateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateCloudFormationTemplateOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateCloudFormationTemplateError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServerlessApplicationRepositoryException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServerlessApplicationRepositoryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCloudFormationTemplateOperationBody(builder: CreateCloudFormationTemplateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationId"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("creationTime"))
    val EXPIRATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("expirationTime"))
    val SEMANTICVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("semanticVersion"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TEMPLATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateId"))
    val TEMPLATEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateUrl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONID_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(EXPIRATIONTIME_DESCRIPTOR)
        field(SEMANTICVERSION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TEMPLATEID_DESCRIPTOR)
        field(TEMPLATEURL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString()
                EXPIRATIONTIME_DESCRIPTOR.index -> builder.expirationTime = deserializeString()
                SEMANTICVERSION_DESCRIPTOR.index -> builder.semanticVersion = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { Status.fromValue(it) }
                TEMPLATEID_DESCRIPTOR.index -> builder.templateId = deserializeString()
                TEMPLATEURL_DESCRIPTOR.index -> builder.templateUrl = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
