// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.serverlessapplicationrepository.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.serverlessapplicationrepository.endpoints.EndpointParameters
import aws.sdk.kotlin.services.serverlessapplicationrepository.endpoints.EndpointProvider
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateCloudFormationTemplateResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.GetApplicationPolicyRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.GetApplicationPolicyResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.GetApplicationRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.GetApplicationResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.GetCloudFormationTemplateRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.GetCloudFormationTemplateResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ListApplicationsRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ListApplicationsResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.PutApplicationPolicyRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.PutApplicationPolicyResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.UnshareApplicationRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.UnshareApplicationResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.UpdateApplicationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "ServerlessApplicationRepository"
public const val SdkVersion: String = "0.30.1-beta"

/**
 * The AWS Serverless Application Repository makes it easy for developers and enterprises to quickly find and deploy serverless applications in the AWS Cloud. For more information about serverless applications, see Serverless Computing and Applications on the AWS website.
 *
 * The AWS Serverless Application Repository is deeply integrated with the AWS Lambda console, so that developers of all levels can get started with serverless computing without needing to learn anything new. You can use category keywords to browse for applications such as web and mobile backends, data processing applications, or chatbots. You can also search for applications by name, publisher, or event source. To use an application, you simply choose it, configure any required fields, and deploy it with a few clicks.
 *
 * You can also easily publish applications, sharing them publicly with the community at large, or privately within your team or across your organization. To publish a serverless application (or app), you can use the AWS Management Console, AWS Command Line Interface (AWS CLI), or AWS SDKs to upload the code. Along with the code, you upload a simple manifest file, also known as the AWS Serverless Application Model (AWS SAM) template. For more information about AWS SAM, see AWS Serverless Application Model (AWS SAM) on the AWS Labs GitHub repository.
 *
 * The AWS Serverless Application Repository Developer Guide contains more information about the two developer experiences available:
 * + Consuming Applications – Browse for applications and view information about them, including source code and readme files. Also install, configure, and deploy applications of your choosing. Publishing Applications – Configure and upload applications to make them available to other developers, and publish new versions of applications.
 */
public interface ServerlessApplicationRepositoryClient : SdkClient {
    /**
     * ServerlessApplicationRepositoryClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ServerlessApplicationRepositoryClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ServerlessApplicationRepositoryClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ServerlessApplicationRepositoryClient = DefaultServerlessApplicationRepositoryClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "ServerlessApplicationRepository"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an application, optionally including an AWS SAM file to create the first application version in the same call.
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates an application version.
     */
    public suspend fun createApplicationVersion(input: CreateApplicationVersionRequest): CreateApplicationVersionResponse

    /**
     * Creates an AWS CloudFormation change set for the given application.
     */
    public suspend fun createCloudFormationChangeSet(input: CreateCloudFormationChangeSetRequest): CreateCloudFormationChangeSetResponse

    /**
     * Creates an AWS CloudFormation template.
     */
    public suspend fun createCloudFormationTemplate(input: CreateCloudFormationTemplateRequest): CreateCloudFormationTemplateResponse

    /**
     * Deletes the specified application.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Gets the specified application.
     */
    public suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse

    /**
     * Retrieves the policy for the application.
     */
    public suspend fun getApplicationPolicy(input: GetApplicationPolicyRequest): GetApplicationPolicyResponse

    /**
     * Gets the specified AWS CloudFormation template.
     */
    public suspend fun getCloudFormationTemplate(input: GetCloudFormationTemplateRequest): GetCloudFormationTemplateResponse

    /**
     * Retrieves the list of applications nested in the containing application.
     */
    public suspend fun listApplicationDependencies(input: ListApplicationDependenciesRequest): ListApplicationDependenciesResponse

    /**
     * Lists versions for the specified application.
     */
    public suspend fun listApplicationVersions(input: ListApplicationVersionsRequest): ListApplicationVersionsResponse

    /**
     * Lists applications owned by the requester.
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest {}): ListApplicationsResponse

    /**
     * Sets the permission policy for an application. For the list of actions supported for this operation, see [Application Permissions](https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions) .
     */
    public suspend fun putApplicationPolicy(input: PutApplicationPolicyRequest): PutApplicationPolicyResponse

    /**
     * Unshares an application from an AWS Organization.
     *
     * This operation can be called only from the organization's master account.
     */
    public suspend fun unshareApplication(input: UnshareApplicationRequest): UnshareApplicationResponse

    /**
     * Updates the specified application.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ServerlessApplicationRepositoryClient.withConfig(block: ServerlessApplicationRepositoryClient.Config.Builder.() -> Unit): ServerlessApplicationRepositoryClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultServerlessApplicationRepositoryClient(newConfig)
}

/**
 * Creates an application, optionally including an AWS SAM file to create the first application version in the same call.
 */
public suspend inline fun ServerlessApplicationRepositoryClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates an application version.
 */
public suspend inline fun ServerlessApplicationRepositoryClient.createApplicationVersion(crossinline block: CreateApplicationVersionRequest.Builder.() -> Unit): CreateApplicationVersionResponse = createApplicationVersion(CreateApplicationVersionRequest.Builder().apply(block).build())

/**
 * Creates an AWS CloudFormation change set for the given application.
 */
public suspend inline fun ServerlessApplicationRepositoryClient.createCloudFormationChangeSet(crossinline block: CreateCloudFormationChangeSetRequest.Builder.() -> Unit): CreateCloudFormationChangeSetResponse = createCloudFormationChangeSet(CreateCloudFormationChangeSetRequest.Builder().apply(block).build())

/**
 * Creates an AWS CloudFormation template.
 */
public suspend inline fun ServerlessApplicationRepositoryClient.createCloudFormationTemplate(crossinline block: CreateCloudFormationTemplateRequest.Builder.() -> Unit): CreateCloudFormationTemplateResponse = createCloudFormationTemplate(CreateCloudFormationTemplateRequest.Builder().apply(block).build())

/**
 * Deletes the specified application.
 */
public suspend inline fun ServerlessApplicationRepositoryClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Gets the specified application.
 */
public suspend inline fun ServerlessApplicationRepositoryClient.getApplication(crossinline block: GetApplicationRequest.Builder.() -> Unit): GetApplicationResponse = getApplication(GetApplicationRequest.Builder().apply(block).build())

/**
 * Retrieves the policy for the application.
 */
public suspend inline fun ServerlessApplicationRepositoryClient.getApplicationPolicy(crossinline block: GetApplicationPolicyRequest.Builder.() -> Unit): GetApplicationPolicyResponse = getApplicationPolicy(GetApplicationPolicyRequest.Builder().apply(block).build())

/**
 * Gets the specified AWS CloudFormation template.
 */
public suspend inline fun ServerlessApplicationRepositoryClient.getCloudFormationTemplate(crossinline block: GetCloudFormationTemplateRequest.Builder.() -> Unit): GetCloudFormationTemplateResponse = getCloudFormationTemplate(GetCloudFormationTemplateRequest.Builder().apply(block).build())

/**
 * Retrieves the list of applications nested in the containing application.
 */
public suspend inline fun ServerlessApplicationRepositoryClient.listApplicationDependencies(crossinline block: ListApplicationDependenciesRequest.Builder.() -> Unit): ListApplicationDependenciesResponse = listApplicationDependencies(ListApplicationDependenciesRequest.Builder().apply(block).build())

/**
 * Lists versions for the specified application.
 */
public suspend inline fun ServerlessApplicationRepositoryClient.listApplicationVersions(crossinline block: ListApplicationVersionsRequest.Builder.() -> Unit): ListApplicationVersionsResponse = listApplicationVersions(ListApplicationVersionsRequest.Builder().apply(block).build())

/**
 * Lists applications owned by the requester.
 */
public suspend inline fun ServerlessApplicationRepositoryClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Sets the permission policy for an application. For the list of actions supported for this operation, see [Application Permissions](https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions) .
 */
public suspend inline fun ServerlessApplicationRepositoryClient.putApplicationPolicy(crossinline block: PutApplicationPolicyRequest.Builder.() -> Unit): PutApplicationPolicyResponse = putApplicationPolicy(PutApplicationPolicyRequest.Builder().apply(block).build())

/**
 * Unshares an application from an AWS Organization.
 *
 * This operation can be called only from the organization's master account.
 */
public suspend inline fun ServerlessApplicationRepositoryClient.unshareApplication(crossinline block: UnshareApplicationRequest.Builder.() -> Unit): UnshareApplicationResponse = unshareApplication(UnshareApplicationRequest.Builder().apply(block).build())

/**
 * Updates the specified application.
 */
public suspend inline fun ServerlessApplicationRepositoryClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())
