// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.transform

import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ApplicationPolicyStatement
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.PutApplicationPolicyResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class PutApplicationPolicyOperationDeserializer: HttpDeserialize<PutApplicationPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutApplicationPolicyResponse {
        if (!response.status.isSuccess()) {
            throwPutApplicationPolicyError(context, response)
        }
        val builder = PutApplicationPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutApplicationPolicyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutApplicationPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServerlessApplicationRepositoryException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServerlessApplicationRepositoryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutApplicationPolicyOperationBody(builder: PutApplicationPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val STATEMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("statements"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(STATEMENTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                STATEMENTS_DESCRIPTOR.index -> builder.statements =
                    deserializer.deserializeList(STATEMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ApplicationPolicyStatement>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeApplicationPolicyStatementDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
