// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.transform

import aws.sdk.kotlin.services.serverlessapplicationrepository.model.Capability
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ParameterDefinition
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateApplicationVersionOperationDeserializer: HttpDeserialize<CreateApplicationVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateApplicationVersionResponse {
        if (!response.status.isSuccess()) {
            throwCreateApplicationVersionError(context, response)
        }
        val builder = CreateApplicationVersionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateApplicationVersionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateApplicationVersionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ServerlessApplicationRepositoryException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ServerlessApplicationRepositoryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateApplicationVersionOperationBody(builder: CreateApplicationVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationId"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("creationTime"))
    val PARAMETERDEFINITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("parameterDefinitions"))
    val REQUIREDCAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("requiredCapabilities"))
    val RESOURCESSUPPORTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("resourcesSupported"))
    val SEMANTICVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("semanticVersion"))
    val SOURCECODEARCHIVEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceCodeArchiveUrl"))
    val SOURCECODEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceCodeUrl"))
    val TEMPLATEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateUrl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONID_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(PARAMETERDEFINITIONS_DESCRIPTOR)
        field(REQUIREDCAPABILITIES_DESCRIPTOR)
        field(RESOURCESSUPPORTED_DESCRIPTOR)
        field(SEMANTICVERSION_DESCRIPTOR)
        field(SOURCECODEARCHIVEURL_DESCRIPTOR)
        field(SOURCECODEURL_DESCRIPTOR)
        field(TEMPLATEURL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString()
                PARAMETERDEFINITIONS_DESCRIPTOR.index -> builder.parameterDefinitions =
                    deserializer.deserializeList(PARAMETERDEFINITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ParameterDefinition>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeParameterDefinitionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REQUIREDCAPABILITIES_DESCRIPTOR.index -> builder.requiredCapabilities =
                    deserializer.deserializeList(REQUIREDCAPABILITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<Capability>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { Capability.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESOURCESSUPPORTED_DESCRIPTOR.index -> builder.resourcesSupported = deserializeBoolean()
                SEMANTICVERSION_DESCRIPTOR.index -> builder.semanticVersion = deserializeString()
                SOURCECODEARCHIVEURL_DESCRIPTOR.index -> builder.sourceCodeArchiveUrl = deserializeString()
                SOURCECODEURL_DESCRIPTOR.index -> builder.sourceCodeUrl = deserializeString()
                TEMPLATEURL_DESCRIPTOR.index -> builder.templateUrl = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
