// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.model



/**
 * Application version details.
 */
public class Version private constructor(builder: Builder) {
    /**
     * The application Amazon Resource Name (ARN).
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The date and time this resource was created.
     */
    public val creationTime: kotlin.String? = builder.creationTime
    /**
     * An array of parameter types supported by the application.
     */
    public val parameterDefinitions: List<ParameterDefinition>? = builder.parameterDefinitions
    /**
     * A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.
     *
     * The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.
     *
     * The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html), [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html), [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html), and [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html). If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.
     *
     * The following resources require you to specify CAPABILITY_RESOURCE_POLICY: [AWS::Lambda::Permission](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html), [AWS::IAM:Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html), [AWS::ApplicationAutoScaling::ScalingPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html), [AWS::S3::BucketPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html), [AWS::SQS::QueuePolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html), and [AWS::SNS::TopicPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html).
     *
     * Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
     *
     * If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.
     */
    public val requiredCapabilities: List<Capability>? = builder.requiredCapabilities
    /**
     * Whether all of the AWS resources contained in this application are supported in the region in which it is being retrieved.
     */
    public val resourcesSupported: kotlin.Boolean? = builder.resourcesSupported
    /**
     * The semantic version of the application:
     *
     * [https://semver.org/](https://semver.org/)
     */
    public val semanticVersion: kotlin.String? = builder.semanticVersion
    /**
     * A link to the S3 object that contains the ZIP archive of the source code for this version of your application.
     *
     * Maximum size 50 MB
     */
    public val sourceCodeArchiveUrl: kotlin.String? = builder.sourceCodeArchiveUrl
    /**
     * A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.
     */
    public val sourceCodeUrl: kotlin.String? = builder.sourceCodeUrl
    /**
     * A link to the packaged AWS SAM template of your application.
     */
    public val templateUrl: kotlin.String? = builder.templateUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.serverlessapplicationrepository.model.Version = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Version(")
        append("applicationId=$applicationId,")
        append("creationTime=$creationTime,")
        append("parameterDefinitions=$parameterDefinitions,")
        append("requiredCapabilities=$requiredCapabilities,")
        append("resourcesSupported=$resourcesSupported,")
        append("semanticVersion=$semanticVersion,")
        append("sourceCodeArchiveUrl=$sourceCodeArchiveUrl,")
        append("sourceCodeUrl=$sourceCodeUrl,")
        append("templateUrl=$templateUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (parameterDefinitions?.hashCode() ?: 0)
        result = 31 * result + (requiredCapabilities?.hashCode() ?: 0)
        result = 31 * result + (resourcesSupported?.hashCode() ?: 0)
        result = 31 * result + (semanticVersion?.hashCode() ?: 0)
        result = 31 * result + (sourceCodeArchiveUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceCodeUrl?.hashCode() ?: 0)
        result = 31 * result + (templateUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Version

        if (applicationId != other.applicationId) return false
        if (creationTime != other.creationTime) return false
        if (parameterDefinitions != other.parameterDefinitions) return false
        if (requiredCapabilities != other.requiredCapabilities) return false
        if (resourcesSupported != other.resourcesSupported) return false
        if (semanticVersion != other.semanticVersion) return false
        if (sourceCodeArchiveUrl != other.sourceCodeArchiveUrl) return false
        if (sourceCodeUrl != other.sourceCodeUrl) return false
        if (templateUrl != other.templateUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.serverlessapplicationrepository.model.Version = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The application Amazon Resource Name (ARN).
         */
        public var applicationId: kotlin.String? = null
        /**
         * The date and time this resource was created.
         */
        public var creationTime: kotlin.String? = null
        /**
         * An array of parameter types supported by the application.
         */
        public var parameterDefinitions: List<ParameterDefinition>? = null
        /**
         * A list of values that you must specify before you can deploy certain applications. Some applications might include resources that can affect permissions in your AWS account, for example, by creating new AWS Identity and Access Management (IAM) users. For those applications, you must explicitly acknowledge their capabilities by specifying this parameter.
         *
         * The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM, CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.
         *
         * The following resources require you to specify CAPABILITY_IAM or CAPABILITY_NAMED_IAM: [AWS::IAM::Group](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html), [AWS::IAM::InstanceProfile](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html), [AWS::IAM::Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html), and [AWS::IAM::Role](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html). If the application contains IAM resources, you can specify either CAPABILITY_IAM or CAPABILITY_NAMED_IAM. If the application contains IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.
         *
         * The following resources require you to specify CAPABILITY_RESOURCE_POLICY: [AWS::Lambda::Permission](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html), [AWS::IAM:Policy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html), [AWS::ApplicationAutoScaling::ScalingPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html), [AWS::S3::BucketPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html), [AWS::SQS::QueuePolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html), and [AWS::SNS::TopicPolicy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html).
         *
         * Applications that contain one or more nested applications require you to specify CAPABILITY_AUTO_EXPAND.
         *
         * If your application template contains any of the above resources, we recommend that you review all permissions associated with the application before deploying. If you don't specify this parameter for an application that requires capabilities, the call will fail.
         */
        public var requiredCapabilities: List<Capability>? = null
        /**
         * Whether all of the AWS resources contained in this application are supported in the region in which it is being retrieved.
         */
        public var resourcesSupported: kotlin.Boolean? = null
        /**
         * The semantic version of the application:
         *
         * [https://semver.org/](https://semver.org/)
         */
        public var semanticVersion: kotlin.String? = null
        /**
         * A link to the S3 object that contains the ZIP archive of the source code for this version of your application.
         *
         * Maximum size 50 MB
         */
        public var sourceCodeArchiveUrl: kotlin.String? = null
        /**
         * A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.
         */
        public var sourceCodeUrl: kotlin.String? = null
        /**
         * A link to the packaged AWS SAM template of your application.
         */
        public var templateUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.serverlessapplicationrepository.model.Version) : this() {
            this.applicationId = x.applicationId
            this.creationTime = x.creationTime
            this.parameterDefinitions = x.parameterDefinitions
            this.requiredCapabilities = x.requiredCapabilities
            this.resourcesSupported = x.resourcesSupported
            this.semanticVersion = x.semanticVersion
            this.sourceCodeArchiveUrl = x.sourceCodeArchiveUrl
            this.sourceCodeUrl = x.sourceCodeUrl
            this.templateUrl = x.templateUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.serverlessapplicationrepository.model.Version = Version(this)
    }
}
