// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.transform

import aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateApplicationVersionOperationSerializer: HttpSerialize<CreateApplicationVersionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateApplicationVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "applications",
                "${input.applicationId}".encodeLabel(),
                "versions",
                "${input.semanticVersion}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateApplicationVersionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateApplicationVersionOperationBody(context: ExecutionContext, input: CreateApplicationVersionRequest): ByteArray {
    val serializer = JsonSerializer()
    val SOURCECODEARCHIVEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceCodeArchiveUrl"))
    val SOURCECODEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceCodeUrl"))
    val TEMPLATEBODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateBody"))
    val TEMPLATEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateUrl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SOURCECODEARCHIVEURL_DESCRIPTOR)
        field(SOURCECODEURL_DESCRIPTOR)
        field(TEMPLATEBODY_DESCRIPTOR)
        field(TEMPLATEURL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.sourceCodeArchiveUrl?.let { field(SOURCECODEARCHIVEURL_DESCRIPTOR, it) }
        input.sourceCodeUrl?.let { field(SOURCECODEURL_DESCRIPTOR, it) }
        input.templateBody?.let { field(TEMPLATEBODY_DESCRIPTOR, it) }
        input.templateUrl?.let { field(TEMPLATEURL_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
