// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.internal

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.endpoint.AwsEndpoint
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.endpoint.CredentialScope
import aws.sdk.kotlin.runtime.endpoint.internal.EndpointDefinition
import aws.sdk.kotlin.runtime.endpoint.internal.Partition
import aws.sdk.kotlin.runtime.endpoint.internal.resolveEndpoint

internal class DefaultEndpointResolver : AwsEndpointResolver {
    override suspend fun resolve(service: String, region: String): AwsEndpoint {
        return resolveEndpoint(servicePartitions, region) ?: throw ClientException("unable to resolve endpoint for region: $region")
    }
}

private val servicePartitions = listOf(
    Partition(
        id = "aws",
        regionRegex = Regex("^(us|eu|ap|sa|ca|me|af)\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "serverlessrepo.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "ap-east-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "ap-northeast-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "ap-northeast-2" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "ap-south-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "ap-southeast-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "ap-southeast-2" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "ca-central-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "eu-central-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "eu-north-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "eu-west-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "eu-west-2" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "eu-west-3" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "me-south-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "sa-east-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "us-east-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "us-east-2" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "us-west-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "us-west-2" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
        )
    ),
    Partition(
        id = "aws-cn",
        regionRegex = Regex("^cn\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "serverlessrepo.{region}.amazonaws.com.cn",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "cn-north-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
            "cn-northwest-1" to EndpointDefinition(
                protocols = listOf("https", ),
            ),
        )
    ),
    Partition(
        id = "aws-iso",
        regionRegex = Regex("^us\\-iso\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "serverlessrepo.{region}.c2s.ic.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-iso-b",
        regionRegex = Regex("^us\\-isob\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "serverlessrepo.{region}.sc2s.sgov.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-us-gov",
        regionRegex = Regex("^us\\-gov\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "serverlessrepo.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "us-gov-east-1" to EndpointDefinition(
                hostname = "serverlessrepo.us-gov-east-1.amazonaws.com",
                protocols = listOf("https", ),
                credentialScope = CredentialScope(region = "us-gov-east-1",),
            ),
            "us-gov-west-1" to EndpointDefinition(
                hostname = "serverlessrepo.us-gov-west-1.amazonaws.com",
                protocols = listOf("https", ),
                credentialScope = CredentialScope(region = "us-gov-west-1",),
            ),
        )
    ),
)
