// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.serverlessapplicationrepository.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * The AWS Serverless Application Repository makes it easy for developers and enterprises to quickly find and deploy serverless applications in the AWS Cloud. For more information about serverless applications, see Serverless Computing and Applications on the AWS website.
 *
 * The AWS Serverless Application Repository is deeply integrated with the AWS Lambda console, so that developers of all levels can get started with serverless computing without needing to learn anything new. You can use category keywords to browse for applications such as web and mobile backends, data processing applications, or chatbots. You can also search for applications by name, publisher, or event source. To use an application, you simply choose it, configure any required fields, and deploy it with a few clicks.
 *
 * You can also easily publish applications, sharing them publicly with the community at large, or privately within your team or across your organization. To publish a serverless application (or app), you can use the AWS Management Console, AWS Command Line Interface (AWS CLI), or AWS SDKs to upload the code. Along with the code, you upload a simple manifest file, also known as the AWS Serverless Application Model (AWS SAM) template. For more information about AWS SAM, see AWS Serverless Application Model (AWS SAM) on the AWS Labs GitHub repository.
 *
 * The AWS Serverless Application Repository Developer Guide contains more information about the two developer experiences available:
 * + Consuming Applications – Browse for applications and view information about them, including source code and readme files. Also install, configure, and deploy applications of your choosing. Publishing Applications – Configure and upload applications to make them available to other developers, and publish new versions of applications.
 */
interface ServerlessApplicationRepositoryClient : SdkClient {

    override val serviceName: String
        get() = "ServerlessApplicationRepository"
    /**
     * ServerlessApplicationRepositoryClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): ServerlessApplicationRepositoryClient {
            val config = Config.Builder().apply(block).build()
            return DefaultServerlessApplicationRepositoryClient(config)
        }

        operator fun invoke(config: Config): ServerlessApplicationRepositoryClient = DefaultServerlessApplicationRepositoryClient(config)

        /**
         * Construct a [ServerlessApplicationRepositoryClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ServerlessApplicationRepositoryClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultServerlessApplicationRepositoryClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an application, optionally including an AWS SAM file to create the first application version in the same call.
     */
    suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates an application, optionally including an AWS SAM file to create the first application version in the same call.
     */
    suspend fun createApplication(block: CreateApplicationRequest.Builder.() -> Unit) = createApplication(CreateApplicationRequest.Builder().apply(block).build())

    /**
     * Creates an application version.
     */
    suspend fun createApplicationVersion(input: CreateApplicationVersionRequest): CreateApplicationVersionResponse

    /**
     * Creates an application version.
     */
    suspend fun createApplicationVersion(block: CreateApplicationVersionRequest.Builder.() -> Unit) = createApplicationVersion(CreateApplicationVersionRequest.Builder().apply(block).build())

    /**
     * Creates an AWS CloudFormation change set for the given application.
     */
    suspend fun createCloudFormationChangeSet(input: CreateCloudFormationChangeSetRequest): CreateCloudFormationChangeSetResponse

    /**
     * Creates an AWS CloudFormation change set for the given application.
     */
    suspend fun createCloudFormationChangeSet(block: CreateCloudFormationChangeSetRequest.Builder.() -> Unit) = createCloudFormationChangeSet(CreateCloudFormationChangeSetRequest.Builder().apply(block).build())

    /**
     * Creates an AWS CloudFormation template.
     */
    suspend fun createCloudFormationTemplate(input: CreateCloudFormationTemplateRequest): CreateCloudFormationTemplateResponse

    /**
     * Creates an AWS CloudFormation template.
     */
    suspend fun createCloudFormationTemplate(block: CreateCloudFormationTemplateRequest.Builder.() -> Unit) = createCloudFormationTemplate(CreateCloudFormationTemplateRequest.Builder().apply(block).build())

    /**
     * Deletes the specified application.
     */
    suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes the specified application.
     */
    suspend fun deleteApplication(block: DeleteApplicationRequest.Builder.() -> Unit) = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

    /**
     * Gets the specified application.
     */
    suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse

    /**
     * Gets the specified application.
     */
    suspend fun getApplication(block: GetApplicationRequest.Builder.() -> Unit) = getApplication(GetApplicationRequest.Builder().apply(block).build())

    /**
     * Retrieves the policy for the application.
     */
    suspend fun getApplicationPolicy(input: GetApplicationPolicyRequest): GetApplicationPolicyResponse

    /**
     * Retrieves the policy for the application.
     */
    suspend fun getApplicationPolicy(block: GetApplicationPolicyRequest.Builder.() -> Unit) = getApplicationPolicy(GetApplicationPolicyRequest.Builder().apply(block).build())

    /**
     * Gets the specified AWS CloudFormation template.
     */
    suspend fun getCloudFormationTemplate(input: GetCloudFormationTemplateRequest): GetCloudFormationTemplateResponse

    /**
     * Gets the specified AWS CloudFormation template.
     */
    suspend fun getCloudFormationTemplate(block: GetCloudFormationTemplateRequest.Builder.() -> Unit) = getCloudFormationTemplate(GetCloudFormationTemplateRequest.Builder().apply(block).build())

    /**
     * Retrieves the list of applications nested in the containing application.
     */
    suspend fun listApplicationDependencies(input: ListApplicationDependenciesRequest): ListApplicationDependenciesResponse

    /**
     * Retrieves the list of applications nested in the containing application.
     */
    suspend fun listApplicationDependencies(block: ListApplicationDependenciesRequest.Builder.() -> Unit) = listApplicationDependencies(ListApplicationDependenciesRequest.Builder().apply(block).build())

    /**
     * Lists versions for the specified application.
     */
    suspend fun listApplicationVersions(input: ListApplicationVersionsRequest): ListApplicationVersionsResponse

    /**
     * Lists versions for the specified application.
     */
    suspend fun listApplicationVersions(block: ListApplicationVersionsRequest.Builder.() -> Unit) = listApplicationVersions(ListApplicationVersionsRequest.Builder().apply(block).build())

    /**
     * Lists applications owned by the requester.
     */
    suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest {}): ListApplicationsResponse

    /**
     * Lists applications owned by the requester.
     */
    suspend fun listApplications(block: ListApplicationsRequest.Builder.() -> Unit) = listApplications(ListApplicationsRequest.Builder().apply(block).build())

    /**
     * Sets the permission policy for an application. For the list of actions supported for this operation, see [Application Permissions](https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions) .
     */
    suspend fun putApplicationPolicy(input: PutApplicationPolicyRequest): PutApplicationPolicyResponse

    /**
     * Sets the permission policy for an application. For the list of actions supported for this operation, see [Application Permissions](https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions) .
     */
    suspend fun putApplicationPolicy(block: PutApplicationPolicyRequest.Builder.() -> Unit) = putApplicationPolicy(PutApplicationPolicyRequest.Builder().apply(block).build())

    /**
     * Unshares an application from an AWS Organization.
     *
     * This operation can be called only from the organization's master account.
     */
    suspend fun unshareApplication(input: UnshareApplicationRequest): UnshareApplicationResponse

    /**
     * Unshares an application from an AWS Organization.
     *
     * This operation can be called only from the organization's master account.
     */
    suspend fun unshareApplication(block: UnshareApplicationRequest.Builder.() -> Unit) = unshareApplication(UnshareApplicationRequest.Builder().apply(block).build())

    /**
     * Updates the specified application.
     */
    suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates the specified application.
     */
    suspend fun updateApplication(block: UpdateApplicationRequest.Builder.() -> Unit) = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())
}
