// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.transform

import aws.sdk.kotlin.services.serverlessapplicationrepository.model.UpdateApplicationRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateApplicationOperationSerializer: HttpSerialize<UpdateApplicationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateApplicationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf(
                "applications",
                "${input.applicationId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateApplicationOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeUpdateApplicationOperationBody(context: ExecutionContext, input: UpdateApplicationRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("author"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val HOMEPAGEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("homePageUrl"))
    val LABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("labels"))
    val READMEBODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("readmeBody"))
    val READMEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("readmeUrl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHOR_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(HOMEPAGEURL_DESCRIPTOR)
        field(LABELS_DESCRIPTOR)
        field(READMEBODY_DESCRIPTOR)
        field(READMEURL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.author?.let { field(AUTHOR_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.homePageUrl?.let { field(HOMEPAGEURL_DESCRIPTOR, it) }
        if (input.labels != null) {
            listField(LABELS_DESCRIPTOR) {
                for (el0 in input.labels) {
                    serializeString(el0)
                }
            }
        }
        input.readmeBody?.let { field(READMEBODY_DESCRIPTOR, it) }
        input.readmeUrl?.let { field(READMEURL_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
