// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.transform

import aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ParameterValue
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.RollbackConfiguration
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCloudFormationChangeSetOperationSerializer: HttpSerialize<CreateCloudFormationChangeSetRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateCloudFormationChangeSetRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "applications",
                "${input.applicationId}".encodeLabel(),
                "changesets",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateCloudFormationChangeSetOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/json")
        return builder
    }
}

private fun serializeCreateCloudFormationChangeSetOperationBody(context: ExecutionContext, input: CreateCloudFormationChangeSetRequest): ByteArray {
    val serializer = JsonSerializer()
    val CAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("capabilities"))
    val CHANGESETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("changeSetName"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val NOTIFICATIONARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("notificationArns"))
    val PARAMETEROVERRIDES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("parameterOverrides"))
    val RESOURCETYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("resourceTypes"))
    val ROLLBACKCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("rollbackConfiguration"))
    val SEMANTICVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("semanticVersion"))
    val STACKNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stackName"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val TEMPLATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPABILITIES_DESCRIPTOR)
        field(CHANGESETNAME_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(NOTIFICATIONARNS_DESCRIPTOR)
        field(PARAMETEROVERRIDES_DESCRIPTOR)
        field(RESOURCETYPES_DESCRIPTOR)
        field(ROLLBACKCONFIGURATION_DESCRIPTOR)
        field(SEMANTICVERSION_DESCRIPTOR)
        field(STACKNAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TEMPLATEID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.capabilities != null) {
            listField(CAPABILITIES_DESCRIPTOR) {
                for (el0 in input.capabilities) {
                    serializeString(el0)
                }
            }
        }
        input.changeSetName?.let { field(CHANGESETNAME_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.notificationArns != null) {
            listField(NOTIFICATIONARNS_DESCRIPTOR) {
                for (el0 in input.notificationArns) {
                    serializeString(el0)
                }
            }
        }
        if (input.parameterOverrides != null) {
            listField(PARAMETEROVERRIDES_DESCRIPTOR) {
                for (el0 in input.parameterOverrides) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeParameterValueDocument))
                }
            }
        }
        if (input.resourceTypes != null) {
            listField(RESOURCETYPES_DESCRIPTOR) {
                for (el0 in input.resourceTypes) {
                    serializeString(el0)
                }
            }
        }
        input.rollbackConfiguration?.let { field(ROLLBACKCONFIGURATION_DESCRIPTOR, it, ::serializeRollbackConfigurationDocument) }
        input.semanticVersion?.let { field(SEMANTICVERSION_DESCRIPTOR, it) }
        input.stackName?.let { field(STACKNAME_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.templateId?.let { field(TEMPLATEID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
