// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.model



class CreateCloudFormationChangeSetRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the application.
     */
    val applicationId: kotlin.String? = builder.applicationId
    /**
     * A list of values that you must specify before you can deploy certain applications.
     * Some applications might include resources that can affect permissions in your AWS
     * account, for example, by creating new AWS Identity and Access Management (IAM) users.
     * For those applications, you must explicitly acknowledge their capabilities by
     * specifying this parameter.The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM,
     * CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.The following resources require you to specify CAPABILITY_IAM or
     * CAPABILITY_NAMED_IAM:
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group,
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile,
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy, and
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role.
     * If the application contains IAM resources, you can specify either CAPABILITY_IAM
     * or CAPABILITY_NAMED_IAM. If the application contains IAM resources
     * with custom names, you must specify CAPABILITY_NAMED_IAM.The following resources require you to specify CAPABILITY_RESOURCE_POLICY:
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission,
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy,
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy,
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy,
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy, and
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS:TopicPolicy.Applications that contain one or more nested applications require you to specify
     * CAPABILITY_AUTO_EXPAND.If your application template contains any of the above resources, we recommend that you review
     * all permissions associated with the application before deploying. If you don't specify
     * this parameter for an application that requires capabilities, the call will fail.
     */
    val capabilities: List<String>? = builder.capabilities
    /**
     * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
     * API.
     */
    val changeSetName: kotlin.String? = builder.changeSetName
    /**
     * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
     * API.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
     * API.
     */
    val description: kotlin.String? = builder.description
    /**
     * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
     * API.
     */
    val notificationArns: List<String>? = builder.notificationArns
    /**
     * A list of parameter values for the parameters of the application.
     */
    val parameterOverrides: List<ParameterValue>? = builder.parameterOverrides
    /**
     * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
     * API.
     */
    val resourceTypes: List<String>? = builder.resourceTypes
    /**
     * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
     * API.
     */
    val rollbackConfiguration: aws.sdk.kotlin.services.serverlessapplicationrepository.model.RollbackConfiguration? = builder.rollbackConfiguration
    /**
     * The semantic version of the application:
     * <a href="https://semver.org/">https://semver.org/
     */
    val semanticVersion: kotlin.String? = builder.semanticVersion
    /**
     * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
     * API.
     */
    val stackName: kotlin.String? = builder.stackName
    /**
     * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
     * API.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The UUID returned by CreateCloudFormationTemplate.Pattern: &#91;0-9a-fA-F&#93;{8}\-&#91;0-9a-fA-F&#93;{4}\-&#91;0-9a-fA-F&#93;{4}\-&#91;0-9a-fA-F&#93;{4}\-&#91;0-9a-fA-F&#93;{12}
     */
    val templateId: kotlin.String? = builder.templateId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCloudFormationChangeSetRequest(")
        append("applicationId=$applicationId,")
        append("capabilities=$capabilities,")
        append("changeSetName=$changeSetName,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("notificationArns=$notificationArns,")
        append("parameterOverrides=$parameterOverrides,")
        append("resourceTypes=$resourceTypes,")
        append("rollbackConfiguration=$rollbackConfiguration,")
        append("semanticVersion=$semanticVersion,")
        append("stackName=$stackName,")
        append("tags=$tags,")
        append("templateId=$templateId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (capabilities?.hashCode() ?: 0)
        result = 31 * result + (changeSetName?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (notificationArns?.hashCode() ?: 0)
        result = 31 * result + (parameterOverrides?.hashCode() ?: 0)
        result = 31 * result + (resourceTypes?.hashCode() ?: 0)
        result = 31 * result + (rollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (semanticVersion?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCloudFormationChangeSetRequest

        if (applicationId != other.applicationId) return false
        if (capabilities != other.capabilities) return false
        if (changeSetName != other.changeSetName) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (notificationArns != other.notificationArns) return false
        if (parameterOverrides != other.parameterOverrides) return false
        if (resourceTypes != other.resourceTypes) return false
        if (rollbackConfiguration != other.rollbackConfiguration) return false
        if (semanticVersion != other.semanticVersion) return false
        if (stackName != other.stackName) return false
        if (tags != other.tags) return false
        if (templateId != other.templateId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the application.
         */
        var applicationId: kotlin.String? = null
        /**
         * A list of values that you must specify before you can deploy certain applications.
         * Some applications might include resources that can affect permissions in your AWS
         * account, for example, by creating new AWS Identity and Access Management (IAM) users.
         * For those applications, you must explicitly acknowledge their capabilities by
         * specifying this parameter.The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM,
         * CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.The following resources require you to specify CAPABILITY_IAM or
         * CAPABILITY_NAMED_IAM:
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html">AWS::IAM::Group,
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html">AWS::IAM::InstanceProfile,
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM::Policy, and
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html">AWS::IAM::Role.
         * If the application contains IAM resources, you can specify either CAPABILITY_IAM
         * or CAPABILITY_NAMED_IAM. If the application contains IAM resources
         * with custom names, you must specify CAPABILITY_NAMED_IAM.The following resources require you to specify CAPABILITY_RESOURCE_POLICY:
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html">AWS::Lambda::Permission,
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-policy.html">AWS::IAM:Policy,
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html">AWS::ApplicationAutoScaling::ScalingPolicy,
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-policy.html">AWS::S3::BucketPolicy,
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html">AWS::SQS::QueuePolicy, and
         * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sns-policy.html">AWS::SNS:TopicPolicy.Applications that contain one or more nested applications require you to specify
         * CAPABILITY_AUTO_EXPAND.If your application template contains any of the above resources, we recommend that you review
         * all permissions associated with the application before deploying. If you don't specify
         * this parameter for an application that requires capabilities, the call will fail.
         */
        var capabilities: List<String>? = null
        /**
         * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
         * API.
         */
        var changeSetName: kotlin.String? = null
        /**
         * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
         * API.
         */
        var clientToken: kotlin.String? = null
        /**
         * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
         * API.
         */
        var description: kotlin.String? = null
        /**
         * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
         * API.
         */
        var notificationArns: List<String>? = null
        /**
         * A list of parameter values for the parameters of the application.
         */
        var parameterOverrides: List<ParameterValue>? = null
        /**
         * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
         * API.
         */
        var resourceTypes: List<String>? = null
        /**
         * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
         * API.
         */
        var rollbackConfiguration: aws.sdk.kotlin.services.serverlessapplicationrepository.model.RollbackConfiguration? = null
        /**
         * The semantic version of the application:
         * <a href="https://semver.org/">https://semver.org/
         */
        var semanticVersion: kotlin.String? = null
        /**
         * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
         * API.
         */
        var stackName: kotlin.String? = null
        /**
         * This property corresponds to the parameter of the same name for the AWS CloudFormation <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/CreateChangeSet">CreateChangeSet
         * API.
         */
        var tags: List<Tag>? = null
        /**
         * The UUID returned by CreateCloudFormationTemplate.Pattern: &#91;0-9a-fA-F&#93;{8}\-&#91;0-9a-fA-F&#93;{4}\-&#91;0-9a-fA-F&#93;{4}\-&#91;0-9a-fA-F&#93;{4}\-&#91;0-9a-fA-F&#93;{12}
         */
        var templateId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest) : this() {
            this.applicationId = x.applicationId
            this.capabilities = x.capabilities
            this.changeSetName = x.changeSetName
            this.clientToken = x.clientToken
            this.description = x.description
            this.notificationArns = x.notificationArns
            this.parameterOverrides = x.parameterOverrides
            this.resourceTypes = x.resourceTypes
            this.rollbackConfiguration = x.rollbackConfiguration
            this.semanticVersion = x.semanticVersion
            this.stackName = x.stackName
            this.tags = x.tags
            this.templateId = x.templateId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest = CreateCloudFormationChangeSetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.serverlessapplicationrepository.model.RollbackConfiguration] inside the given [block]
         */
        fun rollbackConfiguration(block: aws.sdk.kotlin.services.serverlessapplicationrepository.model.RollbackConfiguration.Builder.() -> kotlin.Unit) {
            this.rollbackConfiguration = aws.sdk.kotlin.services.serverlessapplicationrepository.model.RollbackConfiguration.invoke(block)
        }
    }
}
