// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.serde

import aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryException
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.Version
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateApplicationOperationDeserializer: HttpDeserializer.NonStreaming<CreateApplicationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateApplicationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateApplicationError(context, call, payload)
        }
        val builder = CreateApplicationResponse.Builder()

        if (payload != null) {
            deserializeCreateApplicationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateApplicationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServerlessApplicationRepositoryException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServerlessApplicationRepositoryException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateApplicationOperationBody(builder: CreateApplicationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationId"))
    val AUTHOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("author"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("creationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val HOMEPAGEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("homePageUrl"))
    val ISVERIFIEDAUTHOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isVerifiedAuthor"))
    val LABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("labels"))
    val LICENSEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("licenseUrl"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val READMEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("readmeUrl"))
    val SPDXLICENSEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("spdxLicenseId"))
    val VERIFIEDAUTHORURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("verifiedAuthorUrl"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONID_DESCRIPTOR)
        field(AUTHOR_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(HOMEPAGEURL_DESCRIPTOR)
        field(ISVERIFIEDAUTHOR_DESCRIPTOR)
        field(LABELS_DESCRIPTOR)
        field(LICENSEURL_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(READMEURL_DESCRIPTOR)
        field(SPDXLICENSEID_DESCRIPTOR)
        field(VERIFIEDAUTHORURL_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                AUTHOR_DESCRIPTOR.index -> builder.author = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                HOMEPAGEURL_DESCRIPTOR.index -> builder.homePageUrl = deserializeString()
                ISVERIFIEDAUTHOR_DESCRIPTOR.index -> builder.isVerifiedAuthor = deserializeBoolean()
                LABELS_DESCRIPTOR.index -> builder.labels =
                    deserializer.deserializeList(LABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LICENSEURL_DESCRIPTOR.index -> builder.licenseUrl = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                READMEURL_DESCRIPTOR.index -> builder.readmeUrl = deserializeString()
                SPDXLICENSEID_DESCRIPTOR.index -> builder.spdxLicenseId = deserializeString()
                VERIFIEDAUTHORURL_DESCRIPTOR.index -> builder.verifiedAuthorUrl = deserializeString()
                VERSION_DESCRIPTOR.index -> builder.version = deserializeVersionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
