// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateApplicationRequest private constructor(builder: Builder) {
    /**
     * The name of the author publishing the app.
     *
     * Minimum length=1. Maximum length=127.
     *
     * Pattern "^&#91;a-z0-9&#93;((&#91;a-z0-9&#93;|-(?!-))*&#91;a-z0-9&#93;)?$";
     */
    public val author: kotlin.String? = builder.author
    /**
     * The description of the application.
     *
     * Minimum length=1. Maximum length=256
     */
    public val description: kotlin.String? = builder.description
    /**
     * A URL with more information about the application, for example the location of your GitHub repository for the application.
     */
    public val homePageUrl: kotlin.String? = builder.homePageUrl
    /**
     * Labels to improve discovery of apps in search results.
     *
     * Minimum length=1. Maximum length=127. Maximum number of labels: 10
     *
     * Pattern: "^&#91;a-zA-Z0-9+\\-_:\\/@&#93;+$";
     */
    public val labels: List<String>? = builder.labels
    /**
     * A local text file that contains the license of the app that matches the spdxLicenseID value of your application. The file has the format file://<path>/<filename>.
     *
     * Maximum size 5 MB
     *
     * You can specify only one of licenseBody and licenseUrl; otherwise, an error results.
     */
    public val licenseBody: kotlin.String? = builder.licenseBody
    /**
     * A link to the S3 object that contains the license of the app that matches the spdxLicenseID value of your application.
     *
     * Maximum size 5 MB
     *
     * You can specify only one of licenseBody and licenseUrl; otherwise, an error results.
     */
    public val licenseUrl: kotlin.String? = builder.licenseUrl
    /**
     * The name of the application that you want to publish.
     *
     * Minimum length=1. Maximum length=140
     *
     * Pattern: "&#91;a-zA-Z0-9\\-&#93;+";
     */
    public val name: kotlin.String? = builder.name
    /**
     * A local text readme file in Markdown language that contains a more detailed description of the application and how it works. The file has the format file://<path>/<filename>.
     *
     * Maximum size 5 MB
     *
     * You can specify only one of readmeBody and readmeUrl; otherwise, an error results.
     */
    public val readmeBody: kotlin.String? = builder.readmeBody
    /**
     * A link to the S3 object in Markdown language that contains a more detailed description of the application and how it works.
     *
     * Maximum size 5 MB
     *
     * You can specify only one of readmeBody and readmeUrl; otherwise, an error results.
     */
    public val readmeUrl: kotlin.String? = builder.readmeUrl
    /**
     * The semantic version of the application:
     *
     * [https://semver.org/](https://semver.org/)
     */
    public val semanticVersion: kotlin.String? = builder.semanticVersion
    /**
     * A link to the S3 object that contains the ZIP archive of the source code for this version of your application.
     *
     * Maximum size 50 MB
     */
    public val sourceCodeArchiveUrl: kotlin.String? = builder.sourceCodeArchiveUrl
    /**
     * A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.
     */
    public val sourceCodeUrl: kotlin.String? = builder.sourceCodeUrl
    /**
     * A valid identifier from [https://spdx.org/licenses/](https://spdx.org/licenses/).
     */
    public val spdxLicenseId: kotlin.String? = builder.spdxLicenseId
    /**
     * The local raw packaged AWS SAM template file of your application. The file has the format file://<path>/<filename>.
     *
     * You can specify only one of templateBody and templateUrl; otherwise an error results.
     */
    public val templateBody: kotlin.String? = builder.templateBody
    /**
     * A link to the S3 object containing the packaged AWS SAM template of your application.
     *
     * You can specify only one of templateBody and templateUrl; otherwise an error results.
     */
    public val templateUrl: kotlin.String? = builder.templateUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApplicationRequest(")
        append("author=$author,")
        append("description=$description,")
        append("homePageUrl=$homePageUrl,")
        append("labels=$labels,")
        append("licenseBody=$licenseBody,")
        append("licenseUrl=$licenseUrl,")
        append("name=$name,")
        append("readmeBody=$readmeBody,")
        append("readmeUrl=$readmeUrl,")
        append("semanticVersion=$semanticVersion,")
        append("sourceCodeArchiveUrl=$sourceCodeArchiveUrl,")
        append("sourceCodeUrl=$sourceCodeUrl,")
        append("spdxLicenseId=$spdxLicenseId,")
        append("templateBody=$templateBody,")
        append("templateUrl=$templateUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = author?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (homePageUrl?.hashCode() ?: 0)
        result = 31 * result + (labels?.hashCode() ?: 0)
        result = 31 * result + (licenseBody?.hashCode() ?: 0)
        result = 31 * result + (licenseUrl?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (readmeBody?.hashCode() ?: 0)
        result = 31 * result + (readmeUrl?.hashCode() ?: 0)
        result = 31 * result + (semanticVersion?.hashCode() ?: 0)
        result = 31 * result + (sourceCodeArchiveUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceCodeUrl?.hashCode() ?: 0)
        result = 31 * result + (spdxLicenseId?.hashCode() ?: 0)
        result = 31 * result + (templateBody?.hashCode() ?: 0)
        result = 31 * result + (templateUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApplicationRequest

        if (author != other.author) return false
        if (description != other.description) return false
        if (homePageUrl != other.homePageUrl) return false
        if (labels != other.labels) return false
        if (licenseBody != other.licenseBody) return false
        if (licenseUrl != other.licenseUrl) return false
        if (name != other.name) return false
        if (readmeBody != other.readmeBody) return false
        if (readmeUrl != other.readmeUrl) return false
        if (semanticVersion != other.semanticVersion) return false
        if (sourceCodeArchiveUrl != other.sourceCodeArchiveUrl) return false
        if (sourceCodeUrl != other.sourceCodeUrl) return false
        if (spdxLicenseId != other.spdxLicenseId) return false
        if (templateBody != other.templateBody) return false
        if (templateUrl != other.templateUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the author publishing the app.
         *
         * Minimum length=1. Maximum length=127.
         *
         * Pattern "^&#91;a-z0-9&#93;((&#91;a-z0-9&#93;|-(?!-))*&#91;a-z0-9&#93;)?$";
         */
        public var author: kotlin.String? = null
        /**
         * The description of the application.
         *
         * Minimum length=1. Maximum length=256
         */
        public var description: kotlin.String? = null
        /**
         * A URL with more information about the application, for example the location of your GitHub repository for the application.
         */
        public var homePageUrl: kotlin.String? = null
        /**
         * Labels to improve discovery of apps in search results.
         *
         * Minimum length=1. Maximum length=127. Maximum number of labels: 10
         *
         * Pattern: "^&#91;a-zA-Z0-9+\\-_:\\/@&#93;+$";
         */
        public var labels: List<String>? = null
        /**
         * A local text file that contains the license of the app that matches the spdxLicenseID value of your application. The file has the format file://<path>/<filename>.
         *
         * Maximum size 5 MB
         *
         * You can specify only one of licenseBody and licenseUrl; otherwise, an error results.
         */
        public var licenseBody: kotlin.String? = null
        /**
         * A link to the S3 object that contains the license of the app that matches the spdxLicenseID value of your application.
         *
         * Maximum size 5 MB
         *
         * You can specify only one of licenseBody and licenseUrl; otherwise, an error results.
         */
        public var licenseUrl: kotlin.String? = null
        /**
         * The name of the application that you want to publish.
         *
         * Minimum length=1. Maximum length=140
         *
         * Pattern: "&#91;a-zA-Z0-9\\-&#93;+";
         */
        public var name: kotlin.String? = null
        /**
         * A local text readme file in Markdown language that contains a more detailed description of the application and how it works. The file has the format file://<path>/<filename>.
         *
         * Maximum size 5 MB
         *
         * You can specify only one of readmeBody and readmeUrl; otherwise, an error results.
         */
        public var readmeBody: kotlin.String? = null
        /**
         * A link to the S3 object in Markdown language that contains a more detailed description of the application and how it works.
         *
         * Maximum size 5 MB
         *
         * You can specify only one of readmeBody and readmeUrl; otherwise, an error results.
         */
        public var readmeUrl: kotlin.String? = null
        /**
         * The semantic version of the application:
         *
         * [https://semver.org/](https://semver.org/)
         */
        public var semanticVersion: kotlin.String? = null
        /**
         * A link to the S3 object that contains the ZIP archive of the source code for this version of your application.
         *
         * Maximum size 50 MB
         */
        public var sourceCodeArchiveUrl: kotlin.String? = null
        /**
         * A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit.
         */
        public var sourceCodeUrl: kotlin.String? = null
        /**
         * A valid identifier from [https://spdx.org/licenses/](https://spdx.org/licenses/).
         */
        public var spdxLicenseId: kotlin.String? = null
        /**
         * The local raw packaged AWS SAM template file of your application. The file has the format file://<path>/<filename>.
         *
         * You can specify only one of templateBody and templateUrl; otherwise an error results.
         */
        public var templateBody: kotlin.String? = null
        /**
         * A link to the S3 object containing the packaged AWS SAM template of your application.
         *
         * You can specify only one of templateBody and templateUrl; otherwise an error results.
         */
        public var templateUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationRequest) : this() {
            this.author = x.author
            this.description = x.description
            this.homePageUrl = x.homePageUrl
            this.labels = x.labels
            this.licenseBody = x.licenseBody
            this.licenseUrl = x.licenseUrl
            this.name = x.name
            this.readmeBody = x.readmeBody
            this.readmeUrl = x.readmeUrl
            this.semanticVersion = x.semanticVersion
            this.sourceCodeArchiveUrl = x.sourceCodeArchiveUrl
            this.sourceCodeUrl = x.sourceCodeUrl
            this.spdxLicenseId = x.spdxLicenseId
            this.templateBody = x.templateBody
            this.templateUrl = x.templateUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationRequest = CreateApplicationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
