// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateApplicationResponse private constructor(builder: Builder) {
    /**
     * The application Amazon Resource Name (ARN).
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The name of the author publishing the app.
     *
     * Minimum length=1. Maximum length=127.
     *
     * Pattern "^&#91;a-z0-9&#93;((&#91;a-z0-9&#93;|-(?!-))*&#91;a-z0-9&#93;)?$";
     */
    public val author: kotlin.String? = builder.author
    /**
     * The date and time this resource was created.
     */
    public val creationTime: kotlin.String? = builder.creationTime
    /**
     * The description of the application.
     *
     * Minimum length=1. Maximum length=256
     */
    public val description: kotlin.String? = builder.description
    /**
     * A URL with more information about the application, for example the location of your GitHub repository for the application.
     */
    public val homePageUrl: kotlin.String? = builder.homePageUrl
    /**
     * Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.
     */
    public val isVerifiedAuthor: kotlin.Boolean? = builder.isVerifiedAuthor
    /**
     * Labels to improve discovery of apps in search results.
     *
     * Minimum length=1. Maximum length=127. Maximum number of labels: 10
     *
     * Pattern: "^&#91;a-zA-Z0-9+\\-_:\\/@&#93;+$";
     */
    public val labels: List<String>? = builder.labels
    /**
     * A link to a license file of the app that matches the spdxLicenseID value of your application.
     *
     * Maximum size 5 MB
     */
    public val licenseUrl: kotlin.String? = builder.licenseUrl
    /**
     * The name of the application.
     *
     * Minimum length=1. Maximum length=140
     *
     * Pattern: "&#91;a-zA-Z0-9\\-&#93;+";
     */
    public val name: kotlin.String? = builder.name
    /**
     * A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.
     *
     * Maximum size 5 MB
     */
    public val readmeUrl: kotlin.String? = builder.readmeUrl
    /**
     * A valid identifier from https://spdx.org/licenses/.
     */
    public val spdxLicenseId: kotlin.String? = builder.spdxLicenseId
    /**
     * The URL to the public profile of a verified author. This URL is submitted by the author.
     */
    public val verifiedAuthorUrl: kotlin.String? = builder.verifiedAuthorUrl
    /**
     * Version information about the application.
     */
    public val version: aws.sdk.kotlin.services.serverlessapplicationrepository.model.Version? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApplicationResponse(")
        append("applicationId=$applicationId,")
        append("author=$author,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("homePageUrl=$homePageUrl,")
        append("isVerifiedAuthor=$isVerifiedAuthor,")
        append("labels=$labels,")
        append("licenseUrl=$licenseUrl,")
        append("name=$name,")
        append("readmeUrl=$readmeUrl,")
        append("spdxLicenseId=$spdxLicenseId,")
        append("verifiedAuthorUrl=$verifiedAuthorUrl,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (author?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (homePageUrl?.hashCode() ?: 0)
        result = 31 * result + (isVerifiedAuthor?.hashCode() ?: 0)
        result = 31 * result + (labels?.hashCode() ?: 0)
        result = 31 * result + (licenseUrl?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (readmeUrl?.hashCode() ?: 0)
        result = 31 * result + (spdxLicenseId?.hashCode() ?: 0)
        result = 31 * result + (verifiedAuthorUrl?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApplicationResponse

        if (applicationId != other.applicationId) return false
        if (author != other.author) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (homePageUrl != other.homePageUrl) return false
        if (isVerifiedAuthor != other.isVerifiedAuthor) return false
        if (labels != other.labels) return false
        if (licenseUrl != other.licenseUrl) return false
        if (name != other.name) return false
        if (readmeUrl != other.readmeUrl) return false
        if (spdxLicenseId != other.spdxLicenseId) return false
        if (verifiedAuthorUrl != other.verifiedAuthorUrl) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The application Amazon Resource Name (ARN).
         */
        public var applicationId: kotlin.String? = null
        /**
         * The name of the author publishing the app.
         *
         * Minimum length=1. Maximum length=127.
         *
         * Pattern "^&#91;a-z0-9&#93;((&#91;a-z0-9&#93;|-(?!-))*&#91;a-z0-9&#93;)?$";
         */
        public var author: kotlin.String? = null
        /**
         * The date and time this resource was created.
         */
        public var creationTime: kotlin.String? = null
        /**
         * The description of the application.
         *
         * Minimum length=1. Maximum length=256
         */
        public var description: kotlin.String? = null
        /**
         * A URL with more information about the application, for example the location of your GitHub repository for the application.
         */
        public var homePageUrl: kotlin.String? = null
        /**
         * Whether the author of this application has been verified. This means means that AWS has made a good faith review, as a reasonable and prudent service provider, of the information provided by the requester and has confirmed that the requester's identity is as claimed.
         */
        public var isVerifiedAuthor: kotlin.Boolean? = null
        /**
         * Labels to improve discovery of apps in search results.
         *
         * Minimum length=1. Maximum length=127. Maximum number of labels: 10
         *
         * Pattern: "^&#91;a-zA-Z0-9+\\-_:\\/@&#93;+$";
         */
        public var labels: List<String>? = null
        /**
         * A link to a license file of the app that matches the spdxLicenseID value of your application.
         *
         * Maximum size 5 MB
         */
        public var licenseUrl: kotlin.String? = null
        /**
         * The name of the application.
         *
         * Minimum length=1. Maximum length=140
         *
         * Pattern: "&#91;a-zA-Z0-9\\-&#93;+";
         */
        public var name: kotlin.String? = null
        /**
         * A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.
         *
         * Maximum size 5 MB
         */
        public var readmeUrl: kotlin.String? = null
        /**
         * A valid identifier from https://spdx.org/licenses/.
         */
        public var spdxLicenseId: kotlin.String? = null
        /**
         * The URL to the public profile of a verified author. This URL is submitted by the author.
         */
        public var verifiedAuthorUrl: kotlin.String? = null
        /**
         * Version information about the application.
         */
        public var version: aws.sdk.kotlin.services.serverlessapplicationrepository.model.Version? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationResponse) : this() {
            this.applicationId = x.applicationId
            this.author = x.author
            this.creationTime = x.creationTime
            this.description = x.description
            this.homePageUrl = x.homePageUrl
            this.isVerifiedAuthor = x.isVerifiedAuthor
            this.labels = x.labels
            this.licenseUrl = x.licenseUrl
            this.name = x.name
            this.readmeUrl = x.readmeUrl
            this.spdxLicenseId = x.spdxLicenseId
            this.verifiedAuthorUrl = x.verifiedAuthorUrl
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.serverlessapplicationrepository.model.CreateApplicationResponse = CreateApplicationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.serverlessapplicationrepository.model.Version] inside the given [block]
         */
        public fun version(block: aws.sdk.kotlin.services.serverlessapplicationrepository.model.Version.Builder.() -> kotlin.Unit) {
            this.version = aws.sdk.kotlin.services.serverlessapplicationrepository.model.Version.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
