// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.serverlessapplicationrepository.paginators

import aws.sdk.kotlin.services.serverlessapplicationrepository.ServerlessApplicationRepositoryClient
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ListApplicationDependenciesRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ListApplicationDependenciesResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ListApplicationsRequest
import aws.sdk.kotlin.services.serverlessapplicationrepository.model.ListApplicationsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListApplicationDependenciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationDependenciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationDependenciesResponse]
 */
public fun ServerlessApplicationRepositoryClient.listApplicationDependenciesPaginated(initialRequest: ListApplicationDependenciesRequest): Flow<ListApplicationDependenciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationDependenciesPaginated.listApplicationDependencies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationDependenciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationDependenciesResponse]
 */
public fun ServerlessApplicationRepositoryClient.listApplicationDependenciesPaginated(block: ListApplicationDependenciesRequest.Builder.() -> Unit): Flow<ListApplicationDependenciesResponse> =
    listApplicationDependenciesPaginated(ListApplicationDependenciesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun ServerlessApplicationRepositoryClient.listApplicationsPaginated(initialRequest: ListApplicationsRequest = ListApplicationsRequest { }): Flow<ListApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationsPaginated.listApplications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun ServerlessApplicationRepositoryClient.listApplicationsPaginated(block: ListApplicationsRequest.Builder.() -> Unit): Flow<ListApplicationsResponse> =
    listApplicationsPaginated(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListApplicationVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationVersionsResponse]
 */
public fun ServerlessApplicationRepositoryClient.listApplicationVersionsPaginated(initialRequest: ListApplicationVersionsRequest): Flow<ListApplicationVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationVersionsPaginated.listApplicationVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationVersionsResponse]
 */
public fun ServerlessApplicationRepositoryClient.listApplicationVersionsPaginated(block: ListApplicationVersionsRequest.Builder.() -> Unit): Flow<ListApplicationVersionsResponse> =
    listApplicationVersionsPaginated(ListApplicationVersionsRequest.Builder().apply(block).build())
