// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.serde

import aws.sdk.kotlin.services.securitylake.model.AwsIdentity
import aws.sdk.kotlin.services.securitylake.model.LogSourceResource
import aws.sdk.kotlin.services.securitylake.model.UpdateSubscriberRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateSubscriberOperationSerializer: HttpSerializer.NonStreaming<UpdateSubscriberRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateSubscriberRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.subscriberId) { "subscriberId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v1"))
                add(PercentEncoding.Path.encode("subscribers"))
                add(PercentEncoding.SmithyLabel.encode(input.subscriberId))
            }
        }

        val payload = serializeUpdateSubscriberOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateSubscriberOperationBody(context: ExecutionContext, input: UpdateSubscriberRequest): ByteArray {
    val serializer = JsonSerializer()
    val SOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("sources"))
    val SUBSCRIBERDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("subscriberDescription"))
    val SUBSCRIBERIDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("subscriberIdentity"))
    val SUBSCRIBERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("subscriberName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SOURCES_DESCRIPTOR)
        field(SUBSCRIBERDESCRIPTION_DESCRIPTOR)
        field(SUBSCRIBERIDENTITY_DESCRIPTOR)
        field(SUBSCRIBERNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.sources != null) {
            listField(SOURCES_DESCRIPTOR) {
                for (el0 in input.sources) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeLogSourceResourceDocument))
                }
            }
        }
        input.subscriberDescription?.let { field(SUBSCRIBERDESCRIPTION_DESCRIPTOR, it) }
        input.subscriberIdentity?.let { field(SUBSCRIBERIDENTITY_DESCRIPTOR, it, ::serializeAwsIdentityDocument) }
        input.subscriberName?.let { field(SUBSCRIBERNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
