// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.paginators

import aws.sdk.kotlin.services.securitylake.SecurityLakeClient
import aws.sdk.kotlin.services.securitylake.model.DataLakeException
import aws.sdk.kotlin.services.securitylake.model.DataLakeSource
import aws.sdk.kotlin.services.securitylake.model.GetDataLakeSourcesRequest
import aws.sdk.kotlin.services.securitylake.model.GetDataLakeSourcesResponse
import aws.sdk.kotlin.services.securitylake.model.ListDataLakeExceptionsRequest
import aws.sdk.kotlin.services.securitylake.model.ListDataLakeExceptionsResponse
import aws.sdk.kotlin.services.securitylake.model.ListLogSourcesRequest
import aws.sdk.kotlin.services.securitylake.model.ListLogSourcesResponse
import aws.sdk.kotlin.services.securitylake.model.ListSubscribersRequest
import aws.sdk.kotlin.services.securitylake.model.ListSubscribersResponse
import aws.sdk.kotlin.services.securitylake.model.LogSource
import aws.sdk.kotlin.services.securitylake.model.SubscriberResource
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetDataLakeSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetDataLakeSourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDataLakeSourcesResponse]
 */
public fun SecurityLakeClient.getDataLakeSourcesPaginated(initialRequest: GetDataLakeSourcesRequest = GetDataLakeSourcesRequest { }): Flow<GetDataLakeSourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getDataLakeSourcesPaginated.getDataLakeSources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetDataLakeSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDataLakeSourcesResponse]
 */
public fun SecurityLakeClient.getDataLakeSourcesPaginated(block: GetDataLakeSourcesRequest.Builder.() -> Unit): Flow<GetDataLakeSourcesResponse> =
    getDataLakeSourcesPaginated(GetDataLakeSourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getDataLakeSourcesPaginated]
 * to access the nested member [DataLakeSource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataLakeSource]
 */
@JvmName("getDataLakeSourcesResponseDataLakeSource")
public fun Flow<GetDataLakeSourcesResponse>.dataLakeSources(): Flow<DataLakeSource> =
    transform() { response ->
        response.dataLakeSources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataLakeExceptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataLakeExceptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataLakeExceptionsResponse]
 */
public fun SecurityLakeClient.listDataLakeExceptionsPaginated(initialRequest: ListDataLakeExceptionsRequest = ListDataLakeExceptionsRequest { }): Flow<ListDataLakeExceptionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataLakeExceptionsPaginated.listDataLakeExceptions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataLakeExceptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataLakeExceptionsResponse]
 */
public fun SecurityLakeClient.listDataLakeExceptionsPaginated(block: ListDataLakeExceptionsRequest.Builder.() -> Unit): Flow<ListDataLakeExceptionsResponse> =
    listDataLakeExceptionsPaginated(ListDataLakeExceptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataLakeExceptionsPaginated]
 * to access the nested member [DataLakeException]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataLakeException]
 */
@JvmName("listDataLakeExceptionsResponseDataLakeException")
public fun Flow<ListDataLakeExceptionsResponse>.exceptions(): Flow<DataLakeException> =
    transform() { response ->
        response.exceptions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListLogSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListLogSourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLogSourcesResponse]
 */
public fun SecurityLakeClient.listLogSourcesPaginated(initialRequest: ListLogSourcesRequest = ListLogSourcesRequest { }): Flow<ListLogSourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listLogSourcesPaginated.listLogSources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListLogSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListLogSourcesResponse]
 */
public fun SecurityLakeClient.listLogSourcesPaginated(block: ListLogSourcesRequest.Builder.() -> Unit): Flow<ListLogSourcesResponse> =
    listLogSourcesPaginated(ListLogSourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listLogSourcesPaginated]
 * to access the nested member [LogSource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LogSource]
 */
@JvmName("listLogSourcesResponseLogSource")
public fun Flow<ListLogSourcesResponse>.sources(): Flow<LogSource> =
    transform() { response ->
        response.sources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSubscribersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSubscribersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscribersResponse]
 */
public fun SecurityLakeClient.listSubscribersPaginated(initialRequest: ListSubscribersRequest = ListSubscribersRequest { }): Flow<ListSubscribersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSubscribersPaginated.listSubscribers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSubscribersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSubscribersResponse]
 */
public fun SecurityLakeClient.listSubscribersPaginated(block: ListSubscribersRequest.Builder.() -> Unit): Flow<ListSubscribersResponse> =
    listSubscribersPaginated(ListSubscribersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSubscribersPaginated]
 * to access the nested member [SubscriberResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SubscriberResource]
 */
@JvmName("listSubscribersResponseSubscriberResource")
public fun Flow<ListSubscribersResponse>.subscribers(): Flow<SubscriberResource> =
    transform() { response ->
        response.subscribers?.forEach {
            emit(it)
        }
    }
