// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides details about the Amazon Security Lake account subscription. Subscribers are notified of new objects for a source as the data is written to your Amazon S3 bucket for Security Lake.
 */
public class SubscriberResource private constructor(builder: Builder) {
    /**
     * You can choose to notify subscribers of new objects with an Amazon Simple Queue Service (Amazon SQS) queue or through messaging to an HTTPS endpoint provided by the subscriber.
     *
     *  Subscribers can consume data by directly querying Lake Formation tables in your Amazon S3 bucket through services like Amazon Athena. This subscription type is defined as `LAKEFORMATION`.
     */
    public val accessTypes: List<AccessType>? = builder.accessTypes
    /**
     * The date and time when the subscriber was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The Amazon Resource Name (ARN) which uniquely defines the Amazon Web Services RAM resource share. Before accepting the RAM resource share invitation, you can view details related to the RAM resource share.
     *
     * This field is available only for Lake Formation subscribers created after March 8, 2023.
     */
    public val resourceShareArn: kotlin.String? = builder.resourceShareArn
    /**
     * The name of the resource share.
     */
    public val resourceShareName: kotlin.String? = builder.resourceShareName
    /**
     * The Amazon Resource Name (ARN) specifying the role of the subscriber.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The ARN for the Amazon S3 bucket.
     */
    public val s3BucketArn: kotlin.String? = builder.s3BucketArn
    /**
     * Amazon Security Lake supports log and event collection for natively supported Amazon Web Services. For more information, see the [Amazon Security Lake User Guide](https://docs.aws.amazon.com/security-lake/latest/userguide/source-management.html).
     */
    public val sources: List<LogSourceResource> = requireNotNull(builder.sources) { "A non-null value must be provided for sources" }
    /**
     * The subscriber ARN of the Amazon Security Lake subscriber account.
     */
    public val subscriberArn: kotlin.String = requireNotNull(builder.subscriberArn) { "A non-null value must be provided for subscriberArn" }
    /**
     * The subscriber descriptions for a subscriber account. The description for a subscriber includes `subscriberName`, `accountID`, `externalID`, and `subscriberId`.
     */
    public val subscriberDescription: kotlin.String? = builder.subscriberDescription
    /**
     * The subscriber endpoint to which exception messages are posted.
     */
    public val subscriberEndpoint: kotlin.String? = builder.subscriberEndpoint
    /**
     * The subscriber ID of the Amazon Security Lake subscriber account.
     */
    public val subscriberId: kotlin.String = requireNotNull(builder.subscriberId) { "A non-null value must be provided for subscriberId" }
    /**
     * The Amazon Web Services identity used to access your data.
     */
    public val subscriberIdentity: aws.sdk.kotlin.services.securitylake.model.AwsIdentity? = builder.subscriberIdentity
    /**
     * The name of your Amazon Security Lake subscriber account.
     */
    public val subscriberName: kotlin.String = requireNotNull(builder.subscriberName) { "A non-null value must be provided for subscriberName" }
    /**
     * The subscriber status of the Amazon Security Lake subscriber account.
     */
    public val subscriberStatus: aws.sdk.kotlin.services.securitylake.model.SubscriberStatus? = builder.subscriberStatus
    /**
     * The date and time when the subscriber was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securitylake.model.SubscriberResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SubscriberResource(")
        append("accessTypes=$accessTypes,")
        append("createdAt=$createdAt,")
        append("resourceShareArn=$resourceShareArn,")
        append("resourceShareName=$resourceShareName,")
        append("roleArn=$roleArn,")
        append("s3BucketArn=$s3BucketArn,")
        append("sources=$sources,")
        append("subscriberArn=$subscriberArn,")
        append("subscriberDescription=$subscriberDescription,")
        append("subscriberEndpoint=$subscriberEndpoint,")
        append("subscriberId=$subscriberId,")
        append("subscriberIdentity=$subscriberIdentity,")
        append("subscriberName=$subscriberName,")
        append("subscriberStatus=$subscriberStatus,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessTypes?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (resourceShareArn?.hashCode() ?: 0)
        result = 31 * result + (resourceShareName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3BucketArn?.hashCode() ?: 0)
        result = 31 * result + (sources.hashCode())
        result = 31 * result + (subscriberArn.hashCode())
        result = 31 * result + (subscriberDescription?.hashCode() ?: 0)
        result = 31 * result + (subscriberEndpoint?.hashCode() ?: 0)
        result = 31 * result + (subscriberId.hashCode())
        result = 31 * result + (subscriberIdentity?.hashCode() ?: 0)
        result = 31 * result + (subscriberName.hashCode())
        result = 31 * result + (subscriberStatus?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SubscriberResource

        if (accessTypes != other.accessTypes) return false
        if (createdAt != other.createdAt) return false
        if (resourceShareArn != other.resourceShareArn) return false
        if (resourceShareName != other.resourceShareName) return false
        if (roleArn != other.roleArn) return false
        if (s3BucketArn != other.s3BucketArn) return false
        if (sources != other.sources) return false
        if (subscriberArn != other.subscriberArn) return false
        if (subscriberDescription != other.subscriberDescription) return false
        if (subscriberEndpoint != other.subscriberEndpoint) return false
        if (subscriberId != other.subscriberId) return false
        if (subscriberIdentity != other.subscriberIdentity) return false
        if (subscriberName != other.subscriberName) return false
        if (subscriberStatus != other.subscriberStatus) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securitylake.model.SubscriberResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * You can choose to notify subscribers of new objects with an Amazon Simple Queue Service (Amazon SQS) queue or through messaging to an HTTPS endpoint provided by the subscriber.
         *
         *  Subscribers can consume data by directly querying Lake Formation tables in your Amazon S3 bucket through services like Amazon Athena. This subscription type is defined as `LAKEFORMATION`.
         */
        public var accessTypes: List<AccessType>? = null
        /**
         * The date and time when the subscriber was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) which uniquely defines the Amazon Web Services RAM resource share. Before accepting the RAM resource share invitation, you can view details related to the RAM resource share.
         *
         * This field is available only for Lake Formation subscribers created after March 8, 2023.
         */
        public var resourceShareArn: kotlin.String? = null
        /**
         * The name of the resource share.
         */
        public var resourceShareName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) specifying the role of the subscriber.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The ARN for the Amazon S3 bucket.
         */
        public var s3BucketArn: kotlin.String? = null
        /**
         * Amazon Security Lake supports log and event collection for natively supported Amazon Web Services. For more information, see the [Amazon Security Lake User Guide](https://docs.aws.amazon.com/security-lake/latest/userguide/source-management.html).
         */
        public var sources: List<LogSourceResource>? = null
        /**
         * The subscriber ARN of the Amazon Security Lake subscriber account.
         */
        public var subscriberArn: kotlin.String? = null
        /**
         * The subscriber descriptions for a subscriber account. The description for a subscriber includes `subscriberName`, `accountID`, `externalID`, and `subscriberId`.
         */
        public var subscriberDescription: kotlin.String? = null
        /**
         * The subscriber endpoint to which exception messages are posted.
         */
        public var subscriberEndpoint: kotlin.String? = null
        /**
         * The subscriber ID of the Amazon Security Lake subscriber account.
         */
        public var subscriberId: kotlin.String? = null
        /**
         * The Amazon Web Services identity used to access your data.
         */
        public var subscriberIdentity: aws.sdk.kotlin.services.securitylake.model.AwsIdentity? = null
        /**
         * The name of your Amazon Security Lake subscriber account.
         */
        public var subscriberName: kotlin.String? = null
        /**
         * The subscriber status of the Amazon Security Lake subscriber account.
         */
        public var subscriberStatus: aws.sdk.kotlin.services.securitylake.model.SubscriberStatus? = null
        /**
         * The date and time when the subscriber was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securitylake.model.SubscriberResource) : this() {
            this.accessTypes = x.accessTypes
            this.createdAt = x.createdAt
            this.resourceShareArn = x.resourceShareArn
            this.resourceShareName = x.resourceShareName
            this.roleArn = x.roleArn
            this.s3BucketArn = x.s3BucketArn
            this.sources = x.sources
            this.subscriberArn = x.subscriberArn
            this.subscriberDescription = x.subscriberDescription
            this.subscriberEndpoint = x.subscriberEndpoint
            this.subscriberId = x.subscriberId
            this.subscriberIdentity = x.subscriberIdentity
            this.subscriberName = x.subscriberName
            this.subscriberStatus = x.subscriberStatus
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securitylake.model.SubscriberResource = SubscriberResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.securitylake.model.AwsIdentity] inside the given [block]
         */
        public fun subscriberIdentity(block: aws.sdk.kotlin.services.securitylake.model.AwsIdentity.Builder.() -> kotlin.Unit) {
            this.subscriberIdentity = aws.sdk.kotlin.services.securitylake.model.AwsIdentity.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (sources == null) sources = emptyList()
            if (subscriberArn == null) subscriberArn = ""
            if (subscriberId == null) subscriberId = ""
            if (subscriberName == null) subscriberName = ""
            return this
        }
    }
}
