// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configurations for HTTPS subscriber notification.
 */
public class HttpsNotificationConfiguration private constructor(builder: Builder) {
    /**
     * The key name for the notification subscription.
     */
    public val authorizationApiKeyName: kotlin.String? = builder.authorizationApiKeyName
    /**
     * The key value for the notification subscription.
     */
    public val authorizationApiKeyValue: kotlin.String? = builder.authorizationApiKeyValue
    /**
     * The subscription endpoint in Security Lake. If you prefer notification with an HTTPs endpoint, populate this field.
     */
    public val endpoint: kotlin.String = requireNotNull(builder.endpoint) { "A non-null value must be provided for endpoint" }
    /**
     * The HTTPS method used for the notification subscription.
     */
    public val httpMethod: aws.sdk.kotlin.services.securitylake.model.HttpMethod? = builder.httpMethod
    /**
     * The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created. For more information about ARNs and how to use them in policies, see [Managing data access](https://docs.aws.amazon.com//security-lake/latest/userguide/subscriber-data-access.html) and [Amazon Web Services Managed Policies](https://docs.aws.amazon.com/security-lake/latest/userguide/security-iam-awsmanpol.html) in the *Amazon Security Lake User Guide*.
     */
    public val targetRoleArn: kotlin.String = requireNotNull(builder.targetRoleArn) { "A non-null value must be provided for targetRoleArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securitylake.model.HttpsNotificationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpsNotificationConfiguration(")
        append("authorizationApiKeyName=$authorizationApiKeyName,")
        append("authorizationApiKeyValue=$authorizationApiKeyValue,")
        append("endpoint=$endpoint,")
        append("httpMethod=$httpMethod,")
        append("targetRoleArn=$targetRoleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorizationApiKeyName?.hashCode() ?: 0
        result = 31 * result + (authorizationApiKeyValue?.hashCode() ?: 0)
        result = 31 * result + (endpoint.hashCode())
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (targetRoleArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpsNotificationConfiguration

        if (authorizationApiKeyName != other.authorizationApiKeyName) return false
        if (authorizationApiKeyValue != other.authorizationApiKeyValue) return false
        if (endpoint != other.endpoint) return false
        if (httpMethod != other.httpMethod) return false
        if (targetRoleArn != other.targetRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securitylake.model.HttpsNotificationConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The key name for the notification subscription.
         */
        public var authorizationApiKeyName: kotlin.String? = null
        /**
         * The key value for the notification subscription.
         */
        public var authorizationApiKeyValue: kotlin.String? = null
        /**
         * The subscription endpoint in Security Lake. If you prefer notification with an HTTPs endpoint, populate this field.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The HTTPS method used for the notification subscription.
         */
        public var httpMethod: aws.sdk.kotlin.services.securitylake.model.HttpMethod? = null
        /**
         * The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created. For more information about ARNs and how to use them in policies, see [Managing data access](https://docs.aws.amazon.com//security-lake/latest/userguide/subscriber-data-access.html) and [Amazon Web Services Managed Policies](https://docs.aws.amazon.com/security-lake/latest/userguide/security-iam-awsmanpol.html) in the *Amazon Security Lake User Guide*.
         */
        public var targetRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securitylake.model.HttpsNotificationConfiguration) : this() {
            this.authorizationApiKeyName = x.authorizationApiKeyName
            this.authorizationApiKeyValue = x.authorizationApiKeyValue
            this.endpoint = x.endpoint
            this.httpMethod = x.httpMethod
            this.targetRoleArn = x.targetRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securitylake.model.HttpsNotificationConfiguration = HttpsNotificationConfiguration(this)

        internal fun correctErrors(): Builder {
            if (endpoint == null) endpoint = ""
            if (targetRoleArn == null) targetRoleArn = ""
            return this
        }
    }
}
