// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Amazon Security Lake collects logs and events from supported Amazon Web Services and custom sources. For the list of supported Amazon Web Services, see the [Amazon Security Lake User Guide](https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html).
 */
public class DataLakeSource private constructor(builder: Builder) {
    /**
     * The ID of the Security Lake account for which logs are collected.
     */
    public val account: kotlin.String? = builder.account
    /**
     * The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake. The supported event classes are:
     * + `ACCESS_ACTIVITY`
     * + `FILE_ACTIVITY`
     * + `KERNEL_ACTIVITY`
     * + `KERNEL_EXTENSION`
     * + `MEMORY_ACTIVITY`
     * + `MODULE_ACTIVITY`
     * + `PROCESS_ACTIVITY`
     * + `REGISTRY_KEY_ACTIVITY`
     * + `REGISTRY_VALUE_ACTIVITY`
     * + `RESOURCE_ACTIVITY`
     * + `SCHEDULED_JOB_ACTIVITY`
     * + `SECURITY_FINDING`
     * + `ACCOUNT_CHANGE`
     * + `AUTHENTICATION`
     * + `AUTHORIZATION`
     * + `ENTITY_MANAGEMENT_AUDIT`
     * + `DHCP_ACTIVITY`
     * + `NETWORK_ACTIVITY`
     * + `DNS_ACTIVITY`
     * + `FTP_ACTIVITY`
     * + `HTTP_ACTIVITY`
     * + `RDP_ACTIVITY`
     * + `SMB_ACTIVITY`
     * + `SSH_ACTIVITY`
     * + `CONFIG_STATE`
     * + `INVENTORY_INFO`
     * + `EMAIL_ACTIVITY`
     * + `API_ACTIVITY`
     * + `CLOUD_API`
     */
    public val eventClasses: List<String>? = builder.eventClasses
    /**
     * The supported Amazon Web Services from which logs and events are collected. Amazon Security Lake supports log and event collection for natively supported Amazon Web Services.
     */
    public val sourceName: kotlin.String? = builder.sourceName
    /**
     * The log status for the Security Lake account.
     */
    public val sourceStatuses: List<DataLakeSourceStatus>? = builder.sourceStatuses

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securitylake.model.DataLakeSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataLakeSource(")
        append("account=$account,")
        append("eventClasses=$eventClasses,")
        append("sourceName=$sourceName,")
        append("sourceStatuses=$sourceStatuses")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = account?.hashCode() ?: 0
        result = 31 * result + (eventClasses?.hashCode() ?: 0)
        result = 31 * result + (sourceName?.hashCode() ?: 0)
        result = 31 * result + (sourceStatuses?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataLakeSource

        if (account != other.account) return false
        if (eventClasses != other.eventClasses) return false
        if (sourceName != other.sourceName) return false
        if (sourceStatuses != other.sourceStatuses) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securitylake.model.DataLakeSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Security Lake account for which logs are collected.
         */
        public var account: kotlin.String? = null
        /**
         * The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake. The supported event classes are:
         * + `ACCESS_ACTIVITY`
         * + `FILE_ACTIVITY`
         * + `KERNEL_ACTIVITY`
         * + `KERNEL_EXTENSION`
         * + `MEMORY_ACTIVITY`
         * + `MODULE_ACTIVITY`
         * + `PROCESS_ACTIVITY`
         * + `REGISTRY_KEY_ACTIVITY`
         * + `REGISTRY_VALUE_ACTIVITY`
         * + `RESOURCE_ACTIVITY`
         * + `SCHEDULED_JOB_ACTIVITY`
         * + `SECURITY_FINDING`
         * + `ACCOUNT_CHANGE`
         * + `AUTHENTICATION`
         * + `AUTHORIZATION`
         * + `ENTITY_MANAGEMENT_AUDIT`
         * + `DHCP_ACTIVITY`
         * + `NETWORK_ACTIVITY`
         * + `DNS_ACTIVITY`
         * + `FTP_ACTIVITY`
         * + `HTTP_ACTIVITY`
         * + `RDP_ACTIVITY`
         * + `SMB_ACTIVITY`
         * + `SSH_ACTIVITY`
         * + `CONFIG_STATE`
         * + `INVENTORY_INFO`
         * + `EMAIL_ACTIVITY`
         * + `API_ACTIVITY`
         * + `CLOUD_API`
         */
        public var eventClasses: List<String>? = null
        /**
         * The supported Amazon Web Services from which logs and events are collected. Amazon Security Lake supports log and event collection for natively supported Amazon Web Services.
         */
        public var sourceName: kotlin.String? = null
        /**
         * The log status for the Security Lake account.
         */
        public var sourceStatuses: List<DataLakeSourceStatus>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securitylake.model.DataLakeSource) : this() {
            this.account = x.account
            this.eventClasses = x.eventClasses
            this.sourceName = x.sourceName
            this.sourceStatuses = x.sourceStatuses
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securitylake.model.DataLakeSource = DataLakeSource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
