// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provide transition lifecycle details of Amazon Security Lake object.
 */
public class DataLakeLifecycleTransition private constructor(builder: Builder) {
    /**
     * Number of days before data transitions to a different S3 Storage Class in the Amazon Security Lake object.
     */
    public val days: kotlin.Int? = builder.days
    /**
     * The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
     */
    public val storageClass: kotlin.String? = builder.storageClass

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleTransition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataLakeLifecycleTransition(")
        append("days=$days,")
        append("storageClass=$storageClass")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = days ?: 0
        result = 31 * result + (storageClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataLakeLifecycleTransition

        if (days != other.days) return false
        if (storageClass != other.storageClass) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleTransition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Number of days before data transitions to a different S3 Storage Class in the Amazon Security Lake object.
         */
        public var days: kotlin.Int? = null
        /**
         * The range of storage classes that you can choose from based on the data access, resiliency, and cost requirements of your workloads.
         */
        public var storageClass: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleTransition) : this() {
            this.days = x.days
            this.storageClass = x.storageClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleTransition = DataLakeLifecycleTransition(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
