// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateCustomLogSourceRequest private constructor(builder: Builder) {
    /**
     * The configuration for the third-party custom source.
     */
    public val configuration: aws.sdk.kotlin.services.securitylake.model.CustomLogSourceConfiguration? = builder.configuration
    /**
     * The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake. The supported event classes are:
     * + `ACCESS_ACTIVITY`
     * + `FILE_ACTIVITY`
     * + `KERNEL_ACTIVITY`
     * + `KERNEL_EXTENSION`
     * + `MEMORY_ACTIVITY`
     * + `MODULE_ACTIVITY`
     * + `PROCESS_ACTIVITY`
     * + `REGISTRY_KEY_ACTIVITY`
     * + `REGISTRY_VALUE_ACTIVITY`
     * + `RESOURCE_ACTIVITY`
     * + `SCHEDULED_JOB_ACTIVITY`
     * + `SECURITY_FINDING`
     * + `ACCOUNT_CHANGE`
     * + `AUTHENTICATION`
     * + `AUTHORIZATION`
     * + `ENTITY_MANAGEMENT_AUDIT`
     * + `DHCP_ACTIVITY`
     * + `NETWORK_ACTIVITY`
     * + `DNS_ACTIVITY`
     * + `FTP_ACTIVITY`
     * + `HTTP_ACTIVITY`
     * + `RDP_ACTIVITY`
     * + `SMB_ACTIVITY`
     * + `SSH_ACTIVITY`
     * + `CONFIG_STATE`
     * + `INVENTORY_INFO`
     * + `EMAIL_ACTIVITY`
     * + `API_ACTIVITY`
     * + `CLOUD_API`
     */
    public val eventClasses: List<String>? = builder.eventClasses
    /**
     * Specify the name for a third-party custom source. This must be a Regionally unique value.
     */
    public val sourceName: kotlin.String? = builder.sourceName
    /**
     * Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.
     */
    public val sourceVersion: kotlin.String? = builder.sourceVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securitylake.model.CreateCustomLogSourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCustomLogSourceRequest(")
        append("configuration=$configuration,")
        append("eventClasses=$eventClasses,")
        append("sourceName=$sourceName,")
        append("sourceVersion=$sourceVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (eventClasses?.hashCode() ?: 0)
        result = 31 * result + (sourceName?.hashCode() ?: 0)
        result = 31 * result + (sourceVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCustomLogSourceRequest

        if (configuration != other.configuration) return false
        if (eventClasses != other.eventClasses) return false
        if (sourceName != other.sourceName) return false
        if (sourceVersion != other.sourceVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securitylake.model.CreateCustomLogSourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration for the third-party custom source.
         */
        public var configuration: aws.sdk.kotlin.services.securitylake.model.CustomLogSourceConfiguration? = null
        /**
         * The Open Cybersecurity Schema Framework (OCSF) event classes which describes the type of data that the custom source will send to Security Lake. The supported event classes are:
         * + `ACCESS_ACTIVITY`
         * + `FILE_ACTIVITY`
         * + `KERNEL_ACTIVITY`
         * + `KERNEL_EXTENSION`
         * + `MEMORY_ACTIVITY`
         * + `MODULE_ACTIVITY`
         * + `PROCESS_ACTIVITY`
         * + `REGISTRY_KEY_ACTIVITY`
         * + `REGISTRY_VALUE_ACTIVITY`
         * + `RESOURCE_ACTIVITY`
         * + `SCHEDULED_JOB_ACTIVITY`
         * + `SECURITY_FINDING`
         * + `ACCOUNT_CHANGE`
         * + `AUTHENTICATION`
         * + `AUTHORIZATION`
         * + `ENTITY_MANAGEMENT_AUDIT`
         * + `DHCP_ACTIVITY`
         * + `NETWORK_ACTIVITY`
         * + `DNS_ACTIVITY`
         * + `FTP_ACTIVITY`
         * + `HTTP_ACTIVITY`
         * + `RDP_ACTIVITY`
         * + `SMB_ACTIVITY`
         * + `SSH_ACTIVITY`
         * + `CONFIG_STATE`
         * + `INVENTORY_INFO`
         * + `EMAIL_ACTIVITY`
         * + `API_ACTIVITY`
         * + `CLOUD_API`
         */
        public var eventClasses: List<String>? = null
        /**
         * Specify the name for a third-party custom source. This must be a Regionally unique value.
         */
        public var sourceName: kotlin.String? = null
        /**
         * Specify the source version for the third-party custom source, to limit log collection to a specific version of custom data source.
         */
        public var sourceVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securitylake.model.CreateCustomLogSourceRequest) : this() {
            this.configuration = x.configuration
            this.eventClasses = x.eventClasses
            this.sourceName = x.sourceName
            this.sourceVersion = x.sourceVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securitylake.model.CreateCustomLogSourceRequest = CreateCustomLogSourceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.securitylake.model.CustomLogSourceConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.securitylake.model.CustomLogSourceConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.securitylake.model.CustomLogSourceConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
