// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides replication details for objects stored in the Amazon Security Lake data lake.
 */
public class DataLakeReplicationConfiguration private constructor(builder: Builder) {
    /**
     * Specifies one or more centralized rollup Regions. The Amazon Web Services Region specified in the `region` parameter of the `CreateDataLake`[](https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDataLake.html) or `UpdateDataLake`[](https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDataLake.html) operations contributes data to the rollup Region or Regions specified in this parameter.
     *
     * Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. S3 buckets that are configured for object replication can be owned by the same Amazon Web Services account or by different accounts. You can replicate objects to a single destination bucket or to multiple destination buckets. The destination buckets can be in different Regions or within the same Region as the source bucket.
     */
    public val regions: List<String>? = builder.regions
    /**
     * Replication settings for the Amazon S3 buckets. This parameter uses the Identity and Access Management (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataLakeReplicationConfiguration(")
        append("regions=$regions,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = regions?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataLakeReplicationConfiguration

        if (regions != other.regions) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies one or more centralized rollup Regions. The Amazon Web Services Region specified in the `region` parameter of the `CreateDataLake`[](https://docs.aws.amazon.com/security-lake/latest/APIReference/API_CreateDataLake.html) or `UpdateDataLake`[](https://docs.aws.amazon.com/security-lake/latest/APIReference/API_UpdateDataLake.html) operations contributes data to the rollup Region or Regions specified in this parameter.
         *
         * Replication enables automatic, asynchronous copying of objects across Amazon S3 buckets. S3 buckets that are configured for object replication can be owned by the same Amazon Web Services account or by different accounts. You can replicate objects to a single destination bucket or to multiple destination buckets. The destination buckets can be in different Regions or within the same Region as the source bucket.
         */
        public var regions: List<String>? = null
        /**
         * Replication settings for the Amazon S3 buckets. This parameter uses the Identity and Access Management (IAM) role you created that is managed by Security Lake, to ensure the replication setting is correct.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration) : this() {
            this.regions = x.regions
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration = DataLakeReplicationConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
