// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides details of Amazon Security Lake object.
 */
public class DataLakeConfiguration private constructor(builder: Builder) {
    /**
     * Provides encryption details of Amazon Security Lake object.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.securitylake.model.DataLakeEncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * Provides lifecycle details of Amazon Security Lake object.
     */
    public val lifecycleConfiguration: aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleConfiguration? = builder.lifecycleConfiguration
    /**
     * The Amazon Web Services Regions where Security Lake is automatically enabled.
     */
    public val region: kotlin.String = requireNotNull(builder.region) { "A non-null value must be provided for region" }
    /**
     * Provides replication details of Amazon Security Lake object.
     */
    public val replicationConfiguration: aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration? = builder.replicationConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securitylake.model.DataLakeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataLakeConfiguration(")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("lifecycleConfiguration=$lifecycleConfiguration,")
        append("region=$region,")
        append("replicationConfiguration=$replicationConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionConfiguration?.hashCode() ?: 0
        result = 31 * result + (lifecycleConfiguration?.hashCode() ?: 0)
        result = 31 * result + (region.hashCode())
        result = 31 * result + (replicationConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataLakeConfiguration

        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (lifecycleConfiguration != other.lifecycleConfiguration) return false
        if (region != other.region) return false
        if (replicationConfiguration != other.replicationConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securitylake.model.DataLakeConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Provides encryption details of Amazon Security Lake object.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.securitylake.model.DataLakeEncryptionConfiguration? = null
        /**
         * Provides lifecycle details of Amazon Security Lake object.
         */
        public var lifecycleConfiguration: aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleConfiguration? = null
        /**
         * The Amazon Web Services Regions where Security Lake is automatically enabled.
         */
        public var region: kotlin.String? = null
        /**
         * Provides replication details of Amazon Security Lake object.
         */
        public var replicationConfiguration: aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securitylake.model.DataLakeConfiguration) : this() {
            this.encryptionConfiguration = x.encryptionConfiguration
            this.lifecycleConfiguration = x.lifecycleConfiguration
            this.region = x.region
            this.replicationConfiguration = x.replicationConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securitylake.model.DataLakeConfiguration = DataLakeConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.securitylake.model.DataLakeEncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.securitylake.model.DataLakeEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.securitylake.model.DataLakeEncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleConfiguration] inside the given [block]
         */
        public fun lifecycleConfiguration(block: aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleConfiguration.Builder.() -> kotlin.Unit) {
            this.lifecycleConfiguration = aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration] inside the given [block]
         */
        public fun replicationConfiguration(block: aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration.Builder.() -> kotlin.Unit) {
            this.replicationConfiguration = aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (region == null) region = ""
            return this
        }
    }
}
