// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.securitylake.auth.DefaultSecurityLakeAuthSchemeProvider
import aws.sdk.kotlin.services.securitylake.auth.SecurityLakeAuthSchemeProvider
import aws.sdk.kotlin.services.securitylake.endpoints.DefaultSecurityLakeEndpointProvider
import aws.sdk.kotlin.services.securitylake.endpoints.SecurityLakeEndpointParameters
import aws.sdk.kotlin.services.securitylake.endpoints.SecurityLakeEndpointProvider
import aws.sdk.kotlin.services.securitylake.model.CreateAwsLogSourceRequest
import aws.sdk.kotlin.services.securitylake.model.CreateAwsLogSourceResponse
import aws.sdk.kotlin.services.securitylake.model.CreateCustomLogSourceRequest
import aws.sdk.kotlin.services.securitylake.model.CreateCustomLogSourceResponse
import aws.sdk.kotlin.services.securitylake.model.CreateDataLakeExceptionSubscriptionRequest
import aws.sdk.kotlin.services.securitylake.model.CreateDataLakeExceptionSubscriptionResponse
import aws.sdk.kotlin.services.securitylake.model.CreateDataLakeOrganizationConfigurationRequest
import aws.sdk.kotlin.services.securitylake.model.CreateDataLakeOrganizationConfigurationResponse
import aws.sdk.kotlin.services.securitylake.model.CreateDataLakeRequest
import aws.sdk.kotlin.services.securitylake.model.CreateDataLakeResponse
import aws.sdk.kotlin.services.securitylake.model.CreateSubscriberNotificationRequest
import aws.sdk.kotlin.services.securitylake.model.CreateSubscriberNotificationResponse
import aws.sdk.kotlin.services.securitylake.model.CreateSubscriberRequest
import aws.sdk.kotlin.services.securitylake.model.CreateSubscriberResponse
import aws.sdk.kotlin.services.securitylake.model.DeleteAwsLogSourceRequest
import aws.sdk.kotlin.services.securitylake.model.DeleteAwsLogSourceResponse
import aws.sdk.kotlin.services.securitylake.model.DeleteCustomLogSourceRequest
import aws.sdk.kotlin.services.securitylake.model.DeleteCustomLogSourceResponse
import aws.sdk.kotlin.services.securitylake.model.DeleteDataLakeExceptionSubscriptionRequest
import aws.sdk.kotlin.services.securitylake.model.DeleteDataLakeExceptionSubscriptionResponse
import aws.sdk.kotlin.services.securitylake.model.DeleteDataLakeOrganizationConfigurationRequest
import aws.sdk.kotlin.services.securitylake.model.DeleteDataLakeOrganizationConfigurationResponse
import aws.sdk.kotlin.services.securitylake.model.DeleteDataLakeRequest
import aws.sdk.kotlin.services.securitylake.model.DeleteDataLakeResponse
import aws.sdk.kotlin.services.securitylake.model.DeleteSubscriberNotificationRequest
import aws.sdk.kotlin.services.securitylake.model.DeleteSubscriberNotificationResponse
import aws.sdk.kotlin.services.securitylake.model.DeleteSubscriberRequest
import aws.sdk.kotlin.services.securitylake.model.DeleteSubscriberResponse
import aws.sdk.kotlin.services.securitylake.model.DeregisterDataLakeDelegatedAdministratorRequest
import aws.sdk.kotlin.services.securitylake.model.DeregisterDataLakeDelegatedAdministratorResponse
import aws.sdk.kotlin.services.securitylake.model.GetDataLakeExceptionSubscriptionRequest
import aws.sdk.kotlin.services.securitylake.model.GetDataLakeExceptionSubscriptionResponse
import aws.sdk.kotlin.services.securitylake.model.GetDataLakeOrganizationConfigurationRequest
import aws.sdk.kotlin.services.securitylake.model.GetDataLakeOrganizationConfigurationResponse
import aws.sdk.kotlin.services.securitylake.model.GetDataLakeSourcesRequest
import aws.sdk.kotlin.services.securitylake.model.GetDataLakeSourcesResponse
import aws.sdk.kotlin.services.securitylake.model.GetSubscriberRequest
import aws.sdk.kotlin.services.securitylake.model.GetSubscriberResponse
import aws.sdk.kotlin.services.securitylake.model.ListDataLakeExceptionsRequest
import aws.sdk.kotlin.services.securitylake.model.ListDataLakeExceptionsResponse
import aws.sdk.kotlin.services.securitylake.model.ListDataLakesRequest
import aws.sdk.kotlin.services.securitylake.model.ListDataLakesResponse
import aws.sdk.kotlin.services.securitylake.model.ListLogSourcesRequest
import aws.sdk.kotlin.services.securitylake.model.ListLogSourcesResponse
import aws.sdk.kotlin.services.securitylake.model.ListSubscribersRequest
import aws.sdk.kotlin.services.securitylake.model.ListSubscribersResponse
import aws.sdk.kotlin.services.securitylake.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.securitylake.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.securitylake.model.RegisterDataLakeDelegatedAdministratorRequest
import aws.sdk.kotlin.services.securitylake.model.RegisterDataLakeDelegatedAdministratorResponse
import aws.sdk.kotlin.services.securitylake.model.TagResourceRequest
import aws.sdk.kotlin.services.securitylake.model.TagResourceResponse
import aws.sdk.kotlin.services.securitylake.model.UntagResourceRequest
import aws.sdk.kotlin.services.securitylake.model.UntagResourceResponse
import aws.sdk.kotlin.services.securitylake.model.UpdateDataLakeExceptionSubscriptionRequest
import aws.sdk.kotlin.services.securitylake.model.UpdateDataLakeExceptionSubscriptionResponse
import aws.sdk.kotlin.services.securitylake.model.UpdateDataLakeRequest
import aws.sdk.kotlin.services.securitylake.model.UpdateDataLakeResponse
import aws.sdk.kotlin.services.securitylake.model.UpdateSubscriberNotificationRequest
import aws.sdk.kotlin.services.securitylake.model.UpdateSubscriberNotificationResponse
import aws.sdk.kotlin.services.securitylake.model.UpdateSubscriberRequest
import aws.sdk.kotlin.services.securitylake.model.UpdateSubscriberResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "SecurityLake"
public const val SdkVersion: String = "1.2.10"
public const val ServiceApiVersion: String = "2018-05-10"

/**
 * Amazon Security Lake is a fully managed security data lake service. You can use Security Lake to automatically centralize security data from cloud, on-premises, and custom sources into a data lake that's stored in your Amazon Web Services account. Amazon Web Services Organizations is an account management service that lets you consolidate multiple Amazon Web Services accounts into an organization that you create and centrally manage. With Organizations, you can create member accounts and invite existing accounts to join your organization. Security Lake helps you analyze security data for a more complete understanding of your security posture across the entire organization. It can also help you improve the protection of your workloads, applications, and data.
 *
 * The data lake is backed by Amazon Simple Storage Service (Amazon S3) buckets, and you retain ownership over your data.
 *
 * Amazon Security Lake integrates with CloudTrail, a service that provides a record of actions taken by a user, role, or an Amazon Web Services service. In Security Lake, CloudTrail captures API calls for Security Lake as events. The calls captured include calls from the Security Lake console and code calls to the Security Lake API operations. If you create a trail, you can enable continuous delivery of CloudTrail events to an Amazon S3 bucket, including events for Security Lake. If you don't configure a trail, you can still view the most recent events in the CloudTrail console in Event history. Using the information collected by CloudTrail you can determine the request that was made to Security Lake, the IP address from which the request was made, who made the request, when it was made, and additional details. To learn more about Security Lake information in CloudTrail, see the [Amazon Security Lake User Guide](https://docs.aws.amazon.com/security-lake/latest/userguide/securitylake-cloudtrail.html).
 *
 * Security Lake automates the collection of security-related log and event data from integrated Amazon Web Services and third-party services. It also helps you manage the lifecycle of data with customizable retention and replication settings. Security Lake converts ingested data into Apache Parquet format and a standard open-source schema called the Open Cybersecurity Schema Framework (OCSF).
 *
 * Other Amazon Web Services and third-party services can subscribe to the data that's stored in Security Lake for incident response and security data analytics.
 */
public interface SecurityLakeClient : SdkClient {
    /**
     * SecurityLakeClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SecurityLakeClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "SecurityLake",
                "SECURITYLAKE",
                "securitylake",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SecurityLakeClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SecurityLakeClient = DefaultSecurityLakeClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SecurityLakeEndpointProvider = builder.endpointProvider ?: DefaultSecurityLakeEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SecurityLakeAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSecurityLakeAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SecurityLake"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SecurityLakeEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SecurityLakeAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds a natively supported Amazon Web Service as an Amazon Security Lake source. Enables source types for member accounts in required Amazon Web Services Regions, based on the parameters you specify. You can choose any source type in any Region for either accounts that are part of a trusted organization or standalone accounts. Once you add an Amazon Web Service as a source, Security Lake starts collecting logs and events from it.
     *
     * You can use this API only to enable natively supported Amazon Web Services as a source. Use `CreateCustomLogSource` to enable data collection from a custom source.
     */
    public suspend fun createAwsLogSource(input: CreateAwsLogSourceRequest): CreateAwsLogSourceResponse

    /**
     * Adds a third-party custom source in Amazon Security Lake, from the Amazon Web Services Region where you want to create a custom source. Security Lake can collect logs and events from third-party custom sources. After creating the appropriate IAM role to invoke Glue crawler, use this API to add a custom source name in Security Lake. This operation creates a partition in the Amazon S3 bucket for Security Lake as the target location for log files from the custom source. In addition, this operation also creates an associated Glue table and an Glue crawler.
     */
    public suspend fun createCustomLogSource(input: CreateCustomLogSourceRequest): CreateCustomLogSourceResponse

    /**
     * Initializes an Amazon Security Lake instance with the provided (or default) configuration. You can enable Security Lake in Amazon Web Services Regions with customized settings before enabling log collection in Regions. To specify particular Regions, configure these Regions using the `configurations` parameter. If you have already enabled Security Lake in a Region when you call this command, the command will update the Region if you provide new configuration parameters. If you have not already enabled Security Lake in the Region when you call this API, it will set up the data lake in the Region with the specified configurations.
     *
     * When you enable Security Lake, it starts ingesting security data after the `CreateAwsLogSource` call. This includes ingesting security data from sources, storing data, and making data accessible to subscribers. Security Lake also enables all the existing settings and resources that it stores or maintains for your Amazon Web Services account in the current Region, including security log and event data. For more information, see the [Amazon Security Lake User Guide](https://docs.aws.amazon.com/security-lake/latest/userguide/what-is-security-lake.html).
     */
    public suspend fun createDataLake(input: CreateDataLakeRequest): CreateDataLakeResponse

    /**
     * Creates the specified notification subscription in Amazon Security Lake for the organization you specify.
     */
    public suspend fun createDataLakeExceptionSubscription(input: CreateDataLakeExceptionSubscriptionRequest): CreateDataLakeExceptionSubscriptionResponse

    /**
     * Automatically enables Amazon Security Lake for new member accounts in your organization. Security Lake is not automatically enabled for any existing member accounts in your organization.
     */
    public suspend fun createDataLakeOrganizationConfiguration(input: CreateDataLakeOrganizationConfigurationRequest = CreateDataLakeOrganizationConfigurationRequest { }): CreateDataLakeOrganizationConfigurationResponse

    /**
     * Creates a subscription permission for accounts that are already enabled in Amazon Security Lake. You can create a subscriber with access to data in the current Amazon Web Services Region.
     */
    public suspend fun createSubscriber(input: CreateSubscriberRequest): CreateSubscriberResponse

    /**
     * Notifies the subscriber when new data is written to the data lake for the sources that the subscriber consumes in Security Lake. You can create only one subscriber notification per subscriber.
     */
    public suspend fun createSubscriberNotification(input: CreateSubscriberNotificationRequest): CreateSubscriberNotificationResponse

    /**
     * Removes a natively supported Amazon Web Service as an Amazon Security Lake source. You can remove a source for one or more Regions. When you remove the source, Security Lake stops collecting data from that source in the specified Regions and accounts, and subscribers can no longer consume new data from the source. However, subscribers can still consume data that Security Lake collected from the source before removal.
     *
     * You can choose any source type in any Amazon Web Services Region for either accounts that are part of a trusted organization or standalone accounts.
     */
    public suspend fun deleteAwsLogSource(input: DeleteAwsLogSourceRequest): DeleteAwsLogSourceResponse

    /**
     * Removes a custom log source from Amazon Security Lake, to stop sending data from the custom source to Security Lake.
     */
    public suspend fun deleteCustomLogSource(input: DeleteCustomLogSourceRequest): DeleteCustomLogSourceResponse

    /**
     * When you disable Amazon Security Lake from your account, Security Lake is disabled in all Amazon Web Services Regions and it stops collecting data from your sources. Also, this API automatically takes steps to remove the account from Security Lake. However, Security Lake retains all of your existing settings and the resources that it created in your Amazon Web Services account in the current Amazon Web Services Region.
     *
     * The `DeleteDataLake` operation does not delete the data that is stored in your Amazon S3 bucket, which is owned by your Amazon Web Services account. For more information, see the [Amazon Security Lake User Guide](https://docs.aws.amazon.com/security-lake/latest/userguide/disable-security-lake.html).
     */
    public suspend fun deleteDataLake(input: DeleteDataLakeRequest): DeleteDataLakeResponse

    /**
     * Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.
     */
    public suspend fun deleteDataLakeExceptionSubscription(input: DeleteDataLakeExceptionSubscriptionRequest = DeleteDataLakeExceptionSubscriptionRequest { }): DeleteDataLakeExceptionSubscriptionResponse

    /**
     * Turns off automatic enablement of Amazon Security Lake for member accounts that are added to an organization in Organizations. Only the delegated Security Lake administrator for an organization can perform this operation. If the delegated Security Lake administrator performs this operation, new member accounts won't automatically contribute data to the data lake.
     */
    public suspend fun deleteDataLakeOrganizationConfiguration(input: DeleteDataLakeOrganizationConfigurationRequest = DeleteDataLakeOrganizationConfigurationRequest { }): DeleteDataLakeOrganizationConfigurationResponse

    /**
     * Deletes the subscription permission and all notification settings for accounts that are already enabled in Amazon Security Lake. When you run `DeleteSubscriber`, the subscriber will no longer consume data from Security Lake and the subscriber is removed. This operation deletes the subscriber and removes access to data in the current Amazon Web Services Region.
     */
    public suspend fun deleteSubscriber(input: DeleteSubscriberRequest): DeleteSubscriberResponse

    /**
     * Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.
     */
    public suspend fun deleteSubscriberNotification(input: DeleteSubscriberNotificationRequest): DeleteSubscriberNotificationResponse

    /**
     * Deletes the Amazon Security Lake delegated administrator account for the organization. This API can only be called by the organization management account. The organization management account cannot be the delegated administrator account.
     */
    public suspend fun deregisterDataLakeDelegatedAdministrator(input: DeregisterDataLakeDelegatedAdministratorRequest = DeregisterDataLakeDelegatedAdministratorRequest { }): DeregisterDataLakeDelegatedAdministratorResponse

    /**
     * Retrieves the details of exception notifications for the account in Amazon Security Lake.
     */
    public suspend fun getDataLakeExceptionSubscription(input: GetDataLakeExceptionSubscriptionRequest = GetDataLakeExceptionSubscriptionRequest { }): GetDataLakeExceptionSubscriptionResponse

    /**
     * Retrieves the configuration that will be automatically set up for accounts added to the organization after the organization has onboarded to Amazon Security Lake. This API does not take input parameters.
     */
    public suspend fun getDataLakeOrganizationConfiguration(input: GetDataLakeOrganizationConfigurationRequest = GetDataLakeOrganizationConfigurationRequest { }): GetDataLakeOrganizationConfigurationResponse

    /**
     * Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts and which sources Security Lake is collecting data from.
     */
    public suspend fun getDataLakeSources(input: GetDataLakeSourcesRequest = GetDataLakeSourcesRequest { }): GetDataLakeSourcesResponse

    /**
     * Retrieves the subscription information for the specified subscription ID. You can get information about a specific subscriber.
     */
    public suspend fun getSubscriber(input: GetSubscriberRequest): GetSubscriberResponse

    /**
     * Lists the Amazon Security Lake exceptions that you can use to find the source of problems and fix them.
     */
    public suspend fun listDataLakeExceptions(input: ListDataLakeExceptionsRequest = ListDataLakeExceptionsRequest { }): ListDataLakeExceptionsResponse

    /**
     * Retrieves the Amazon Security Lake configuration object for the specified Amazon Web Services Regions. You can use this operation to determine whether Security Lake is enabled for a Region.
     */
    public suspend fun listDataLakes(input: ListDataLakesRequest = ListDataLakesRequest { }): ListDataLakesResponse

    /**
     * Retrieves the log sources in the current Amazon Web Services Region.
     */
    public suspend fun listLogSources(input: ListLogSourcesRequest = ListLogSourcesRequest { }): ListLogSourcesResponse

    /**
     * List all subscribers for the specific Amazon Security Lake account ID. You can retrieve a list of subscriptions associated with a specific organization or Amazon Web Services account.
     */
    public suspend fun listSubscribers(input: ListSubscribersRequest = ListSubscribersRequest { }): ListSubscribersResponse

    /**
     * Retrieves the tags (keys and values) that are associated with an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Designates the Amazon Security Lake delegated administrator account for the organization. This API can only be called by the organization management account. The organization management account cannot be the delegated administrator account.
     */
    public suspend fun registerDataLakeDelegatedAdministrator(input: RegisterDataLakeDelegatedAdministratorRequest): RegisterDataLakeDelegatedAdministratorResponse

    /**
     * Adds or updates one or more tags that are associated with an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region. A *tag* is a label that you can define and associate with Amazon Web Services resources. Each tag consists of a required *tag key* and an associated *tag value*. A *tag key* is a general label that acts as a category for a more specific tag value. A *tag value* acts as a descriptor for a tag key. Tags can help you identify, categorize, and manage resources in different ways, such as by owner, environment, or other criteria. For more information, see [Tagging Amazon Security Lake resources](https://docs.aws.amazon.com/security-lake/latest/userguide/tagging-resources.html) in the *Amazon Security Lake User Guide*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags (keys and values) from an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Specifies where to store your security data and for how long. You can add a rollup Region to consolidate data from multiple Amazon Web Services Regions.
     */
    public suspend fun updateDataLake(input: UpdateDataLakeRequest): UpdateDataLakeResponse

    /**
     * Updates the specified notification subscription in Amazon Security Lake for the organization you specify.
     */
    public suspend fun updateDataLakeExceptionSubscription(input: UpdateDataLakeExceptionSubscriptionRequest): UpdateDataLakeExceptionSubscriptionResponse

    /**
     * Updates an existing subscription for the given Amazon Security Lake account ID. You can update a subscriber by changing the sources that the subscriber consumes data from.
     */
    public suspend fun updateSubscriber(input: UpdateSubscriberRequest): UpdateSubscriberResponse

    /**
     * Updates an existing notification method for the subscription (SQS or HTTPs endpoint) or switches the notification subscription endpoint for a subscriber.
     */
    public suspend fun updateSubscriberNotification(input: UpdateSubscriberNotificationRequest): UpdateSubscriberNotificationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SecurityLakeClient.withConfig(block: SecurityLakeClient.Config.Builder.() -> Unit): SecurityLakeClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSecurityLakeClient(newConfig)
}

/**
 * Adds a natively supported Amazon Web Service as an Amazon Security Lake source. Enables source types for member accounts in required Amazon Web Services Regions, based on the parameters you specify. You can choose any source type in any Region for either accounts that are part of a trusted organization or standalone accounts. Once you add an Amazon Web Service as a source, Security Lake starts collecting logs and events from it.
 *
 * You can use this API only to enable natively supported Amazon Web Services as a source. Use `CreateCustomLogSource` to enable data collection from a custom source.
 */
public suspend inline fun SecurityLakeClient.createAwsLogSource(crossinline block: CreateAwsLogSourceRequest.Builder.() -> Unit): CreateAwsLogSourceResponse = createAwsLogSource(CreateAwsLogSourceRequest.Builder().apply(block).build())

/**
 * Adds a third-party custom source in Amazon Security Lake, from the Amazon Web Services Region where you want to create a custom source. Security Lake can collect logs and events from third-party custom sources. After creating the appropriate IAM role to invoke Glue crawler, use this API to add a custom source name in Security Lake. This operation creates a partition in the Amazon S3 bucket for Security Lake as the target location for log files from the custom source. In addition, this operation also creates an associated Glue table and an Glue crawler.
 */
public suspend inline fun SecurityLakeClient.createCustomLogSource(crossinline block: CreateCustomLogSourceRequest.Builder.() -> Unit): CreateCustomLogSourceResponse = createCustomLogSource(CreateCustomLogSourceRequest.Builder().apply(block).build())

/**
 * Initializes an Amazon Security Lake instance with the provided (or default) configuration. You can enable Security Lake in Amazon Web Services Regions with customized settings before enabling log collection in Regions. To specify particular Regions, configure these Regions using the `configurations` parameter. If you have already enabled Security Lake in a Region when you call this command, the command will update the Region if you provide new configuration parameters. If you have not already enabled Security Lake in the Region when you call this API, it will set up the data lake in the Region with the specified configurations.
 *
 * When you enable Security Lake, it starts ingesting security data after the `CreateAwsLogSource` call. This includes ingesting security data from sources, storing data, and making data accessible to subscribers. Security Lake also enables all the existing settings and resources that it stores or maintains for your Amazon Web Services account in the current Region, including security log and event data. For more information, see the [Amazon Security Lake User Guide](https://docs.aws.amazon.com/security-lake/latest/userguide/what-is-security-lake.html).
 */
public suspend inline fun SecurityLakeClient.createDataLake(crossinline block: CreateDataLakeRequest.Builder.() -> Unit): CreateDataLakeResponse = createDataLake(CreateDataLakeRequest.Builder().apply(block).build())

/**
 * Creates the specified notification subscription in Amazon Security Lake for the organization you specify.
 */
public suspend inline fun SecurityLakeClient.createDataLakeExceptionSubscription(crossinline block: CreateDataLakeExceptionSubscriptionRequest.Builder.() -> Unit): CreateDataLakeExceptionSubscriptionResponse = createDataLakeExceptionSubscription(CreateDataLakeExceptionSubscriptionRequest.Builder().apply(block).build())

/**
 * Automatically enables Amazon Security Lake for new member accounts in your organization. Security Lake is not automatically enabled for any existing member accounts in your organization.
 */
public suspend inline fun SecurityLakeClient.createDataLakeOrganizationConfiguration(crossinline block: CreateDataLakeOrganizationConfigurationRequest.Builder.() -> Unit): CreateDataLakeOrganizationConfigurationResponse = createDataLakeOrganizationConfiguration(CreateDataLakeOrganizationConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a subscription permission for accounts that are already enabled in Amazon Security Lake. You can create a subscriber with access to data in the current Amazon Web Services Region.
 */
public suspend inline fun SecurityLakeClient.createSubscriber(crossinline block: CreateSubscriberRequest.Builder.() -> Unit): CreateSubscriberResponse = createSubscriber(CreateSubscriberRequest.Builder().apply(block).build())

/**
 * Notifies the subscriber when new data is written to the data lake for the sources that the subscriber consumes in Security Lake. You can create only one subscriber notification per subscriber.
 */
public suspend inline fun SecurityLakeClient.createSubscriberNotification(crossinline block: CreateSubscriberNotificationRequest.Builder.() -> Unit): CreateSubscriberNotificationResponse = createSubscriberNotification(CreateSubscriberNotificationRequest.Builder().apply(block).build())

/**
 * Removes a natively supported Amazon Web Service as an Amazon Security Lake source. You can remove a source for one or more Regions. When you remove the source, Security Lake stops collecting data from that source in the specified Regions and accounts, and subscribers can no longer consume new data from the source. However, subscribers can still consume data that Security Lake collected from the source before removal.
 *
 * You can choose any source type in any Amazon Web Services Region for either accounts that are part of a trusted organization or standalone accounts.
 */
public suspend inline fun SecurityLakeClient.deleteAwsLogSource(crossinline block: DeleteAwsLogSourceRequest.Builder.() -> Unit): DeleteAwsLogSourceResponse = deleteAwsLogSource(DeleteAwsLogSourceRequest.Builder().apply(block).build())

/**
 * Removes a custom log source from Amazon Security Lake, to stop sending data from the custom source to Security Lake.
 */
public suspend inline fun SecurityLakeClient.deleteCustomLogSource(crossinline block: DeleteCustomLogSourceRequest.Builder.() -> Unit): DeleteCustomLogSourceResponse = deleteCustomLogSource(DeleteCustomLogSourceRequest.Builder().apply(block).build())

/**
 * When you disable Amazon Security Lake from your account, Security Lake is disabled in all Amazon Web Services Regions and it stops collecting data from your sources. Also, this API automatically takes steps to remove the account from Security Lake. However, Security Lake retains all of your existing settings and the resources that it created in your Amazon Web Services account in the current Amazon Web Services Region.
 *
 * The `DeleteDataLake` operation does not delete the data that is stored in your Amazon S3 bucket, which is owned by your Amazon Web Services account. For more information, see the [Amazon Security Lake User Guide](https://docs.aws.amazon.com/security-lake/latest/userguide/disable-security-lake.html).
 */
public suspend inline fun SecurityLakeClient.deleteDataLake(crossinline block: DeleteDataLakeRequest.Builder.() -> Unit): DeleteDataLakeResponse = deleteDataLake(DeleteDataLakeRequest.Builder().apply(block).build())

/**
 * Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.
 */
public suspend inline fun SecurityLakeClient.deleteDataLakeExceptionSubscription(crossinline block: DeleteDataLakeExceptionSubscriptionRequest.Builder.() -> Unit): DeleteDataLakeExceptionSubscriptionResponse = deleteDataLakeExceptionSubscription(DeleteDataLakeExceptionSubscriptionRequest.Builder().apply(block).build())

/**
 * Turns off automatic enablement of Amazon Security Lake for member accounts that are added to an organization in Organizations. Only the delegated Security Lake administrator for an organization can perform this operation. If the delegated Security Lake administrator performs this operation, new member accounts won't automatically contribute data to the data lake.
 */
public suspend inline fun SecurityLakeClient.deleteDataLakeOrganizationConfiguration(crossinline block: DeleteDataLakeOrganizationConfigurationRequest.Builder.() -> Unit): DeleteDataLakeOrganizationConfigurationResponse = deleteDataLakeOrganizationConfiguration(DeleteDataLakeOrganizationConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the subscription permission and all notification settings for accounts that are already enabled in Amazon Security Lake. When you run `DeleteSubscriber`, the subscriber will no longer consume data from Security Lake and the subscriber is removed. This operation deletes the subscriber and removes access to data in the current Amazon Web Services Region.
 */
public suspend inline fun SecurityLakeClient.deleteSubscriber(crossinline block: DeleteSubscriberRequest.Builder.() -> Unit): DeleteSubscriberResponse = deleteSubscriber(DeleteSubscriberRequest.Builder().apply(block).build())

/**
 * Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.
 */
public suspend inline fun SecurityLakeClient.deleteSubscriberNotification(crossinline block: DeleteSubscriberNotificationRequest.Builder.() -> Unit): DeleteSubscriberNotificationResponse = deleteSubscriberNotification(DeleteSubscriberNotificationRequest.Builder().apply(block).build())

/**
 * Deletes the Amazon Security Lake delegated administrator account for the organization. This API can only be called by the organization management account. The organization management account cannot be the delegated administrator account.
 */
public suspend inline fun SecurityLakeClient.deregisterDataLakeDelegatedAdministrator(crossinline block: DeregisterDataLakeDelegatedAdministratorRequest.Builder.() -> Unit): DeregisterDataLakeDelegatedAdministratorResponse = deregisterDataLakeDelegatedAdministrator(DeregisterDataLakeDelegatedAdministratorRequest.Builder().apply(block).build())

/**
 * Retrieves the details of exception notifications for the account in Amazon Security Lake.
 */
public suspend inline fun SecurityLakeClient.getDataLakeExceptionSubscription(crossinline block: GetDataLakeExceptionSubscriptionRequest.Builder.() -> Unit): GetDataLakeExceptionSubscriptionResponse = getDataLakeExceptionSubscription(GetDataLakeExceptionSubscriptionRequest.Builder().apply(block).build())

/**
 * Retrieves the configuration that will be automatically set up for accounts added to the organization after the organization has onboarded to Amazon Security Lake. This API does not take input parameters.
 */
public suspend inline fun SecurityLakeClient.getDataLakeOrganizationConfiguration(crossinline block: GetDataLakeOrganizationConfigurationRequest.Builder.() -> Unit): GetDataLakeOrganizationConfigurationResponse = getDataLakeOrganizationConfiguration(GetDataLakeOrganizationConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts and which sources Security Lake is collecting data from.
 */
public suspend inline fun SecurityLakeClient.getDataLakeSources(crossinline block: GetDataLakeSourcesRequest.Builder.() -> Unit): GetDataLakeSourcesResponse = getDataLakeSources(GetDataLakeSourcesRequest.Builder().apply(block).build())

/**
 * Retrieves the subscription information for the specified subscription ID. You can get information about a specific subscriber.
 */
public suspend inline fun SecurityLakeClient.getSubscriber(crossinline block: GetSubscriberRequest.Builder.() -> Unit): GetSubscriberResponse = getSubscriber(GetSubscriberRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Security Lake exceptions that you can use to find the source of problems and fix them.
 */
public suspend inline fun SecurityLakeClient.listDataLakeExceptions(crossinline block: ListDataLakeExceptionsRequest.Builder.() -> Unit): ListDataLakeExceptionsResponse = listDataLakeExceptions(ListDataLakeExceptionsRequest.Builder().apply(block).build())

/**
 * Retrieves the Amazon Security Lake configuration object for the specified Amazon Web Services Regions. You can use this operation to determine whether Security Lake is enabled for a Region.
 */
public suspend inline fun SecurityLakeClient.listDataLakes(crossinline block: ListDataLakesRequest.Builder.() -> Unit): ListDataLakesResponse = listDataLakes(ListDataLakesRequest.Builder().apply(block).build())

/**
 * Retrieves the log sources in the current Amazon Web Services Region.
 */
public suspend inline fun SecurityLakeClient.listLogSources(crossinline block: ListLogSourcesRequest.Builder.() -> Unit): ListLogSourcesResponse = listLogSources(ListLogSourcesRequest.Builder().apply(block).build())

/**
 * List all subscribers for the specific Amazon Security Lake account ID. You can retrieve a list of subscriptions associated with a specific organization or Amazon Web Services account.
 */
public suspend inline fun SecurityLakeClient.listSubscribers(crossinline block: ListSubscribersRequest.Builder.() -> Unit): ListSubscribersResponse = listSubscribers(ListSubscribersRequest.Builder().apply(block).build())

/**
 * Retrieves the tags (keys and values) that are associated with an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region.
 */
public suspend inline fun SecurityLakeClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Designates the Amazon Security Lake delegated administrator account for the organization. This API can only be called by the organization management account. The organization management account cannot be the delegated administrator account.
 */
public suspend inline fun SecurityLakeClient.registerDataLakeDelegatedAdministrator(crossinline block: RegisterDataLakeDelegatedAdministratorRequest.Builder.() -> Unit): RegisterDataLakeDelegatedAdministratorResponse = registerDataLakeDelegatedAdministrator(RegisterDataLakeDelegatedAdministratorRequest.Builder().apply(block).build())

/**
 * Adds or updates one or more tags that are associated with an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region. A *tag* is a label that you can define and associate with Amazon Web Services resources. Each tag consists of a required *tag key* and an associated *tag value*. A *tag key* is a general label that acts as a category for a more specific tag value. A *tag value* acts as a descriptor for a tag key. Tags can help you identify, categorize, and manage resources in different ways, such as by owner, environment, or other criteria. For more information, see [Tagging Amazon Security Lake resources](https://docs.aws.amazon.com/security-lake/latest/userguide/tagging-resources.html) in the *Amazon Security Lake User Guide*.
 */
public suspend inline fun SecurityLakeClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags (keys and values) from an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region.
 */
public suspend inline fun SecurityLakeClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Specifies where to store your security data and for how long. You can add a rollup Region to consolidate data from multiple Amazon Web Services Regions.
 */
public suspend inline fun SecurityLakeClient.updateDataLake(crossinline block: UpdateDataLakeRequest.Builder.() -> Unit): UpdateDataLakeResponse = updateDataLake(UpdateDataLakeRequest.Builder().apply(block).build())

/**
 * Updates the specified notification subscription in Amazon Security Lake for the organization you specify.
 */
public suspend inline fun SecurityLakeClient.updateDataLakeExceptionSubscription(crossinline block: UpdateDataLakeExceptionSubscriptionRequest.Builder.() -> Unit): UpdateDataLakeExceptionSubscriptionResponse = updateDataLakeExceptionSubscription(UpdateDataLakeExceptionSubscriptionRequest.Builder().apply(block).build())

/**
 * Updates an existing subscription for the given Amazon Security Lake account ID. You can update a subscriber by changing the sources that the subscriber consumes data from.
 */
public suspend inline fun SecurityLakeClient.updateSubscriber(crossinline block: UpdateSubscriberRequest.Builder.() -> Unit): UpdateSubscriberResponse = updateSubscriber(UpdateSubscriberRequest.Builder().apply(block).build())

/**
 * Updates an existing notification method for the subscription (SQS or HTTPs endpoint) or switches the notification subscription endpoint for a subscriber.
 */
public suspend inline fun SecurityLakeClient.updateSubscriberNotification(crossinline block: UpdateSubscriberNotificationRequest.Builder.() -> Unit): UpdateSubscriberNotificationResponse = updateSubscriberNotification(UpdateSubscriberNotificationRequest.Builder().apply(block).build())
