// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.serde

import aws.sdk.kotlin.services.securitylake.model.GetDataLakeExceptionSubscriptionResponse
import aws.sdk.kotlin.services.securitylake.model.SecurityLakeException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDataLakeExceptionSubscriptionOperationDeserializer: HttpDeserialize<GetDataLakeExceptionSubscriptionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetDataLakeExceptionSubscriptionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDataLakeExceptionSubscriptionError(context, call)
        }
        val builder = GetDataLakeExceptionSubscriptionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDataLakeExceptionSubscriptionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetDataLakeExceptionSubscriptionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SecurityLakeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SecurityLakeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDataLakeExceptionSubscriptionOperationBody(builder: GetDataLakeExceptionSubscriptionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXCEPTIONTIMETOLIVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("exceptionTimeToLive"))
    val NOTIFICATIONENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("notificationEndpoint"))
    val SUBSCRIPTIONPROTOCOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("subscriptionProtocol"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXCEPTIONTIMETOLIVE_DESCRIPTOR)
        field(NOTIFICATIONENDPOINT_DESCRIPTOR)
        field(SUBSCRIPTIONPROTOCOL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXCEPTIONTIMETOLIVE_DESCRIPTOR.index -> builder.exceptionTimeToLive = deserializeLong()
                NOTIFICATIONENDPOINT_DESCRIPTOR.index -> builder.notificationEndpoint = deserializeString()
                SUBSCRIPTIONPROTOCOL_DESCRIPTOR.index -> builder.subscriptionProtocol = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
