// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.paginators

import aws.sdk.kotlin.services.securitylake.SecurityLakeClient
import aws.sdk.kotlin.services.securitylake.model.DataLakeException
import aws.sdk.kotlin.services.securitylake.model.ListDataLakeExceptionsRequest
import aws.sdk.kotlin.services.securitylake.model.ListDataLakeExceptionsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListDataLakeExceptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataLakeExceptionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataLakeExceptionsResponse]
 */
public fun SecurityLakeClient.listDataLakeExceptionsPaginated(initialRequest: ListDataLakeExceptionsRequest = ListDataLakeExceptionsRequest { }): Flow<ListDataLakeExceptionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataLakeExceptionsPaginated.listDataLakeExceptions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDataLakeExceptionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataLakeExceptionsResponse]
 */
public fun SecurityLakeClient.listDataLakeExceptionsPaginated(block: ListDataLakeExceptionsRequest.Builder.() -> Unit): Flow<ListDataLakeExceptionsResponse> =
    listDataLakeExceptionsPaginated(ListDataLakeExceptionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataLakeExceptionsPaginated]
 * to access the nested member [DataLakeException]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataLakeException]
 */
@JvmName("listDataLakeExceptionsResponseDataLakeException")
public fun Flow<ListDataLakeExceptionsResponse>.exceptions(): Flow<DataLakeException> =
    transform() { response ->
        response.exceptions?.forEach {
            emit(it)
        }
    }
