// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.model



public class GetDataLakeSourcesRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID for which a static snapshot of the current Amazon Web Services Region, including enabled accounts and log sources, is retrieved.
     */
    public val accounts: List<String>? = builder.accounts
    /**
     * The maximum limit of accounts for which the static snapshot of the current Region, including enabled accounts and log sources, is retrieved.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Lists if there are more results available. The value of nextToken is a unique pagination token for each page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.
     *
     * Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securitylake.model.GetDataLakeSourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDataLakeSourcesRequest(")
        append("accounts=$accounts,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accounts?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDataLakeSourcesRequest

        if (accounts != other.accounts) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securitylake.model.GetDataLakeSourcesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID for which a static snapshot of the current Amazon Web Services Region, including enabled accounts and log sources, is retrieved.
         */
        public var accounts: List<String>? = null
        /**
         * The maximum limit of accounts for which the static snapshot of the current Region, including enabled accounts and log sources, is retrieved.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Lists if there are more results available. The value of nextToken is a unique pagination token for each page. Repeat the call using the returned token to retrieve the next page. Keep all other arguments unchanged.
         *
         * Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securitylake.model.GetDataLakeSourcesRequest) : this() {
            this.accounts = x.accounts
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securitylake.model.GetDataLakeSourcesRequest = GetDataLakeSourcesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
