// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.model



/**
 * Provides details of Amazon Security Lake object.
 */
public class DataLakeResource private constructor(builder: Builder) {
    /**
     * Retrieves the status of the configuration operation for an account in Amazon Security Lake.
     */
    public val createStatus: aws.sdk.kotlin.services.securitylake.model.DataLakeStatus? = builder.createStatus
    /**
     * The Amazon Resource Name (ARN) created by you to provide to the subscriber. For more information about ARNs and how to use them in policies, see the [Amazon Security Lake User Guide](https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html).
     */
    public val dataLakeArn: kotlin.String = requireNotNull(builder.dataLakeArn) { "A non-null value must be provided for dataLakeArn" }
    /**
     * Provides encryption details of Amazon Security Lake object.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.securitylake.model.DataLakeEncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * Provides lifecycle details of Amazon Security Lake object.
     */
    public val lifecycleConfiguration: aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleConfiguration? = builder.lifecycleConfiguration
    /**
     * The Amazon Web Services Regions where Security Lake is enabled.
     */
    public val region: kotlin.String = requireNotNull(builder.region) { "A non-null value must be provided for region" }
    /**
     * Provides replication details of Amazon Security Lake object.
     */
    public val replicationConfiguration: aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration? = builder.replicationConfiguration
    /**
     * The ARN for the Amazon Security Lake Amazon S3 bucket.
     */
    public val s3BucketArn: kotlin.String? = builder.s3BucketArn
    /**
     * The status of the last `UpdateDataLake `or `DeleteDataLake` API request.
     */
    public val updateStatus: aws.sdk.kotlin.services.securitylake.model.DataLakeUpdateStatus? = builder.updateStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securitylake.model.DataLakeResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataLakeResource(")
        append("createStatus=$createStatus,")
        append("dataLakeArn=$dataLakeArn,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("lifecycleConfiguration=$lifecycleConfiguration,")
        append("region=$region,")
        append("replicationConfiguration=$replicationConfiguration,")
        append("s3BucketArn=$s3BucketArn,")
        append("updateStatus=$updateStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createStatus?.hashCode() ?: 0
        result = 31 * result + (dataLakeArn.hashCode())
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (lifecycleConfiguration?.hashCode() ?: 0)
        result = 31 * result + (region.hashCode())
        result = 31 * result + (replicationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (s3BucketArn?.hashCode() ?: 0)
        result = 31 * result + (updateStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataLakeResource

        if (createStatus != other.createStatus) return false
        if (dataLakeArn != other.dataLakeArn) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (lifecycleConfiguration != other.lifecycleConfiguration) return false
        if (region != other.region) return false
        if (replicationConfiguration != other.replicationConfiguration) return false
        if (s3BucketArn != other.s3BucketArn) return false
        if (updateStatus != other.updateStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securitylake.model.DataLakeResource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Retrieves the status of the configuration operation for an account in Amazon Security Lake.
         */
        public var createStatus: aws.sdk.kotlin.services.securitylake.model.DataLakeStatus? = null
        /**
         * The Amazon Resource Name (ARN) created by you to provide to the subscriber. For more information about ARNs and how to use them in policies, see the [Amazon Security Lake User Guide](https://docs.aws.amazon.com/security-lake/latest/userguide/subscriber-management.html).
         */
        public var dataLakeArn: kotlin.String? = null
        /**
         * Provides encryption details of Amazon Security Lake object.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.securitylake.model.DataLakeEncryptionConfiguration? = null
        /**
         * Provides lifecycle details of Amazon Security Lake object.
         */
        public var lifecycleConfiguration: aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleConfiguration? = null
        /**
         * The Amazon Web Services Regions where Security Lake is enabled.
         */
        public var region: kotlin.String? = null
        /**
         * Provides replication details of Amazon Security Lake object.
         */
        public var replicationConfiguration: aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration? = null
        /**
         * The ARN for the Amazon Security Lake Amazon S3 bucket.
         */
        public var s3BucketArn: kotlin.String? = null
        /**
         * The status of the last `UpdateDataLake `or `DeleteDataLake` API request.
         */
        public var updateStatus: aws.sdk.kotlin.services.securitylake.model.DataLakeUpdateStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securitylake.model.DataLakeResource) : this() {
            this.createStatus = x.createStatus
            this.dataLakeArn = x.dataLakeArn
            this.encryptionConfiguration = x.encryptionConfiguration
            this.lifecycleConfiguration = x.lifecycleConfiguration
            this.region = x.region
            this.replicationConfiguration = x.replicationConfiguration
            this.s3BucketArn = x.s3BucketArn
            this.updateStatus = x.updateStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securitylake.model.DataLakeResource = DataLakeResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.securitylake.model.DataLakeEncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.securitylake.model.DataLakeEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.securitylake.model.DataLakeEncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleConfiguration] inside the given [block]
         */
        public fun lifecycleConfiguration(block: aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleConfiguration.Builder.() -> kotlin.Unit) {
            this.lifecycleConfiguration = aws.sdk.kotlin.services.securitylake.model.DataLakeLifecycleConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration] inside the given [block]
         */
        public fun replicationConfiguration(block: aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration.Builder.() -> kotlin.Unit) {
            this.replicationConfiguration = aws.sdk.kotlin.services.securitylake.model.DataLakeReplicationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.securitylake.model.DataLakeUpdateStatus] inside the given [block]
         */
        public fun updateStatus(block: aws.sdk.kotlin.services.securitylake.model.DataLakeUpdateStatus.Builder.() -> kotlin.Unit) {
            this.updateStatus = aws.sdk.kotlin.services.securitylake.model.DataLakeUpdateStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (dataLakeArn == null) dataLakeArn = ""
            if (region == null) region = ""
            return this
        }
    }
}
