// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.securitylake.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Occurs when a conflict with a previous successful write is detected. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.
 */
public class ConflictException private constructor(builder: Builder) : SecurityLakeException(builder.message) {

    /**
     * The resource name.
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * The resource type.
     */
    public val resourceType: kotlin.String? = builder.resourceType

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.securitylake.model.ConflictException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConflictException(")
        append("message=$message,")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConflictException

        if (message != other.message) return false
        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.securitylake.model.ConflictException = Builder(this).apply(block).build()

    public class Builder {
        public var message: kotlin.String? = null
        /**
         * The resource name.
         */
        public var resourceName: kotlin.String? = null
        /**
         * The resource type.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.securitylake.model.ConflictException) : this() {
            this.message = x.message
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.securitylake.model.ConflictException = ConflictException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
